package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  AmazonResourceName,
  TemplateName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ManagedRule(
    templateName: TemplateName,
    resourceARN: AmazonResourceName,
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRule = {
    import ManagedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRule
      .builder()
      .templateName(templateName: java.lang.String)
      .resourceARN(resourceARN: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.wrap(buildAwsValue())
}
object ManagedRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.ManagedRule =
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRule(
        templateNameValue,
        resourceARNValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def templateNameValue: TemplateName
    def resourceARNValue: AmazonResourceName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def templateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateNameValue)
    def resourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARNValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly {
    override def templateNameValue: TemplateName =
      impl.templateName(): TemplateName
    override def resourceARNValue: AmazonResourceName =
      impl.resourceARN(): AmazonResourceName
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ): io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly = new Wrapper(
    impl
  )
}
