package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  AmazonResourceName,
  TemplateName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ManagedRuleDescription(
    templateName: Option[TemplateName] = None,
    resourceARN: Option[AmazonResourceName] = None,
    ruleState: Option[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription = {
    import ManagedRuleDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
      .builder()
      .optionallyWith(templateName.map(value => value: java.lang.String))(
        _.templateName
      )
      .optionallyWith(resourceARN.map(value => value: java.lang.String))(
        _.resourceARN
      )
      .optionallyWith(ruleState.map(value => value.buildAwsValue()))(
        _.ruleState
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription
      .wrap(buildAwsValue())
}
object ManagedRuleDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription =
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription(
        templateNameValue.map(value => value),
        resourceARNValue.map(value => value),
        ruleStateValue.map(value => value.editable)
      )
    def templateNameValue: Option[TemplateName]
    def resourceARNValue: Option[AmazonResourceName]
    def ruleStateValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly
    ]
    def templateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateNameValue)
    def resourceARN: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceARN", resourceARNValue)
    def ruleState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly
    ] = AwsError.unwrapOptionField("ruleState", ruleStateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly {
    override def templateNameValue: Option[TemplateName] =
      scala.Option(impl.templateName()).map(value => value: TemplateName)
    override def resourceARNValue: Option[AmazonResourceName] =
      scala.Option(impl.resourceARN()).map(value => value: AmazonResourceName)
    override def ruleStateValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly
    ] = scala
      .Option(impl.ruleState())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ): io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly =
    new Wrapper(impl)
}
