package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleState,
  InsightRuleName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ManagedRuleState(
    ruleName: InsightRuleName,
    state: InsightRuleState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState = {
    import ManagedRuleState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
      .builder()
      .ruleName(ruleName: java.lang.String)
      .state(state: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState
      .wrap(buildAwsValue())
}
object ManagedRuleState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState =
      io.github.vigoo.zioaws.cloudwatch.model
        .ManagedRuleState(ruleNameValue, stateValue)
    def ruleNameValue: InsightRuleName
    def stateValue: InsightRuleState
    def ruleName: ZIO[Any, Nothing, InsightRuleName] =
      ZIO.succeed(ruleNameValue)
    def state: ZIO[Any, Nothing, InsightRuleState] = ZIO.succeed(stateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly {
    override def ruleNameValue: InsightRuleName =
      impl.ruleName(): InsightRuleName
    override def stateValue: InsightRuleState = impl.state(): InsightRuleState
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ): io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleState.ReadOnly =
    new Wrapper(impl)
}
