package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MessageDataValue,
  MessageDataCode
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MessageData(
    code: Option[MessageDataCode] = None,
    value: Option[MessageDataValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MessageData = {
    import MessageData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MessageData
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MessageData.wrap(buildAwsValue())
}
object MessageData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MessageData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MessageData =
      io.github.vigoo.zioaws.cloudwatch.model.MessageData(
        codeValue.map(value => value),
        valueValue.map(value => value)
      )
    def codeValue: Option[MessageDataCode]
    def valueValue: Option[MessageDataValue]
    def code: ZIO[Any, AwsError, MessageDataCode] =
      AwsError.unwrapOptionField("code", codeValue)
    def value: ZIO[Any, AwsError, MessageDataValue] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MessageData
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly {
    override def codeValue: Option[MessageDataCode] =
      scala.Option(impl.code()).map(value => value: MessageDataCode)
    override def valueValue: Option[MessageDataValue] =
      scala.Option(impl.value()).map(value => value: MessageDataValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MessageData
  ): io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly = new Wrapper(
    impl
  )
}
