package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  Namespace
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Metric(
    namespace: Option[Namespace] = None,
    metricName: Option[MetricName] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Metric = {
    import Metric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Metric
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.Metric.wrap(buildAwsValue())
}
object Metric {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudwatch.model.Metric] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.Metric =
      io.github.vigoo.zioaws.cloudwatch.model.Metric(
        namespaceValue.map(value => value),
        metricNameValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def namespaceValue: Option[Namespace]
    def metricNameValue: Option[MetricName]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Metric
  ) extends io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly {
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Metric
  ): io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly = new Wrapper(impl)
}
