package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  StateReason,
  ExtendedStatistic,
  DatapointsToAlarm,
  ActionsEnabled,
  Namespace,
  AlarmName,
  Timestamp,
  EvaluateLowSampleCountPercentile,
  Period,
  MetricId,
  AlarmArn,
  EvaluationPeriods,
  AlarmDescription,
  TreatMissingData,
  StateReasonData,
  ResourceName,
  Threshold
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MetricAlarm(
    alarmName: Option[AlarmName] = None,
    alarmArn: Option[AlarmArn] = None,
    alarmDescription: Option[AlarmDescription] = None,
    alarmConfigurationUpdatedTimestamp: Option[Timestamp] = None,
    actionsEnabled: Option[ActionsEnabled] = None,
    okActions: Option[Iterable[ResourceName]] = None,
    alarmActions: Option[Iterable[ResourceName]] = None,
    insufficientDataActions: Option[Iterable[ResourceName]] = None,
    stateValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] =
      None,
    stateReason: Option[StateReason] = None,
    stateReasonData: Option[StateReasonData] = None,
    stateUpdatedTimestamp: Option[Timestamp] = None,
    metricName: Option[MetricName] = None,
    namespace: Option[Namespace] = None,
    statistic: Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = None,
    extendedStatistic: Option[ExtendedStatistic] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    period: Option[Period] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None,
    evaluationPeriods: Option[EvaluationPeriods] = None,
    datapointsToAlarm: Option[DatapointsToAlarm] = None,
    threshold: Option[Threshold] = None,
    comparisonOperator: Option[
      io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator
    ] = None,
    treatMissingData: Option[TreatMissingData] = None,
    evaluateLowSampleCountPercentile: Option[EvaluateLowSampleCountPercentile] =
      None,
    metrics: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery]
    ] = None,
    thresholdMetricId: Option[MetricId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricAlarm = {
    import MetricAlarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
      .builder()
      .optionallyWith(alarmName.map(value => value: java.lang.String))(
        _.alarmName
      )
      .optionallyWith(alarmArn.map(value => value: java.lang.String))(
        _.alarmArn
      )
      .optionallyWith(alarmDescription.map(value => value: java.lang.String))(
        _.alarmDescription
      )
      .optionallyWith(
        alarmConfigurationUpdatedTimestamp.map(value => value: Instant)
      )(_.alarmConfigurationUpdatedTimestamp)
      .optionallyWith(actionsEnabled.map(value => value: java.lang.Boolean))(
        _.actionsEnabled
      )
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(stateReason.map(value => value: java.lang.String))(
        _.stateReason
      )
      .optionallyWith(stateReasonData.map(value => value: java.lang.String))(
        _.stateReasonData
      )
      .optionallyWith(stateUpdatedTimestamp.map(value => value: Instant))(
        _.stateUpdatedTimestamp
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(extendedStatistic.map(value => value: java.lang.String))(
        _.extendedStatistic
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(evaluationPeriods.map(value => value: Integer))(
        _.evaluationPeriods
      )
      .optionallyWith(datapointsToAlarm.map(value => value: Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(treatMissingData.map(value => value: java.lang.String))(
        _.treatMissingData
      )
      .optionallyWith(
        evaluateLowSampleCountPercentile.map(value => value: java.lang.String)
      )(_.evaluateLowSampleCountPercentile)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(thresholdMetricId.map(value => value: java.lang.String))(
        _.thresholdMetricId
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.wrap(buildAwsValue())
}
object MetricAlarm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm =
      io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm(
        alarmNameValue.map(value => value),
        alarmArnValue.map(value => value),
        alarmDescriptionValue.map(value => value),
        alarmConfigurationUpdatedTimestampValue.map(value => value),
        actionsEnabledValue.map(value => value),
        okActionsValue.map(value => value),
        alarmActionsValue.map(value => value),
        insufficientDataActionsValue.map(value => value),
        stateValueValue.map(value => value),
        stateReasonValue.map(value => value),
        stateReasonDataValue.map(value => value),
        stateUpdatedTimestampValue.map(value => value),
        metricNameValue.map(value => value),
        namespaceValue.map(value => value),
        statisticValue.map(value => value),
        extendedStatisticValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        periodValue.map(value => value),
        unitValue.map(value => value),
        evaluationPeriodsValue.map(value => value),
        datapointsToAlarmValue.map(value => value),
        thresholdValue.map(value => value),
        comparisonOperatorValue.map(value => value),
        treatMissingDataValue.map(value => value),
        evaluateLowSampleCountPercentileValue.map(value => value),
        metricsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        thresholdMetricIdValue.map(value => value)
      )
    def alarmNameValue: Option[AlarmName]
    def alarmArnValue: Option[AlarmArn]
    def alarmDescriptionValue: Option[AlarmDescription]
    def alarmConfigurationUpdatedTimestampValue: Option[Timestamp]
    def actionsEnabledValue: Option[ActionsEnabled]
    def okActionsValue: Option[List[ResourceName]]
    def alarmActionsValue: Option[List[ResourceName]]
    def insufficientDataActionsValue: Option[List[ResourceName]]
    def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue]
    def stateReasonValue: Option[StateReason]
    def stateReasonDataValue: Option[StateReasonData]
    def stateUpdatedTimestampValue: Option[Timestamp]
    def metricNameValue: Option[MetricName]
    def namespaceValue: Option[Namespace]
    def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic]
    def extendedStatisticValue: Option[ExtendedStatistic]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def periodValue: Option[Period]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def evaluationPeriodsValue: Option[EvaluationPeriods]
    def datapointsToAlarmValue: Option[DatapointsToAlarm]
    def thresholdValue: Option[Threshold]
    def comparisonOperatorValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator]
    def treatMissingDataValue: Option[TreatMissingData]
    def evaluateLowSampleCountPercentileValue
        : Option[EvaluateLowSampleCountPercentile]
    def metricsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ]
    def thresholdMetricIdValue: Option[MetricId]
    def alarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def alarmArn: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("alarmArn", alarmArnValue)
    def alarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescriptionValue)
    def alarmConfigurationUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "alarmConfigurationUpdatedTimestamp",
        alarmConfigurationUpdatedTimestampValue
      )
    def actionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabledValue)
    def okActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActionsValue)
    def alarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActionsValue)
    def insufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActionsValue
      )
    def stateValue: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StateValue
    ] = AwsError.unwrapOptionField("stateValue", stateValueValue)
    def stateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReasonValue)
    def stateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonDataValue)
    def stateUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("stateUpdatedTimestamp", stateUpdatedTimestampValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def statistic: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.Statistic
    ] = AwsError.unwrapOptionField("statistic", statisticValue)
    def extendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatisticValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def period: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", periodValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def evaluationPeriods: ZIO[Any, AwsError, EvaluationPeriods] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriodsValue)
    def datapointsToAlarm: ZIO[Any, AwsError, DatapointsToAlarm] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def threshold: ZIO[Any, AwsError, Threshold] =
      AwsError.unwrapOptionField("threshold", thresholdValue)
    def comparisonOperator: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator
    ] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperatorValue)
    def treatMissingData: ZIO[Any, AwsError, TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def evaluateLowSampleCountPercentile
        : ZIO[Any, AwsError, EvaluateLowSampleCountPercentile] =
      AwsError.unwrapOptionField(
        "evaluateLowSampleCountPercentile",
        evaluateLowSampleCountPercentileValue
      )
    def metrics: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metricsValue)
    def thresholdMetricId: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("thresholdMetricId", thresholdMetricIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly {
    override def alarmNameValue: Option[AlarmName] =
      scala.Option(impl.alarmName()).map(value => value: AlarmName)
    override def alarmArnValue: Option[AlarmArn] =
      scala.Option(impl.alarmArn()).map(value => value: AlarmArn)
    override def alarmDescriptionValue: Option[AlarmDescription] = scala
      .Option(impl.alarmDescription())
      .map(value => value: AlarmDescription)
    override def alarmConfigurationUpdatedTimestampValue: Option[Timestamp] =
      scala
        .Option(impl.alarmConfigurationUpdatedTimestamp())
        .map(value => value: Timestamp)
    override def actionsEnabledValue: Option[ActionsEnabled] =
      scala.Option(impl.actionsEnabled()).map(value => value: ActionsEnabled)
    override def okActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def alarmActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.alarmActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def insufficientDataActionsValue: Option[List[ResourceName]] =
      scala
        .Option(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            item: ResourceName
          }.toList
        )
    override def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] = scala
      .Option(impl.stateValue())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StateValue.wrap(value)
      )
    override def stateReasonValue: Option[StateReason] =
      scala.Option(impl.stateReason()).map(value => value: StateReason)
    override def stateReasonDataValue: Option[StateReasonData] =
      scala.Option(impl.stateReasonData()).map(value => value: StateReasonData)
    override def stateUpdatedTimestampValue: Option[Timestamp] =
      scala.Option(impl.stateUpdatedTimestamp()).map(value => value: Timestamp)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = scala
      .Option(impl.statistic())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.Statistic.wrap(value)
      )
    override def extendedStatisticValue: Option[ExtendedStatistic] = scala
      .Option(impl.extendedStatistic())
      .map(value => value: ExtendedStatistic)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def periodValue: Option[Period] =
      scala.Option(impl.period()).map(value => value: Period)
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
    override def evaluationPeriodsValue: Option[EvaluationPeriods] = scala
      .Option(impl.evaluationPeriods())
      .map(value => value: EvaluationPeriods)
    override def datapointsToAlarmValue: Option[DatapointsToAlarm] = scala
      .Option(impl.datapointsToAlarm())
      .map(value => value: DatapointsToAlarm)
    override def thresholdValue: Option[Threshold] =
      scala.Option(impl.threshold()).map(value => value: Threshold)
    override def comparisonOperatorValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator] =
      scala
        .Option(impl.comparisonOperator())
        .map(value =>
          io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator.wrap(value)
        )
    override def treatMissingDataValue: Option[TreatMissingData] = scala
      .Option(impl.treatMissingData())
      .map(value => value: TreatMissingData)
    override def evaluateLowSampleCountPercentileValue
        : Option[EvaluateLowSampleCountPercentile] = scala
      .Option(impl.evaluateLowSampleCountPercentile())
      .map(value => value: EvaluateLowSampleCountPercentile)
    override def metricsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.wrap(item)
        }.toList
      )
    override def thresholdMetricIdValue: Option[MetricId] =
      scala.Option(impl.thresholdMetricId()).map(value => value: MetricId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly = new Wrapper(
    impl
  )
}
