package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricLabel,
  ReturnData,
  AccountId,
  Period,
  MetricId,
  MetricExpression
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricDataQuery(
    id: MetricId,
    metricStat: Option[io.github.vigoo.zioaws.cloudwatch.model.MetricStat] =
      None,
    expression: Option[MetricExpression] = None,
    label: Option[MetricLabel] = None,
    returnData: Option[ReturnData] = None,
    period: Option[Period] = None,
    accountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery = {
    import MetricDataQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(metricStat.map(value => value.buildAwsValue()))(
        _.metricStat
      )
      .optionallyWith(expression.map(value => value: java.lang.String))(
        _.expression
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(returnData.map(value => value: java.lang.Boolean))(
        _.returnData
      )
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery
      .wrap(buildAwsValue())
}
object MetricDataQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery =
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery(
        idValue,
        metricStatValue.map(value => value.editable),
        expressionValue.map(value => value),
        labelValue.map(value => value),
        returnDataValue.map(value => value),
        periodValue.map(value => value),
        accountIdValue.map(value => value)
      )
    def idValue: MetricId
    def metricStatValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly]
    def expressionValue: Option[MetricExpression]
    def labelValue: Option[MetricLabel]
    def returnDataValue: Option[ReturnData]
    def periodValue: Option[Period]
    def accountIdValue: Option[AccountId]
    def id: ZIO[Any, Nothing, MetricId] = ZIO.succeed(idValue)
    def metricStat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly
    ] = AwsError.unwrapOptionField("metricStat", metricStatValue)
    def expression: ZIO[Any, AwsError, MetricExpression] =
      AwsError.unwrapOptionField("expression", expressionValue)
    def label: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", labelValue)
    def returnData: ZIO[Any, AwsError, ReturnData] =
      AwsError.unwrapOptionField("returnData", returnDataValue)
    def period: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", periodValue)
    def accountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly {
    override def idValue: MetricId = impl.id(): MetricId
    override def metricStatValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly] =
      scala
        .Option(impl.metricStat())
        .map(value =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStat.wrap(value)
        )
    override def expressionValue: Option[MetricExpression] =
      scala.Option(impl.expression()).map(value => value: MetricExpression)
    override def labelValue: Option[MetricLabel] =
      scala.Option(impl.label()).map(value => value: MetricLabel)
    override def returnDataValue: Option[ReturnData] =
      scala.Option(impl.returnData()).map(value => value: ReturnData)
    override def periodValue: Option[Period] =
      scala.Option(impl.period()).map(value => value: Period)
    override def accountIdValue: Option[AccountId] =
      scala.Option(impl.accountId()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly =
    new Wrapper(impl)
}
