package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  DatapointValue,
  Timestamp,
  MetricLabel,
  MetricId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricDataResult(
    id: Option[MetricId] = None,
    label: Option[MetricLabel] = None,
    timestamps: Option[Iterable[Timestamp]] = None,
    values: Option[Iterable[DatapointValue]] = None,
    statusCode: Option[io.github.vigoo.zioaws.cloudwatch.model.StatusCode] =
      None,
    messages: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MessageData]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDataResult = {
    import MetricDataResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            item: Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult
      .wrap(buildAwsValue())
}
object MetricDataResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult =
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult(
        idValue.map(value => value),
        labelValue.map(value => value),
        timestampsValue.map(value => value),
        valuesValue.map(value => value),
        statusCodeValue.map(value => value),
        messagesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def idValue: Option[MetricId]
    def labelValue: Option[MetricLabel]
    def timestampsValue: Option[List[Timestamp]]
    def valuesValue: Option[List[DatapointValue]]
    def statusCodeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StatusCode]
    def messagesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly]
    ]
    def id: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("id", idValue)
    def label: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", labelValue)
    def timestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestampsValue)
    def values: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def statusCode: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCodeValue)
    def messages: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messagesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly {
    override def idValue: Option[MetricId] =
      scala.Option(impl.id()).map(value => value: MetricId)
    override def labelValue: Option[MetricLabel] =
      scala.Option(impl.label()).map(value => value: MetricLabel)
    override def timestampsValue: Option[List[Timestamp]] = scala
      .Option(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          item: Timestamp
        }.toList
      )
    override def valuesValue: Option[List[DatapointValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: DatapointValue
        }.toList
      )
    override def statusCodeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StatusCode] = scala
      .Option(impl.statusCode())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StatusCode.wrap(value)
      )
    override def messagesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly]
    ] = scala
      .Option(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MessageData.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly =
    new Wrapper(impl)
}
