package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  StorageResolution,
  DatapointValue,
  Timestamp,
  MetricName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MetricDatum(
    metricName: MetricName,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    timestamp: Option[Timestamp] = None,
    value: Option[DatapointValue] = None,
    statisticValues: Option[
      io.github.vigoo.zioaws.cloudwatch.model.StatisticSet
    ] = None,
    values: Option[Iterable[DatapointValue]] = None,
    counts: Option[Iterable[DatapointValue]] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None,
    storageResolution: Option[StorageResolution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDatum = {
    import MetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDatum
      .builder()
      .metricName(metricName: java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(timestamp.map(value => value: Instant))(_.timestamp)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .optionallyWith(statisticValues.map(value => value.buildAwsValue()))(
        _.statisticValues
      )
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        counts.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.counts)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(storageResolution.map(value => value: Integer))(
        _.storageResolution
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.wrap(buildAwsValue())
}
object MetricDatum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricDatum =
      io.github.vigoo.zioaws.cloudwatch.model.MetricDatum(
        metricNameValue,
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        timestampValue.map(value => value),
        valueValue.map(value => value),
        statisticValuesValue.map(value => value.editable),
        valuesValue.map(value => value),
        countsValue.map(value => value),
        unitValue.map(value => value),
        storageResolutionValue.map(value => value)
      )
    def metricNameValue: MetricName
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def timestampValue: Option[Timestamp]
    def valueValue: Option[DatapointValue]
    def statisticValuesValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly]
    def valuesValue: Option[List[DatapointValue]]
    def countsValue: Option[List[DatapointValue]]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def storageResolutionValue: Option[StorageResolution]
    def metricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def timestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestampValue)
    def value: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("value", valueValue)
    def statisticValues: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly
    ] = AwsError.unwrapOptionField("statisticValues", statisticValuesValue)
    def values: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def counts: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("counts", countsValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def storageResolution: ZIO[Any, AwsError, StorageResolution] =
      AwsError.unwrapOptionField("storageResolution", storageResolutionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly {
    override def metricNameValue: MetricName = impl.metricName(): MetricName
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def timestampValue: Option[Timestamp] =
      scala.Option(impl.timestamp()).map(value => value: Timestamp)
    override def valueValue: Option[DatapointValue] =
      scala.Option(impl.value()).map(value => value: DatapointValue)
    override def statisticValuesValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly
    ] = scala
      .Option(impl.statisticValues())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.wrap(value)
      )
    override def valuesValue: Option[List[DatapointValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: DatapointValue
        }.toList
      )
    override def countsValue: Option[List[DatapointValue]] = scala
      .Option(impl.counts())
      .map(value =>
        value.asScala.map { item =>
          item: DatapointValue
        }.toList
      )
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
    override def storageResolutionValue: Option[StorageResolution] = scala
      .Option(impl.storageResolution())
      .map(value => value: StorageResolution)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly = new Wrapper(
    impl
  )
}
