package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricMathAnomalyDetector(
    metricDataQueries: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector = {
    import MetricMathAnomalyDetector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
      .builder()
      .optionallyWith(
        metricDataQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDataQueries)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector
      .wrap(buildAwsValue())
}
object MetricMathAnomalyDetector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector =
      io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector(
        metricDataQueriesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def metricDataQueriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ]
    def metricDataQueries: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDataQueries", metricDataQueriesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly {
    override def metricDataQueriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ] = scala
      .Option(impl.metricDataQueries())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly =
    new Wrapper(impl)
}
