package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{Stat, Period}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricStat(
    metric: io.github.vigoo.zioaws.cloudwatch.model.Metric,
    period: Period,
    stat: Stat,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStat = {
    import MetricStat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStat
      .builder()
      .metric(metric.buildAwsValue())
      .period(period: Integer)
      .stat(stat: java.lang.String)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricStat.wrap(buildAwsValue())
}
object MetricStat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricStat =
      io.github.vigoo.zioaws.cloudwatch.model.MetricStat(
        metricValue.editable,
        periodValue,
        statValue,
        unitValue.map(value => value)
      )
    def metricValue: io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
    def periodValue: Period
    def statValue: Stat
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def metric: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
    ] = ZIO.succeed(metricValue)
    def period: ZIO[Any, Nothing, Period] = ZIO.succeed(periodValue)
    def stat: ZIO[Any, Nothing, Stat] = ZIO.succeed(statValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly {
    override def metricValue
        : io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly =
      io.github.vigoo.zioaws.cloudwatch.model.Metric.wrap(impl.metric())
    override def periodValue: Period = impl.period(): Period
    override def statValue: Stat = impl.stat(): Stat
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStat.ReadOnly = new Wrapper(
    impl
  )
}
