package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricStreamState,
  MetricStreamName,
  Timestamp,
  AmazonResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricStreamEntry(
    arn: Option[AmazonResourceName] = None,
    creationDate: Option[Timestamp] = None,
    lastUpdateDate: Option[Timestamp] = None,
    name: Option[MetricStreamName] = None,
    firehoseArn: Option[AmazonResourceName] = None,
    state: Option[MetricStreamState] = None,
    outputFormat: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry = {
    import MetricStreamEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationDate.map(value => value: Instant))(_.creationDate)
      .optionallyWith(lastUpdateDate.map(value => value: Instant))(
        _.lastUpdateDate
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(firehoseArn.map(value => value: java.lang.String))(
        _.firehoseArn
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry
      .wrap(buildAwsValue())
}
object MetricStreamEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry =
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry(
        arnValue.map(value => value),
        creationDateValue.map(value => value),
        lastUpdateDateValue.map(value => value),
        nameValue.map(value => value),
        firehoseArnValue.map(value => value),
        stateValue.map(value => value),
        outputFormatValue.map(value => value)
      )
    def arnValue: Option[AmazonResourceName]
    def creationDateValue: Option[Timestamp]
    def lastUpdateDateValue: Option[Timestamp]
    def nameValue: Option[MetricStreamName]
    def firehoseArnValue: Option[AmazonResourceName]
    def stateValue: Option[MetricStreamState]
    def outputFormatValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ]
    def arn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arnValue)
    def creationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDateValue)
    def lastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDateValue)
    def name: ZIO[Any, AwsError, MetricStreamName] =
      AwsError.unwrapOptionField("name", nameValue)
    def firehoseArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("firehoseArn", firehoseArnValue)
    def state: ZIO[Any, AwsError, MetricStreamState] =
      AwsError.unwrapOptionField("state", stateValue)
    def outputFormat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = AwsError.unwrapOptionField("outputFormat", outputFormatValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly {
    override def arnValue: Option[AmazonResourceName] =
      scala.Option(impl.arn()).map(value => value: AmazonResourceName)
    override def creationDateValue: Option[Timestamp] =
      scala.Option(impl.creationDate()).map(value => value: Timestamp)
    override def lastUpdateDateValue: Option[Timestamp] =
      scala.Option(impl.lastUpdateDate()).map(value => value: Timestamp)
    override def nameValue: Option[MetricStreamName] =
      scala.Option(impl.name()).map(value => value: MetricStreamName)
    override def firehoseArnValue: Option[AmazonResourceName] =
      scala.Option(impl.firehoseArn()).map(value => value: AmazonResourceName)
    override def stateValue: Option[MetricStreamState] =
      scala.Option(impl.state()).map(value => value: MetricStreamState)
    override def outputFormatValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = scala
      .Option(impl.outputFormat())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly =
    new Wrapper(impl)
}
