package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.Namespace
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricStreamFilter(namespace: Option[Namespace] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter = {
    import MetricStreamFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter
      .wrap(buildAwsValue())
}
object MetricStreamFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter =
      io.github.vigoo.zioaws.cloudwatch.model
        .MetricStreamFilter(namespaceValue.map(value => value))
    def namespaceValue: Option[Namespace]
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly {
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly =
    new Wrapper(impl)
}
