package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait MetricStreamOutputFormat {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat
}
object MetricStreamOutputFormat {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat =
    value match {
      case software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.JSON =>
        val r = json
        r
      case software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.OPENTELEMETRY0_7 =>
        val r = `opentelemetry0.7`
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat =
      software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object json
      extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat =
      software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.JSON
  }
  case object `opentelemetry0.7`
      extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat =
      software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat.OPENTELEMETRY0_7
  }
}
