package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricStreamStatistic
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MetricStreamStatisticsConfiguration(
    includeMetrics: Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric
    ],
    additionalStatistics: Iterable[MetricStreamStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration = {
    import MetricStreamStatisticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
      .builder()
      .includeMetrics(includeMetrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .additionalStatistics(additionalStatistics.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
      .wrap(buildAwsValue())
}
object MetricStreamStatisticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration =
      io.github.vigoo.zioaws.cloudwatch.model
        .MetricStreamStatisticsConfiguration(
          includeMetricsValue.map { item =>
            item.editable
          },
          additionalStatisticsValue
        )
    def includeMetricsValue: List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly
    ]
    def additionalStatisticsValue: List[MetricStreamStatistic]
    def includeMetrics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly
    ]] = ZIO.succeed(includeMetricsValue)
    def additionalStatistics: ZIO[Any, Nothing, List[MetricStreamStatistic]] =
      ZIO.succeed(additionalStatisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly {
    override def includeMetricsValue: List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly
    ] = impl
      .includeMetrics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric
          .wrap(item)
      }
      .toList
    override def additionalStatisticsValue: List[MetricStreamStatistic] = impl
      .additionalStatistics()
      .asScala
      .map { item =>
        item: MetricStreamStatistic
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly =
    new Wrapper(impl)
}
