package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  Namespace
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MetricStreamStatisticsMetric(
    namespace: Namespace,
    metricName: MetricName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric = {
    import MetricStreamStatisticsMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
      .builder()
      .namespace(namespace: java.lang.String)
      .metricName(metricName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric
      .wrap(buildAwsValue())
}
object MetricStreamStatisticsMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric =
      io.github.vigoo.zioaws.cloudwatch.model
        .MetricStreamStatisticsMetric(namespaceValue, metricNameValue)
    def namespaceValue: Namespace
    def metricNameValue: MetricName
    def namespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespaceValue)
    def metricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ) extends io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly {
    override def namespaceValue: Namespace = impl.namespace(): Namespace
    override def metricNameValue: MetricName = impl.metricName(): MetricName
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric
  ): io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly =
    new Wrapper(impl)
}
