package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  FailureDescription,
  FailureCode,
  ExceptionType,
  FailureResource
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PartialFailure(
    failureResource: Option[FailureResource] = None,
    exceptionType: Option[ExceptionType] = None,
    failureCode: Option[FailureCode] = None,
    failureDescription: Option[FailureDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PartialFailure = {
    import PartialFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PartialFailure
      .builder()
      .optionallyWith(failureResource.map(value => value: java.lang.String))(
        _.failureResource
      )
      .optionallyWith(exceptionType.map(value => value: java.lang.String))(
        _.exceptionType
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureDescription.map(value => value: java.lang.String))(
        _.failureDescription
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.wrap(buildAwsValue())
}
object PartialFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.PartialFailure =
      io.github.vigoo.zioaws.cloudwatch.model.PartialFailure(
        failureResourceValue.map(value => value),
        exceptionTypeValue.map(value => value),
        failureCodeValue.map(value => value),
        failureDescriptionValue.map(value => value)
      )
    def failureResourceValue: Option[FailureResource]
    def exceptionTypeValue: Option[ExceptionType]
    def failureCodeValue: Option[FailureCode]
    def failureDescriptionValue: Option[FailureDescription]
    def failureResource: ZIO[Any, AwsError, FailureResource] =
      AwsError.unwrapOptionField("failureResource", failureResourceValue)
    def exceptionType: ZIO[Any, AwsError, ExceptionType] =
      AwsError.unwrapOptionField("exceptionType", exceptionTypeValue)
    def failureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCodeValue)
    def failureDescription: ZIO[Any, AwsError, FailureDescription] =
      AwsError.unwrapOptionField("failureDescription", failureDescriptionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly {
    override def failureResourceValue: Option[FailureResource] =
      scala.Option(impl.failureResource()).map(value => value: FailureResource)
    override def exceptionTypeValue: Option[ExceptionType] =
      scala.Option(impl.exceptionType()).map(value => value: ExceptionType)
    override def failureCodeValue: Option[FailureCode] =
      scala.Option(impl.failureCode()).map(value => value: FailureCode)
    override def failureDescriptionValue: Option[FailureDescription] = scala
      .Option(impl.failureDescription())
      .map(value => value: FailureDescription)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ): io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly =
    new Wrapper(impl)
}
