package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  ActionsEnabled,
  AlarmName,
  AlarmArn,
  SuppressorPeriod,
  AlarmDescription,
  AlarmRule,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutCompositeAlarmRequest(
    actionsEnabled: Option[ActionsEnabled] = None,
    alarmActions: Option[Iterable[ResourceName]] = None,
    alarmDescription: Option[AlarmDescription] = None,
    alarmName: AlarmName,
    alarmRule: AlarmRule,
    insufficientDataActions: Option[Iterable[ResourceName]] = None,
    okActions: Option[Iterable[ResourceName]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None,
    actionsSuppressor: Option[AlarmArn] = None,
    actionsSuppressorWaitPeriod: Option[SuppressorPeriod] = None,
    actionsSuppressorExtensionPeriod: Option[SuppressorPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest = {
    import PutCompositeAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
      .builder()
      .optionallyWith(actionsEnabled.map(value => value: java.lang.Boolean))(
        _.actionsEnabled
      )
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(alarmDescription.map(value => value: java.lang.String))(
        _.alarmDescription
      )
      .alarmName(alarmName: java.lang.String)
      .alarmRule(alarmRule: java.lang.String)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(actionsSuppressor.map(value => value: java.lang.String))(
        _.actionsSuppressor
      )
      .optionallyWith(actionsSuppressorWaitPeriod.map(value => value: Integer))(
        _.actionsSuppressorWaitPeriod
      )
      .optionallyWith(
        actionsSuppressorExtensionPeriod.map(value => value: Integer)
      )(_.actionsSuppressorExtensionPeriod)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest
      .wrap(buildAwsValue())
}
object PutCompositeAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest =
      io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest(
        actionsEnabledValue.map(value => value),
        alarmActionsValue.map(value => value),
        alarmDescriptionValue.map(value => value),
        alarmNameValue,
        alarmRuleValue,
        insufficientDataActionsValue.map(value => value),
        okActionsValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        actionsSuppressorValue.map(value => value),
        actionsSuppressorWaitPeriodValue.map(value => value),
        actionsSuppressorExtensionPeriodValue.map(value => value)
      )
    def actionsEnabledValue: Option[ActionsEnabled]
    def alarmActionsValue: Option[List[ResourceName]]
    def alarmDescriptionValue: Option[AlarmDescription]
    def alarmNameValue: AlarmName
    def alarmRuleValue: AlarmRule
    def insufficientDataActionsValue: Option[List[ResourceName]]
    def okActionsValue: Option[List[ResourceName]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def actionsSuppressorValue: Option[AlarmArn]
    def actionsSuppressorWaitPeriodValue: Option[SuppressorPeriod]
    def actionsSuppressorExtensionPeriodValue: Option[SuppressorPeriod]
    def actionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabledValue)
    def alarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActionsValue)
    def alarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescriptionValue)
    def alarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmNameValue)
    def alarmRule: ZIO[Any, Nothing, AlarmRule] = ZIO.succeed(alarmRuleValue)
    def insufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActionsValue
      )
    def okActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActionsValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def actionsSuppressor: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("actionsSuppressor", actionsSuppressorValue)
    def actionsSuppressorWaitPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorWaitPeriod",
        actionsSuppressorWaitPeriodValue
      )
    def actionsSuppressorExtensionPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorExtensionPeriod",
        actionsSuppressorExtensionPeriodValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly {
    override def actionsEnabledValue: Option[ActionsEnabled] =
      scala.Option(impl.actionsEnabled()).map(value => value: ActionsEnabled)
    override def alarmActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.alarmActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def alarmDescriptionValue: Option[AlarmDescription] = scala
      .Option(impl.alarmDescription())
      .map(value => value: AlarmDescription)
    override def alarmNameValue: AlarmName = impl.alarmName(): AlarmName
    override def alarmRuleValue: AlarmRule = impl.alarmRule(): AlarmRule
    override def insufficientDataActionsValue: Option[List[ResourceName]] =
      scala
        .Option(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            item: ResourceName
          }.toList
        )
    override def okActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override def actionsSuppressorValue: Option[AlarmArn] =
      scala.Option(impl.actionsSuppressor()).map(value => value: AlarmArn)
    override def actionsSuppressorWaitPeriodValue: Option[SuppressorPeriod] =
      scala
        .Option(impl.actionsSuppressorWaitPeriod())
        .map(value => value: SuppressorPeriod)
    override def actionsSuppressorExtensionPeriodValue
        : Option[SuppressorPeriod] = scala
      .Option(impl.actionsSuppressorExtensionPeriod())
      .map(value => value: SuppressorPeriod)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutCompositeAlarmRequest.ReadOnly =
    new Wrapper(impl)
}
