package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  DashboardBody,
  DashboardName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutDashboardRequest(
    dashboardName: DashboardName,
    dashboardBody: DashboardBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest = {
    import PutDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
      .builder()
      .dashboardName(dashboardName: java.lang.String)
      .dashboardBody(dashboardBody: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutDashboardRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutDashboardRequest
      .wrap(buildAwsValue())
}
object PutDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.PutDashboardRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .PutDashboardRequest(dashboardNameValue, dashboardBodyValue)
    def dashboardNameValue: DashboardName
    def dashboardBodyValue: DashboardBody
    def dashboardName: ZIO[Any, Nothing, DashboardName] =
      ZIO.succeed(dashboardNameValue)
    def dashboardBody: ZIO[Any, Nothing, DashboardBody] =
      ZIO.succeed(dashboardBodyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutDashboardRequest.ReadOnly {
    override def dashboardNameValue: DashboardName =
      impl.dashboardName(): DashboardName
    override def dashboardBodyValue: DashboardBody =
      impl.dashboardBody(): DashboardBody
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutDashboardRequest.ReadOnly =
    new Wrapper(impl)
}
