package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutDashboardResponse(
    dashboardValidationMessages: Option[Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse = {
    import PutDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
      .builder()
      .optionallyWith(
        dashboardValidationMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dashboardValidationMessages)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse
      .wrap(buildAwsValue())
}
object PutDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse =
      io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse(
        dashboardValidationMessagesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def dashboardValidationMessagesValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly
    ]]
    def dashboardValidationMessages: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dashboardValidationMessages",
      dashboardValidationMessagesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly {
    override def dashboardValidationMessagesValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly
    ]] = scala
      .Option(impl.dashboardValidationMessages())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly =
    new Wrapper(impl)
}
