package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleDefinition,
  InsightRuleState,
  InsightRuleName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutInsightRuleRequest(
    ruleName: InsightRuleName,
    ruleState: Option[InsightRuleState] = None,
    ruleDefinition: InsightRuleDefinition,
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest = {
    import PutInsightRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
      .builder()
      .ruleName(ruleName: java.lang.String)
      .optionallyWith(ruleState.map(value => value: java.lang.String))(
        _.ruleState
      )
      .ruleDefinition(ruleDefinition: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest
      .wrap(buildAwsValue())
}
object PutInsightRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest =
      io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest(
        ruleNameValue,
        ruleStateValue.map(value => value),
        ruleDefinitionValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def ruleNameValue: InsightRuleName
    def ruleStateValue: Option[InsightRuleState]
    def ruleDefinitionValue: InsightRuleDefinition
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def ruleName: ZIO[Any, Nothing, InsightRuleName] =
      ZIO.succeed(ruleNameValue)
    def ruleState: ZIO[Any, AwsError, InsightRuleState] =
      AwsError.unwrapOptionField("ruleState", ruleStateValue)
    def ruleDefinition: ZIO[Any, Nothing, InsightRuleDefinition] =
      ZIO.succeed(ruleDefinitionValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest.ReadOnly {
    override def ruleNameValue: InsightRuleName =
      impl.ruleName(): InsightRuleName
    override def ruleStateValue: Option[InsightRuleState] =
      scala.Option(impl.ruleState()).map(value => value: InsightRuleState)
    override def ruleDefinitionValue: InsightRuleDefinition =
      impl.ruleDefinition(): InsightRuleDefinition
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleRequest.ReadOnly =
    new Wrapper(impl)
}
