package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutManagedInsightRulesRequest(
    managedRules: Iterable[io.github.vigoo.zioaws.cloudwatch.model.ManagedRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest = {
    import PutManagedInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
      .builder()
      .managedRules(managedRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesRequest
      .wrap(buildAwsValue())
}
object PutManagedInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .PutManagedInsightRulesRequest(managedRulesValue.map { item =>
          item.editable
        })
    def managedRulesValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly]
    def managedRules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly
    ]] = ZIO.succeed(managedRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly {
    override def managedRulesValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.ReadOnly] =
      impl
        .managedRules()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.ManagedRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
