package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutManagedInsightRulesResponse(
    failures: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse = {
    import PutManagedInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse
      .wrap(buildAwsValue())
}
object PutManagedInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse =
      io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse(
        failuresValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ]
    def failures: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failuresValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly {
    override def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
