package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  ExtendedStatistic,
  DatapointsToAlarm,
  ActionsEnabled,
  Namespace,
  AlarmName,
  EvaluateLowSampleCountPercentile,
  Period,
  MetricId,
  EvaluationPeriods,
  AlarmDescription,
  TreatMissingData,
  ResourceName,
  Threshold
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutMetricAlarmRequest(
    alarmName: AlarmName,
    alarmDescription: Option[AlarmDescription] = None,
    actionsEnabled: Option[ActionsEnabled] = None,
    okActions: Option[Iterable[ResourceName]] = None,
    alarmActions: Option[Iterable[ResourceName]] = None,
    insufficientDataActions: Option[Iterable[ResourceName]] = None,
    metricName: Option[MetricName] = None,
    namespace: Option[Namespace] = None,
    statistic: Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = None,
    extendedStatistic: Option[ExtendedStatistic] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    period: Option[Period] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None,
    evaluationPeriods: EvaluationPeriods,
    datapointsToAlarm: Option[DatapointsToAlarm] = None,
    threshold: Option[Threshold] = None,
    comparisonOperator: io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator,
    treatMissingData: Option[TreatMissingData] = None,
    evaluateLowSampleCountPercentile: Option[EvaluateLowSampleCountPercentile] =
      None,
    metrics: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery]
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None,
    thresholdMetricId: Option[MetricId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest = {
    import PutMetricAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
      .builder()
      .alarmName(alarmName: java.lang.String)
      .optionallyWith(alarmDescription.map(value => value: java.lang.String))(
        _.alarmDescription
      )
      .optionallyWith(actionsEnabled.map(value => value: java.lang.Boolean))(
        _.actionsEnabled
      )
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(extendedStatistic.map(value => value: java.lang.String))(
        _.extendedStatistic
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .evaluationPeriods(evaluationPeriods: Integer)
      .optionallyWith(datapointsToAlarm.map(value => value: Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .comparisonOperator(comparisonOperator.unwrap)
      .optionallyWith(treatMissingData.map(value => value: java.lang.String))(
        _.treatMissingData
      )
      .optionallyWith(
        evaluateLowSampleCountPercentile.map(value => value: java.lang.String)
      )(_.evaluateLowSampleCountPercentile)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(thresholdMetricId.map(value => value: java.lang.String))(
        _.thresholdMetricId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest
      .wrap(buildAwsValue())
}
object PutMetricAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest =
      io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest(
        alarmNameValue,
        alarmDescriptionValue.map(value => value),
        actionsEnabledValue.map(value => value),
        okActionsValue.map(value => value),
        alarmActionsValue.map(value => value),
        insufficientDataActionsValue.map(value => value),
        metricNameValue.map(value => value),
        namespaceValue.map(value => value),
        statisticValue.map(value => value),
        extendedStatisticValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        periodValue.map(value => value),
        unitValue.map(value => value),
        evaluationPeriodsValue,
        datapointsToAlarmValue.map(value => value),
        thresholdValue.map(value => value),
        comparisonOperatorValue,
        treatMissingDataValue.map(value => value),
        evaluateLowSampleCountPercentileValue.map(value => value),
        metricsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        thresholdMetricIdValue.map(value => value)
      )
    def alarmNameValue: AlarmName
    def alarmDescriptionValue: Option[AlarmDescription]
    def actionsEnabledValue: Option[ActionsEnabled]
    def okActionsValue: Option[List[ResourceName]]
    def alarmActionsValue: Option[List[ResourceName]]
    def insufficientDataActionsValue: Option[List[ResourceName]]
    def metricNameValue: Option[MetricName]
    def namespaceValue: Option[Namespace]
    def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic]
    def extendedStatisticValue: Option[ExtendedStatistic]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def periodValue: Option[Period]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def evaluationPeriodsValue: EvaluationPeriods
    def datapointsToAlarmValue: Option[DatapointsToAlarm]
    def thresholdValue: Option[Threshold]
    def comparisonOperatorValue
        : io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator
    def treatMissingDataValue: Option[TreatMissingData]
    def evaluateLowSampleCountPercentileValue
        : Option[EvaluateLowSampleCountPercentile]
    def metricsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def thresholdMetricIdValue: Option[MetricId]
    def alarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmNameValue)
    def alarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescriptionValue)
    def actionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabledValue)
    def okActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActionsValue)
    def alarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActionsValue)
    def insufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActionsValue
      )
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def statistic: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.Statistic
    ] = AwsError.unwrapOptionField("statistic", statisticValue)
    def extendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatisticValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def period: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", periodValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def evaluationPeriods: ZIO[Any, Nothing, EvaluationPeriods] =
      ZIO.succeed(evaluationPeriodsValue)
    def datapointsToAlarm: ZIO[Any, AwsError, DatapointsToAlarm] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def threshold: ZIO[Any, AwsError, Threshold] =
      AwsError.unwrapOptionField("threshold", thresholdValue)
    def comparisonOperator: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator
    ] = ZIO.succeed(comparisonOperatorValue)
    def treatMissingData: ZIO[Any, AwsError, TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def evaluateLowSampleCountPercentile
        : ZIO[Any, AwsError, EvaluateLowSampleCountPercentile] =
      AwsError.unwrapOptionField(
        "evaluateLowSampleCountPercentile",
        evaluateLowSampleCountPercentileValue
      )
    def metrics: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metricsValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def thresholdMetricId: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("thresholdMetricId", thresholdMetricIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly {
    override def alarmNameValue: AlarmName = impl.alarmName(): AlarmName
    override def alarmDescriptionValue: Option[AlarmDescription] = scala
      .Option(impl.alarmDescription())
      .map(value => value: AlarmDescription)
    override def actionsEnabledValue: Option[ActionsEnabled] =
      scala.Option(impl.actionsEnabled()).map(value => value: ActionsEnabled)
    override def okActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def alarmActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.alarmActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def insufficientDataActionsValue: Option[List[ResourceName]] =
      scala
        .Option(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            item: ResourceName
          }.toList
        )
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = scala
      .Option(impl.statistic())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.Statistic.wrap(value)
      )
    override def extendedStatisticValue: Option[ExtendedStatistic] = scala
      .Option(impl.extendedStatistic())
      .map(value => value: ExtendedStatistic)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def periodValue: Option[Period] =
      scala.Option(impl.period()).map(value => value: Period)
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
    override def evaluationPeriodsValue: EvaluationPeriods =
      impl.evaluationPeriods(): EvaluationPeriods
    override def datapointsToAlarmValue: Option[DatapointsToAlarm] = scala
      .Option(impl.datapointsToAlarm())
      .map(value => value: DatapointsToAlarm)
    override def thresholdValue: Option[Threshold] =
      scala.Option(impl.threshold()).map(value => value: Threshold)
    override def comparisonOperatorValue
        : io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator =
      io.github.vigoo.zioaws.cloudwatch.model.ComparisonOperator
        .wrap(impl.comparisonOperator())
    override def treatMissingDataValue: Option[TreatMissingData] = scala
      .Option(impl.treatMissingData())
      .map(value => value: TreatMissingData)
    override def evaluateLowSampleCountPercentileValue
        : Option[EvaluateLowSampleCountPercentile] = scala
      .Option(impl.evaluateLowSampleCountPercentile())
      .map(value => value: EvaluateLowSampleCountPercentile)
    override def metricsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    ] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.wrap(item)
        }.toList
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override def thresholdMetricIdValue: Option[MetricId] =
      scala.Option(impl.thresholdMetricId()).map(value => value: MetricId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly =
    new Wrapper(impl)
}
