package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.Namespace
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutMetricDataRequest(
    namespace: Namespace,
    metricData: Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricDatum]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest = {
    import PutMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
      .builder()
      .namespace(namespace: java.lang.String)
      .metricData(metricData.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest
      .wrap(buildAwsValue())
}
object PutMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest =
      io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest(
        namespaceValue,
        metricDataValue.map { item =>
          item.editable
        }
      )
    def namespaceValue: Namespace
    def metricDataValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly]
    def namespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespaceValue)
    def metricData: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly
    ]] = ZIO.succeed(metricDataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest.ReadOnly {
    override def namespaceValue: Namespace = impl.namespace(): Namespace
    override def metricDataValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.ReadOnly] =
      impl
        .metricData()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricDatum.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
