package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  AmazonResourceName,
  MetricStreamName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutMetricStreamRequest(
    name: MetricStreamName,
    includeFilters: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter]
    ] = None,
    excludeFilters: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter]
    ] = None,
    firehoseArn: AmazonResourceName,
    roleArn: AmazonResourceName,
    outputFormat: io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat,
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None,
    statisticsConfigurations: Option[Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest = {
    import PutMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        includeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includeFilters)
      .optionallyWith(
        excludeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeFilters)
      .firehoseArn(firehoseArn: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .outputFormat(outputFormat.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statisticsConfigurations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest
      .wrap(buildAwsValue())
}
object PutMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest =
      io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest(
        nameValue,
        includeFiltersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        excludeFiltersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        firehoseArnValue,
        roleArnValue,
        outputFormatValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        statisticsConfigurationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nameValue: MetricStreamName
    def includeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ]
    def excludeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ]
    def firehoseArnValue: AmazonResourceName
    def roleArnValue: AmazonResourceName
    def outputFormatValue
        : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def statisticsConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]]
    def name: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(nameValue)
    def includeFilters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("includeFilters", includeFiltersValue)
    def excludeFilters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("excludeFilters", excludeFiltersValue)
    def firehoseArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(firehoseArnValue)
    def roleArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(roleArnValue)
    def outputFormat: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = ZIO.succeed(outputFormatValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def statisticsConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statisticsConfigurations",
      statisticsConfigurationsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest.ReadOnly {
    override def nameValue: MetricStreamName = impl.name(): MetricStreamName
    override def includeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ] = scala
      .Option(impl.includeFilters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.wrap(item)
        }.toList
      )
    override def excludeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ] = scala
      .Option(impl.excludeFilters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.wrap(item)
        }.toList
      )
    override def firehoseArnValue: AmazonResourceName =
      impl.firehoseArn(): AmazonResourceName
    override def roleArnValue: AmazonResourceName =
      impl.roleArn(): AmazonResourceName
    override def outputFormatValue
        : io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat =
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
        .wrap(impl.outputFormat())
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override def statisticsConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = scala
      .Option(impl.statisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamRequest.ReadOnly =
    new Wrapper(impl)
}
