package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.AmazonResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutMetricStreamResponse(
    arn: Option[AmazonResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse = {
    import PutMetricStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse
      .wrap(buildAwsValue())
}
object PutMetricStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse =
      io.github.vigoo.zioaws.cloudwatch.model
        .PutMetricStreamResponse(arnValue.map(value => value))
    def arnValue: Option[AmazonResourceName]
    def arn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly {
    override def arnValue: Option[AmazonResourceName] =
      scala.Option(impl.arn()).map(value => value: AmazonResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly =
    new Wrapper(impl)
}
