package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.Timestamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Range(startTime: Timestamp, endTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Range
      .builder()
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudwatch.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.Range =
      io.github.vigoo.zioaws.cloudwatch.model
        .Range(startTimeValue, endTimeValue)
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Range
  ) extends io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly {
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Range
  ): io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly = new Wrapper(impl)
}
