package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait RecentlyActive {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.RecentlyActive
}
object RecentlyActive {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.RecentlyActive
  ): io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive = value match {
    case software.amazon.awssdk.services.cloudwatch.model.RecentlyActive.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.RecentlyActive.PT3_H =>
      val r = PT3H
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.RecentlyActive =
      software.amazon.awssdk.services.cloudwatch.model.RecentlyActive.UNKNOWN_TO_SDK_VERSION
  }
  case object PT3H
      extends io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.RecentlyActive =
      software.amazon.awssdk.services.cloudwatch.model.RecentlyActive.PT3_H
  }
}
