package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait ScanBy {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.ScanBy
}
object ScanBy {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.ScanBy
  ): io.github.vigoo.zioaws.cloudwatch.model.ScanBy = value match {
    case software.amazon.awssdk.services.cloudwatch.model.ScanBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.ScanBy.TIMESTAMP_DESCENDING =>
      val r = TimestampDescending
      r
    case software.amazon.awssdk.services.cloudwatch.model.ScanBy.TIMESTAMP_ASCENDING =>
      val r = TimestampAscending
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.ScanBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ScanBy =
      software.amazon.awssdk.services.cloudwatch.model.ScanBy.UNKNOWN_TO_SDK_VERSION
  }
  case object TimestampDescending
      extends io.github.vigoo.zioaws.cloudwatch.model.ScanBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ScanBy =
      software.amazon.awssdk.services.cloudwatch.model.ScanBy.TIMESTAMP_DESCENDING
  }
  case object TimestampAscending
      extends io.github.vigoo.zioaws.cloudwatch.model.ScanBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ScanBy =
      software.amazon.awssdk.services.cloudwatch.model.ScanBy.TIMESTAMP_ASCENDING
  }
}
