package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  StateReasonData,
  StateReason,
  AlarmName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetAlarmStateRequest(
    alarmName: AlarmName,
    stateValue: io.github.vigoo.zioaws.cloudwatch.model.StateValue,
    stateReason: StateReason,
    stateReasonData: Option[StateReasonData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest = {
    import SetAlarmStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
      .builder()
      .alarmName(alarmName: java.lang.String)
      .stateValue(stateValue.unwrap)
      .stateReason(stateReason: java.lang.String)
      .optionallyWith(stateReasonData.map(value => value: java.lang.String))(
        _.stateReasonData
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest
      .wrap(buildAwsValue())
}
object SetAlarmStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest =
      io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest(
        alarmNameValue,
        stateValueValue,
        stateReasonValue,
        stateReasonDataValue.map(value => value)
      )
    def alarmNameValue: AlarmName
    def stateValueValue: io.github.vigoo.zioaws.cloudwatch.model.StateValue
    def stateReasonValue: StateReason
    def stateReasonDataValue: Option[StateReasonData]
    def alarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmNameValue)
    def stateValue: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.cloudwatch.model.StateValue
    ] = ZIO.succeed(stateValueValue)
    def stateReason: ZIO[Any, Nothing, StateReason] =
      ZIO.succeed(stateReasonValue)
    def stateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonDataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest.ReadOnly {
    override def alarmNameValue: AlarmName = impl.alarmName(): AlarmName
    override def stateValueValue
        : io.github.vigoo.zioaws.cloudwatch.model.StateValue =
      io.github.vigoo.zioaws.cloudwatch.model.StateValue.wrap(impl.stateValue())
    override def stateReasonValue: StateReason = impl.stateReason(): StateReason
    override def stateReasonDataValue: Option[StateReasonData] =
      scala.Option(impl.stateReasonData()).map(value => value: StateReasonData)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.SetAlarmStateRequest.ReadOnly =
    new Wrapper(impl)
}
