package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  AnomalyDetectorMetricStat,
  MetricName,
  Namespace
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SingleMetricAnomalyDetector(
    namespace: Option[Namespace] = None,
    metricName: Option[MetricName] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    stat: Option[AnomalyDetectorMetricStat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector = {
    import SingleMetricAnomalyDetector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(stat.map(value => value: java.lang.String))(_.stat)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector
      .wrap(buildAwsValue())
}
object SingleMetricAnomalyDetector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector =
      io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector(
        namespaceValue.map(value => value),
        metricNameValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        statValue.map(value => value)
      )
    def namespaceValue: Option[Namespace]
    def metricNameValue: Option[MetricName]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def statValue: Option[AnomalyDetectorMetricStat]
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def stat: ZIO[Any, AwsError, AnomalyDetectorMetricStat] =
      AwsError.unwrapOptionField("stat", statValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector
  ) extends io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly {
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def statValue: Option[AnomalyDetectorMetricStat] =
      scala.Option(impl.stat()).map(value => value: AnomalyDetectorMetricStat)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector
  ): io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly =
    new Wrapper(impl)
}
