package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait StandardUnit {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.StandardUnit
}
object StandardUnit {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.StandardUnit
  ): io.github.vigoo.zioaws.cloudwatch.model.StandardUnit = value match {
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MICROSECONDS =>
      val r = Microseconds
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MILLISECONDS =>
      val r = Milliseconds
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BYTES =>
      val r = Bytes
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBYTES =>
      val r = Kilobytes
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABYTES =>
      val r = Megabytes
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABYTES =>
      val r = Gigabytes
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABYTES =>
      val r = Terabytes
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BITS =>
      val r = Bits
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBITS =>
      val r = Kilobits
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABITS =>
      val r = Megabits
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABITS =>
      val r = Gigabits
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABITS =>
      val r = Terabits
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.PERCENT =>
      val r = Percent
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.COUNT =>
      val r = Count
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BYTES_SECOND =>
      val r = `Bytes/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBYTES_SECOND =>
      val r = `Kilobytes/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABYTES_SECOND =>
      val r = `Megabytes/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABYTES_SECOND =>
      val r = `Gigabytes/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABYTES_SECOND =>
      val r = `Terabytes/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BITS_SECOND =>
      val r = `Bits/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBITS_SECOND =>
      val r = `Kilobits/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABITS_SECOND =>
      val r = `Megabits/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABITS_SECOND =>
      val r = `Gigabits/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABITS_SECOND =>
      val r = `Terabits/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.COUNT_SECOND =>
      val r = `Count/Second`
      r
    case software.amazon.awssdk.services.cloudwatch.model.StandardUnit.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Seconds
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.SECONDS
  }
  case object Microseconds
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MICROSECONDS
  }
  case object Milliseconds
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MILLISECONDS
  }
  case object Bytes
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BYTES
  }
  case object Kilobytes
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBYTES
  }
  case object Megabytes
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABYTES
  }
  case object Gigabytes
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABYTES
  }
  case object Terabytes
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABYTES
  }
  case object Bits
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BITS
  }
  case object Kilobits
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBITS
  }
  case object Megabits
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABITS
  }
  case object Gigabits
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABITS
  }
  case object Terabits
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABITS
  }
  case object Percent
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.PERCENT
  }
  case object Count
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.COUNT
  }
  case object `Bytes/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BYTES_SECOND
  }
  case object `Kilobytes/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBYTES_SECOND
  }
  case object `Megabytes/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABYTES_SECOND
  }
  case object `Gigabytes/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABYTES_SECOND
  }
  case object `Terabytes/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABYTES_SECOND
  }
  case object `Bits/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.BITS_SECOND
  }
  case object `Kilobits/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.KILOBITS_SECOND
  }
  case object `Megabits/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.MEGABITS_SECOND
  }
  case object `Gigabits/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.GIGABITS_SECOND
  }
  case object `Terabits/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.TERABITS_SECOND
  }
  case object `Count/Second`
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.COUNT_SECOND
  }
  case object None
      extends io.github.vigoo.zioaws.cloudwatch.model.StandardUnit {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StandardUnit =
      software.amazon.awssdk.services.cloudwatch.model.StandardUnit.NONE
  }
}
