package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMetricStreamsRequest(names: Iterable[MetricStreamName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest = {
    import StartMetricStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
      .builder()
      .names(names.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsRequest
      .wrap(buildAwsValue())
}
object StartMetricStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .StartMetricStreamsRequest(namesValue)
    def namesValue: List[MetricStreamName]
    def names: ZIO[Any, Nothing, List[MetricStreamName]] =
      ZIO.succeed(namesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly {
    override def namesValue: List[MetricStreamName] = impl
      .names()
      .asScala
      .map { item =>
        item: MetricStreamName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
