package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait StateValue {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.StateValue
}
object StateValue {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.StateValue
  ): io.github.vigoo.zioaws.cloudwatch.model.StateValue = value match {
    case software.amazon.awssdk.services.cloudwatch.model.StateValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.StateValue.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.cloudwatch.model.StateValue.ALARM =>
      val r = ALARM
      r
    case software.amazon.awssdk.services.cloudwatch.model.StateValue.INSUFFICIENT_DATA =>
      val r = INSUFFICIENT_DATA
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.StateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StateValue =
      software.amazon.awssdk.services.cloudwatch.model.StateValue.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends io.github.vigoo.zioaws.cloudwatch.model.StateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StateValue =
      software.amazon.awssdk.services.cloudwatch.model.StateValue.OK
  }
  case object ALARM extends io.github.vigoo.zioaws.cloudwatch.model.StateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StateValue =
      software.amazon.awssdk.services.cloudwatch.model.StateValue.ALARM
  }
  case object INSUFFICIENT_DATA
      extends io.github.vigoo.zioaws.cloudwatch.model.StateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.StateValue =
      software.amazon.awssdk.services.cloudwatch.model.StateValue.INSUFFICIENT_DATA
  }
}
