package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.DatapointValue
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StatisticSet(
    sampleCount: DatapointValue,
    sum: DatapointValue,
    minimum: DatapointValue,
    maximum: DatapointValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StatisticSet = {
    import StatisticSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StatisticSet
      .builder()
      .sampleCount(sampleCount: java.lang.Double)
      .sum(sum: java.lang.Double)
      .minimum(minimum: java.lang.Double)
      .maximum(maximum: java.lang.Double)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.wrap(buildAwsValue())
}
object StatisticSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.StatisticSet =
      io.github.vigoo.zioaws.cloudwatch.model
        .StatisticSet(sampleCountValue, sumValue, minimumValue, maximumValue)
    def sampleCountValue: DatapointValue
    def sumValue: DatapointValue
    def minimumValue: DatapointValue
    def maximumValue: DatapointValue
    def sampleCount: ZIO[Any, Nothing, DatapointValue] =
      ZIO.succeed(sampleCountValue)
    def sum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(sumValue)
    def minimum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(minimumValue)
    def maximum: ZIO[Any, Nothing, DatapointValue] = ZIO.succeed(maximumValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ) extends io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly {
    override def sampleCountValue: DatapointValue =
      impl.sampleCount(): DatapointValue
    override def sumValue: DatapointValue = impl.sum(): DatapointValue
    override def minimumValue: DatapointValue = impl.minimum(): DatapointValue
    override def maximumValue: DatapointValue = impl.maximum(): DatapointValue
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StatisticSet
  ): io.github.vigoo.zioaws.cloudwatch.model.StatisticSet.ReadOnly =
    new Wrapper(impl)
}
