package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopMetricStreamsRequest(names: Iterable[MetricStreamName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest = {
    import StopMetricStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
      .builder()
      .names(names.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsRequest
      .wrap(buildAwsValue())
}
object StopMetricStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .StopMetricStreamsRequest(namesValue)
    def namesValue: List[MetricStreamName]
    def names: ZIO[Any, Nothing, List[MetricStreamName]] =
      ZIO.succeed(namesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly {
    override def namesValue: List[MetricStreamName] = impl
      .names()
      .asScala
      .map { item =>
        item: MetricStreamName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
