package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{TagValue, TagKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.cloudwatch.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Tag
      .builder()
      .key(key: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudwatch.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.Tag =
      io.github.vigoo.zioaws.cloudwatch.model.Tag(keyValue, valueValue)
    def keyValue: TagKey
    def valueValue: TagValue
    def key: ZIO[Any, Nothing, TagKey] = ZIO.succeed(keyValue)
    def value: ZIO[Any, Nothing, TagValue] = ZIO.succeed(valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Tag
  ) extends io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly {
    override def keyValue: TagKey = impl.key(): TagKey
    override def valueValue: TagValue = impl.value(): TagValue
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Tag
  ): io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly = new Wrapper(impl)
}
