package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.AmazonResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
      .builder()
      .resourceARN(resourceARN: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest =
      io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest(
        resourceARNValue,
        tagsValue.map { item =>
          item.editable
        }
      )
    def resourceARNValue: AmazonResourceName
    def tagsValue: List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]
    def resourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARNValue)
    def tags: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest.ReadOnly {
    override def resourceARNValue: AmazonResourceName =
      impl.resourceARN(): AmazonResourceName
    override def tagsValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
