package io.github.vigoo.zioaws.cloudwatch
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  ExtendedStatistic,
  InsightRuleContributorKeyLabel,
  AlarmName,
  Timestamp,
  InsightRuleContributorKey,
  InsightRuleMetricName,
  MetricStreamName,
  MetricStreamStatistic,
  DashboardName,
  InsightRuleName,
  DatapointValue,
  ResourceName,
  TagKey
}
import zio.Chunk
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    type AccountId = String
    type ActionPrefix = String
    type ActionsEnabled = Boolean
    type ActionsSuppressedReason = String
    type AlarmArn = String
    type AlarmDescription = String
    type AlarmName = String
    type AlarmNamePrefix = String
    type AlarmRule = String
    type AmazonResourceName = String
    type AnomalyDetectorMetricStat = String
    type AnomalyDetectorMetricTimezone = String
    type DashboardArn = String
    type DashboardBody = String
    type DashboardName = String
    type DashboardNamePrefix = String
    type DataPath = String
    type DatapointValue = Double
    type DatapointsToAlarm = Int
    type DimensionName = String
    type DimensionValue = String
    type EvaluateLowSampleCountPercentile = String
    type EvaluationPeriods = Int
    type ExceptionType = String
    type ExtendedStatistic = String
    type FailureCode = String
    type FailureDescription = String
    type FailureResource = String
    type GetMetricDataLabelTimezone = String
    type GetMetricDataMaxDatapoints = Int
    type HistoryData = String
    type HistorySummary = String
    type InsightRuleAggregationStatistic = String
    type InsightRuleContributorKey = String
    type InsightRuleContributorKeyLabel = String
    type InsightRuleDefinition = String
    type InsightRuleIsManaged = Boolean
    type InsightRuleMaxResults = Int
    type InsightRuleMetricName = String
    type InsightRuleName = String
    type InsightRuleOrderBy = String
    type InsightRuleSchema = String
    type InsightRuleState = String
    type InsightRuleUnboundDouble = Double
    type InsightRuleUnboundInteger = Int
    type InsightRuleUnboundLong = Long
    type LastModified = Instant
    type ListMetricStreamsMaxResults = Int
    type MaxRecords = Int
    type MaxReturnedResultsCount = Int
    type Message = String
    type MessageDataCode = String
    type MessageDataValue = String
    type MetricExpression = String
    type MetricId = String
    type MetricLabel = String
    type MetricName = String
    type MetricStreamName = String
    type MetricStreamState = String
    type MetricStreamStatistic = String
    type MetricWidget = String
    type MetricWidgetImage = Chunk[Byte]
    type Namespace = String
    type NextToken = String
    type OutputFormat = String
    type Period = Int
    type ResourceName = String
    type ReturnData = Boolean
    type Size = Long
    type Stat = String
    type StateReason = String
    type StateReasonData = String
    type StorageResolution = Int
    type SuppressorPeriod = Int
    type TagKey = String
    type TagValue = String
    type TemplateName = String
    type Threshold = Double
    type Timestamp = Instant
    type TreatMissingData = String
  }
  type AlarmHistoryItems =
    List[io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem]
  type AlarmNames = List[AlarmName]
  type AlarmTypes = List[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]
  type AnomalyDetectorExcludedTimeRanges =
    List[io.github.vigoo.zioaws.cloudwatch.model.Range]
  type AnomalyDetectorTypes =
    List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType]
  type AnomalyDetectors =
    List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector]
  type BatchFailures =
    List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure]
  type CompositeAlarms =
    List[io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm]
  type Counts = List[DatapointValue]
  type DashboardEntries =
    List[io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry]
  type DashboardNames = List[DashboardName]
  type DashboardValidationMessages =
    List[io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage]
  type DatapointValueMap = Map[ExtendedStatistic, DatapointValue]
  type DatapointValues = List[DatapointValue]
  type Datapoints = List[io.github.vigoo.zioaws.cloudwatch.model.Datapoint]
  type DimensionFilters =
    List[io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter]
  type Dimensions = List[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
  type ExtendedStatistics = List[ExtendedStatistic]
  type InsightRuleContributorDatapoints = List[
    io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint
  ]
  type InsightRuleContributorKeyLabels = List[InsightRuleContributorKeyLabel]
  type InsightRuleContributorKeys = List[InsightRuleContributorKey]
  type InsightRuleContributors =
    List[io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor]
  type InsightRuleMetricDatapoints =
    List[io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint]
  type InsightRuleMetricList = List[InsightRuleMetricName]
  type InsightRuleNames = List[InsightRuleName]
  type InsightRules = List[io.github.vigoo.zioaws.cloudwatch.model.InsightRule]
  type ManagedRuleDescriptions =
    List[io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription]
  type ManagedRules = List[io.github.vigoo.zioaws.cloudwatch.model.ManagedRule]
  type MetricAlarms = List[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm]
  type MetricData = List[io.github.vigoo.zioaws.cloudwatch.model.MetricDatum]
  type MetricDataQueries =
    List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery]
  type MetricDataResultMessages =
    List[io.github.vigoo.zioaws.cloudwatch.model.MessageData]
  type MetricDataResults =
    List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult]
  type MetricStreamEntries =
    List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry]
  type MetricStreamFilters =
    List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter]
  type MetricStreamNames = List[MetricStreamName]
  type MetricStreamStatisticsAdditionalStatistics = List[MetricStreamStatistic]
  type MetricStreamStatisticsConfigurations = List[
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
  ]
  type MetricStreamStatisticsIncludeMetrics =
    List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsMetric]
  type Metrics = List[io.github.vigoo.zioaws.cloudwatch.model.Metric]
  type ResourceList = List[ResourceName]
  type Statistics = List[io.github.vigoo.zioaws.cloudwatch.model.Statistic]
  type TagKeyList = List[TagKey]
  type TagList = List[io.github.vigoo.zioaws.cloudwatch.model.Tag]
  type Timestamps = List[Timestamp]
  type Values = List[DatapointValue]
}
