package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.cloudwatch.model.PutAnomalyDetectorResponse.ReadOnly
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.cloudwatch.paginators.{
  GetMetricDataPublisher,
  DescribeAlarmsPublisher
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.cloudwatch.CloudWatch
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import io.github.vigoo.zioaws.cloudwatch.model.{
  DescribeAlarmsForMetricRequest,
  DescribeInsightRulesRequest,
  DeleteDashboardsRequest,
  DescribeAlarmHistoryRequest,
  ListDashboardsRequest,
  DeleteAlarmsRequest,
  ListManagedInsightRulesRequest,
  StopMetricStreamsRequest,
  PutMetricStreamRequest,
  SetAlarmStateRequest,
  PutMetricDataRequest,
  DeleteAnomalyDetectorRequest,
  ListTagsForResourceRequest,
  PutInsightRuleRequest,
  PutMetricAlarmRequest,
  PutDashboardRequest,
  StartMetricStreamsRequest,
  EnableAlarmActionsRequest,
  PutCompositeAlarmRequest,
  DescribeAnomalyDetectorsRequest,
  GetDashboardRequest,
  GetMetricStreamRequest,
  ListMetricsRequest,
  GetMetricStatisticsRequest,
  ListMetricStreamsRequest,
  UntagResourceRequest,
  DisableAlarmActionsRequest,
  GetMetricDataRequest,
  EnableInsightRulesRequest,
  DeleteMetricStreamRequest,
  GetMetricWidgetImageRequest,
  GetInsightRuleReportRequest,
  PutManagedInsightRulesRequest,
  DeleteInsightRulesRequest,
  DescribeAlarmsRequest,
  TagResourceRequest,
  PutAnomalyDetectorRequest,
  DisableInsightRulesRequest
}
import software.amazon.awssdk.services.cloudwatch.{
  CloudWatchAsyncClientBuilder,
  CloudWatchAsyncClient
}
import zio.test.mock.{Proxy, Mock}
import software.amazon.awssdk.services.cloudwatch.model.{
  AlarmHistoryItem,
  PutInsightRuleResponse,
  EnableInsightRulesResponse,
  MetricAlarm,
  DeleteInsightRulesResponse,
  StartMetricStreamsResponse,
  PutCompositeAlarmResponse,
  DashboardEntry,
  MetricDataResult,
  DescribeAlarmsForMetricResponse,
  DescribeAlarmHistoryResponse,
  GetMetricWidgetImageResponse,
  ManagedRuleDescription,
  ListManagedInsightRulesResponse,
  PutAnomalyDetectorResponse,
  GetMetricStatisticsResponse,
  DeleteAlarmsResponse,
  ListDashboardsResponse,
  MetricStreamEntry,
  DescribeInsightRulesResponse,
  ListMetricsResponse,
  DeleteDashboardsResponse,
  SetAlarmStateResponse,
  PutMetricDataResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  PutManagedInsightRulesResponse,
  DeleteMetricStreamResponse,
  EnableAlarmActionsResponse,
  PutMetricAlarmResponse,
  DescribeAnomalyDetectorsResponse,
  StopMetricStreamsResponse,
  ListMetricStreamsResponse,
  AnomalyDetector,
  GetInsightRuleReportResponse,
  PutDashboardResponse,
  GetDashboardResponse,
  DeleteAnomalyDetectorResponse,
  DisableAlarmActionsResponse,
  InsightRule,
  Metric,
  GetMetricStreamResponse,
  DisableInsightRulesResponse,
  TagResourceResponse,
  PutMetricStreamResponse
}
package object cloudwatch {
  import scala.jdk.CollectionConverters._
  type CloudWatch = Has[CloudWatch.Service]
  object CloudWatch {
    trait Service extends AspectSupport[Service] {
      val api: CloudWatchAsyncClient
      def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
      ]
      def putMetricAlarm(request: PutMetricAlarmRequest): IO[AwsError, Unit]
      def listManagedInsightRules(
          request: ListManagedInsightRulesRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
      ]
      def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
      ]
      def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
      ]
      def describeAlarms(request: DescribeAlarmsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
      ]
      def putManagedInsightRules(request: PutManagedInsightRulesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
      ]
      def disableAlarmActions(
          request: DisableAlarmActionsRequest
      ): IO[AwsError, Unit]
      def deleteInsightRules(request: DeleteInsightRulesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
      ]
      def describeInsightRules(request: DescribeInsightRulesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
      ]
      def putDashboard(request: PutDashboardRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly
      ]
      def describeAlarmHistory(request: DescribeAlarmHistoryRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
      ]
      def stopMetricStreams(request: StopMetricStreamsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
      ]
      def getMetricStream(request: GetMetricStreamRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
      ]
      def getMetricWidgetImage(request: GetMetricWidgetImageRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
      ]
      def getMetricData(request: GetMetricDataRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
      ]
      def getInsightRuleReport(request: GetInsightRuleReportRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
      ]
      def getDashboard(request: GetDashboardRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly
      ]
      def enableInsightRules(request: EnableInsightRulesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
      ]
      def deleteMetricStream(request: DeleteMetricStreamRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
      ]
      def enableAlarmActions(
          request: EnableAlarmActionsRequest
      ): IO[AwsError, Unit]
      def listDashboards(request: ListDashboardsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
      ]
      def putMetricStream(request: PutMetricStreamRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
      ]
      def deleteDashboards(request: DeleteDashboardsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
      ]
      def putInsightRule(request: PutInsightRuleRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
      ]
      def untagResource(request: UntagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.ReadOnly
      ]
      def listMetrics(request: ListMetricsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
      ]
      def putCompositeAlarm(
          request: PutCompositeAlarmRequest
      ): IO[AwsError, Unit]
      def putMetricData(request: PutMetricDataRequest): IO[AwsError, Unit]
      def startMetricStreams(request: StartMetricStreamsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
      ]
      def listTagsForResource(request: ListTagsForResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
      ]
      def tagResource(request: TagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.ReadOnly
      ]
      def getMetricStatistics(request: GetMetricStatisticsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
      ]
      def putAnomalyDetector(
          request: PutAnomalyDetectorRequest
      ): IO[AwsError, ReadOnly]
      def describeAnomalyDetectors(
          request: DescribeAnomalyDetectorsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
      ]
      def deleteAlarms(request: DeleteAlarmsRequest): IO[AwsError, Unit]
      def disableInsightRules(request: DisableInsightRulesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
      ]
      def setAlarmState(request: SetAlarmStateRequest): IO[AwsError, Unit]
    }
    object CloudWatchMock extends Mock[CloudWatch] {
      object DeleteAnomalyDetector
          extends Effect[
            DeleteAnomalyDetectorRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
          ]
      object PutMetricAlarm
          extends Effect[PutMetricAlarmRequest, AwsError, Unit]
      object ListManagedInsightRules
          extends Stream[
            ListManagedInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
          ]
      object ListMetricStreams
          extends Stream[
            ListMetricStreamsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
          ]
      object DescribeAlarmsForMetric
          extends Effect[
            DescribeAlarmsForMetricRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
          ]
      object DescribeAlarms
          extends Stream[
            DescribeAlarmsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
          ]
      object PutManagedInsightRules
          extends Effect[
            PutManagedInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
          ]
      object DisableAlarmActions
          extends Effect[DisableAlarmActionsRequest, AwsError, Unit]
      object DeleteInsightRules
          extends Effect[
            DeleteInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
          ]
      object DescribeInsightRules
          extends Stream[
            DescribeInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
          ]
      object PutDashboard
          extends Effect[
            PutDashboardRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly
          ]
      object DescribeAlarmHistory
          extends Stream[
            DescribeAlarmHistoryRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
          ]
      object StopMetricStreams
          extends Effect[
            StopMetricStreamsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
          ]
      object GetMetricStream
          extends Effect[
            GetMetricStreamRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
          ]
      object GetMetricWidgetImage
          extends Effect[
            GetMetricWidgetImageRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
          ]
      object GetMetricData
          extends Stream[
            GetMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
          ]
      object GetInsightRuleReport
          extends Effect[
            GetInsightRuleReportRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
          ]
      object GetDashboard
          extends Effect[
            GetDashboardRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly
          ]
      object EnableInsightRules
          extends Effect[
            EnableInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
          ]
      object DeleteMetricStream
          extends Effect[
            DeleteMetricStreamRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
          ]
      object EnableAlarmActions
          extends Effect[EnableAlarmActionsRequest, AwsError, Unit]
      object ListDashboards
          extends Stream[
            ListDashboardsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
          ]
      object PutMetricStream
          extends Effect[
            PutMetricStreamRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
          ]
      object DeleteDashboards
          extends Effect[
            DeleteDashboardsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
          ]
      object PutInsightRule
          extends Effect[
            PutInsightRuleRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
          ]
      object UntagResource
          extends Effect[
            UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.ReadOnly
          ]
      object ListMetrics
          extends Stream[
            ListMetricsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
          ]
      object PutCompositeAlarm
          extends Effect[PutCompositeAlarmRequest, AwsError, Unit]
      object PutMetricData extends Effect[PutMetricDataRequest, AwsError, Unit]
      object StartMetricStreams
          extends Effect[
            StartMetricStreamsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
          ]
      object ListTagsForResource
          extends Effect[
            ListTagsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.ReadOnly
          ]
      object GetMetricStatistics
          extends Effect[
            GetMetricStatisticsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
          ]
      object PutAnomalyDetector
          extends Effect[PutAnomalyDetectorRequest, AwsError, ReadOnly]
      object DescribeAnomalyDetectors
          extends Stream[
            DescribeAnomalyDetectorsRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
          ]
      object DeleteAlarms extends Effect[DeleteAlarmsRequest, AwsError, Unit]
      object DisableInsightRules
          extends Effect[
            DisableInsightRulesRequest,
            AwsError,
            io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
          ]
      object SetAlarmState extends Effect[SetAlarmStateRequest, AwsError, Unit]
      val compose: URLayer[Has[Proxy], CloudWatch] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new CloudWatch.Service {
              val api: CloudWatchAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): CloudWatch.Service = this
              def deleteAnomalyDetector(
                  request: DeleteAnomalyDetectorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
              ] = proxy(DeleteAnomalyDetector, request)
              def putMetricAlarm(
                  request: PutMetricAlarmRequest
              ): IO[AwsError, Unit] = proxy(PutMetricAlarm, request)
              def listManagedInsightRules(
                  request: ListManagedInsightRulesRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
              ] = rts.unsafeRun(proxy(ListManagedInsightRules, request))
              def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
              ] = rts.unsafeRun(proxy(ListMetricStreams, request))
              def describeAlarmsForMetric(
                  request: DescribeAlarmsForMetricRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
              ] = proxy(DescribeAlarmsForMetric, request)
              def describeAlarms(request: DescribeAlarmsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeAlarms, request))
              def putManagedInsightRules(
                  request: PutManagedInsightRulesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
              ] = proxy(PutManagedInsightRules, request)
              def disableAlarmActions(
                  request: DisableAlarmActionsRequest
              ): IO[AwsError, Unit] = proxy(DisableAlarmActions, request)
              def deleteInsightRules(request: DeleteInsightRulesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
              ] = proxy(DeleteInsightRules, request)
              def describeInsightRules(
                  request: DescribeInsightRulesRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeInsightRules, request))
              def putDashboard(request: PutDashboardRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly
              ] = proxy(PutDashboard, request)
              def describeAlarmHistory(
                  request: DescribeAlarmHistoryRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeAlarmHistory, request))
              def stopMetricStreams(request: StopMetricStreamsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
              ] = proxy(StopMetricStreams, request)
              def getMetricStream(request: GetMetricStreamRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
              ] = proxy(GetMetricStream, request)
              def getMetricWidgetImage(
                  request: GetMetricWidgetImageRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
              ] = proxy(GetMetricWidgetImage, request)
              def getMetricData(request: GetMetricDataRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
              ] = rts.unsafeRun(proxy(GetMetricData, request))
              def getInsightRuleReport(
                  request: GetInsightRuleReportRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
              ] = proxy(GetInsightRuleReport, request)
              def getDashboard(request: GetDashboardRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly
              ] = proxy(GetDashboard, request)
              def enableInsightRules(request: EnableInsightRulesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
              ] = proxy(EnableInsightRules, request)
              def deleteMetricStream(request: DeleteMetricStreamRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
              ] = proxy(DeleteMetricStream, request)
              def enableAlarmActions(
                  request: EnableAlarmActionsRequest
              ): IO[AwsError, Unit] = proxy(EnableAlarmActions, request)
              def listDashboards(request: ListDashboardsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
              ] = rts.unsafeRun(proxy(ListDashboards, request))
              def putMetricStream(request: PutMetricStreamRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
              ] = proxy(PutMetricStream, request)
              def deleteDashboards(request: DeleteDashboardsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
              ] = proxy(DeleteDashboards, request)
              def putInsightRule(request: PutInsightRuleRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
              ] = proxy(PutInsightRule, request)
              def untagResource(request: UntagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def listMetrics(request: ListMetricsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
              ] = rts.unsafeRun(proxy(ListMetrics, request))
              def putCompositeAlarm(
                  request: PutCompositeAlarmRequest
              ): IO[AwsError, Unit] = proxy(PutCompositeAlarm, request)
              def putMetricData(
                  request: PutMetricDataRequest
              ): IO[AwsError, Unit] = proxy(PutMetricData, request)
              def startMetricStreams(request: StartMetricStreamsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
              ] = proxy(StartMetricStreams, request)
              def listTagsForResource(request: ListTagsForResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
              ] = proxy(ListTagsForResource, request)
              def tagResource(request: TagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
              def getMetricStatistics(request: GetMetricStatisticsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
              ] = proxy(GetMetricStatistics, request)
              def putAnomalyDetector(
                  request: PutAnomalyDetectorRequest
              ): IO[AwsError, ReadOnly] = proxy(PutAnomalyDetector, request)
              def describeAnomalyDetectors(
                  request: DescribeAnomalyDetectorsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeAnomalyDetectors, request))
              def deleteAlarms(
                  request: DeleteAlarmsRequest
              ): IO[AwsError, Unit] = proxy(DeleteAlarms, request)
              def disableInsightRules(request: DisableInsightRulesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
              ] = proxy(DisableInsightRules, request)
              def setAlarmState(
                  request: SetAlarmStateRequest
              ): IO[AwsError, Unit] = proxy(SetAlarmState, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudWatch] = customized(
    identity
  )
  def customized(
      customization: CloudWatchAsyncClientBuilder => CloudWatchAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudWatch] = managed(
    customization
  ).toLayer
  def managed(
      customization: CloudWatchAsyncClientBuilder => CloudWatchAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CloudWatch.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = CloudWatchAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudWatchAsyncClient, CloudWatchAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[CloudWatchAsyncClient, CloudWatchAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new CloudWatchImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class CloudWatchImpl[R](
      override val api: CloudWatchAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends CloudWatch.Service
      with AwsServiceBase[R, CloudWatchImpl] {
    override val serviceName: String = "CloudWatch"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): CloudWatchImpl[R1] = new CloudWatchImpl(api, newAspect, r)
    def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest,
      DeleteAnomalyDetectorResponse
    ]("deleteAnomalyDetector", api.deleteAnomalyDetector)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.wrap
    ).provide(r)
    def putMetricAlarm(request: PutMetricAlarmRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest,
        PutMetricAlarmResponse
      ]("putMetricAlarm", api.putMetricAlarm)(request.buildAwsValue()).unit
        .provide(r)
    def listManagedInsightRules(
        request: ListManagedInsightRulesRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest,
      ListManagedInsightRulesResponse,
      ManagedRuleDescription
    ](
      "listManagedInsightRules",
      api.listManagedInsightRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.managedRules().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription
          .wrap(item)
      )
      .provide(r)
    def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest,
      ListMetricStreamsResponse,
      MetricStreamEntry
    ](
      "listMetricStreams",
      api.listMetricStreams,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.wrap(item)
      )
      .provide(r)
    def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest,
      DescribeAlarmsForMetricResponse
    ]("describeAlarmsForMetric", api.describeAlarmsForMetric)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.wrap
    ).provide(r)
    def describeAlarms(request: DescribeAlarmsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest,
      MetricAlarm,
      DescribeAlarmsPublisher
    ]("describeAlarms", api.describeAlarmsPaginator, _.metricAlarms())(
      request.buildAwsValue()
    ).map(item =>
      io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.wrap(item)
    ).provide(r)
    def putManagedInsightRules(request: PutManagedInsightRulesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest,
      PutManagedInsightRulesResponse
    ]("putManagedInsightRules", api.putManagedInsightRules)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.wrap
    ).provide(r)
    def disableAlarmActions(
        request: DisableAlarmActionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest,
      DisableAlarmActionsResponse
    ]("disableAlarmActions", api.disableAlarmActions)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteInsightRules(request: DeleteInsightRulesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest,
      DeleteInsightRulesResponse
    ]("deleteInsightRules", api.deleteInsightRules)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.wrap
      )
      .provide(r)
    def describeInsightRules(request: DescribeInsightRulesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest,
      DescribeInsightRulesResponse,
      InsightRule
    ](
      "describeInsightRules",
      api.describeInsightRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.insightRules().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.InsightRule.wrap(item)
      )
      .provide(r)
    def putDashboard(request: PutDashboardRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest,
      PutDashboardResponse
    ]("putDashboard", api.putDashboard)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.wrap)
      .provide(r)
    def describeAlarmHistory(request: DescribeAlarmHistoryRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest,
      DescribeAlarmHistoryResponse,
      AlarmHistoryItem
    ](
      "describeAlarmHistory",
      api.describeAlarmHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.alarmHistoryItems().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.wrap(item)
      )
      .provide(r)
    def stopMetricStreams(request: StopMetricStreamsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest,
      StopMetricStreamsResponse
    ]("stopMetricStreams", api.stopMetricStreams)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.wrap
      )
      .provide(r)
    def getMetricStream(request: GetMetricStreamRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest,
      GetMetricStreamResponse
    ]("getMetricStream", api.getMetricStream)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.wrap)
      .provide(r)
    def getMetricWidgetImage(request: GetMetricWidgetImageRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest,
      GetMetricWidgetImageResponse
    ]("getMetricWidgetImage", api.getMetricWidgetImage)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.wrap
      )
      .provide(r)
    def getMetricData(request: GetMetricDataRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest,
      MetricDataResult,
      GetMetricDataPublisher
    ]("getMetricData", api.getMetricDataPaginator, _.metricDataResults())(
      request.buildAwsValue()
    ).map(item =>
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.wrap(item)
    ).provide(r)
    def getInsightRuleReport(request: GetInsightRuleReportRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest,
      GetInsightRuleReportResponse
    ]("getInsightRuleReport", api.getInsightRuleReport)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.wrap
      )
      .provide(r)
    def getDashboard(request: GetDashboardRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest,
      GetDashboardResponse
    ]("getDashboard", api.getDashboard)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.wrap)
      .provide(r)
    def enableInsightRules(request: EnableInsightRulesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest,
      EnableInsightRulesResponse
    ]("enableInsightRules", api.enableInsightRules)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.wrap
      )
      .provide(r)
    def deleteMetricStream(request: DeleteMetricStreamRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest,
      DeleteMetricStreamResponse
    ]("deleteMetricStream", api.deleteMetricStream)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.wrap
      )
      .provide(r)
    def enableAlarmActions(
        request: EnableAlarmActionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest,
      EnableAlarmActionsResponse
    ]("enableAlarmActions", api.enableAlarmActions)(
      request.buildAwsValue()
    ).unit.provide(r)
    def listDashboards(request: ListDashboardsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest,
      ListDashboardsResponse,
      DashboardEntry
    ](
      "listDashboards",
      api.listDashboards,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dashboardEntries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.wrap(item)
      )
      .provide(r)
    def putMetricStream(request: PutMetricStreamRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest,
      PutMetricStreamResponse
    ]("putMetricStream", api.putMetricStream)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.wrap)
      .provide(r)
    def deleteDashboards(request: DeleteDashboardsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest,
      DeleteDashboardsResponse
    ]("deleteDashboards", api.deleteDashboards)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.wrap
      )
      .provide(r)
    def putInsightRule(request: PutInsightRuleRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest,
      PutInsightRuleResponse
    ]("putInsightRule", api.putInsightRule)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.wrap)
      .provide(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.wrap)
      .provide(r)
    def listMetrics(request: ListMetricsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest,
      ListMetricsResponse,
      Metric
    ](
      "listMetrics",
      api.listMetrics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metrics().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.cloudwatch.model.Metric.wrap(item))
      .provide(r)
    def putCompositeAlarm(
        request: PutCompositeAlarmRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest,
      PutCompositeAlarmResponse
    ]("putCompositeAlarm", api.putCompositeAlarm)(request.buildAwsValue()).unit
      .provide(r)
    def putMetricData(request: PutMetricDataRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest,
        PutMetricDataResponse
      ]("putMetricData", api.putMetricData)(request.buildAwsValue()).unit
        .provide(r)
    def startMetricStreams(request: StartMetricStreamsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest,
      StartMetricStreamsResponse
    ]("startMetricStreams", api.startMetricStreams)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.wrap
      )
      .provide(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.wrap
      )
      .provide(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.wrap)
      .provide(r)
    def getMetricStatistics(request: GetMetricStatisticsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest,
      GetMetricStatisticsResponse
    ]("getMetricStatistics", api.getMetricStatistics)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.wrap
      )
      .provide(r)
    def putAnomalyDetector(
        request: PutAnomalyDetectorRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest,
      PutAnomalyDetectorResponse
    ]("putAnomalyDetector", api.putAnomalyDetector)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.PutAnomalyDetectorResponse.wrap
      )
      .provide(r)
    def describeAnomalyDetectors(
        request: DescribeAnomalyDetectorsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest,
      DescribeAnomalyDetectorsResponse,
      AnomalyDetector
    ](
      "describeAnomalyDetectors",
      api.describeAnomalyDetectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.anomalyDetectors().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.wrap(item)
      )
      .provide(r)
    def deleteAlarms(request: DeleteAlarmsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest,
        DeleteAlarmsResponse
      ]("deleteAlarms", api.deleteAlarms)(request.buildAwsValue()).unit
        .provide(r)
    def disableInsightRules(request: DisableInsightRulesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest,
      DisableInsightRulesResponse
    ]("disableInsightRules", api.disableInsightRules)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.wrap
      )
      .provide(r)
    def setAlarmState(request: SetAlarmStateRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest,
        SetAlarmStateResponse
      ]("setAlarmState", api.setAlarmState)(request.buildAwsValue()).unit
        .provide(r)
  }
  def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteAnomalyDetector(request))
  def putMetricAlarm(
      request: PutMetricAlarmRequest
  ): ZIO[CloudWatch, AwsError, Unit] =
    ZIO.accessM(_.get.putMetricAlarm(request))
  def listManagedInsightRules(request: ListManagedInsightRulesRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
  ] = ZStream.accessStream(_.get.listManagedInsightRules(request))
  def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
  ] = ZStream.accessStream(_.get.listMetricStreams(request))
  def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeAlarmsForMetric(request))
  def describeAlarms(request: DescribeAlarmsRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
  ] = ZStream.accessStream(_.get.describeAlarms(request))
  def putManagedInsightRules(request: PutManagedInsightRulesRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
  ] = ZIO.accessM(_.get.putManagedInsightRules(request))
  def disableAlarmActions(
      request: DisableAlarmActionsRequest
  ): ZIO[CloudWatch, AwsError, Unit] =
    ZIO.accessM(_.get.disableAlarmActions(request))
  def deleteInsightRules(request: DeleteInsightRulesRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteInsightRules(request))
  def describeInsightRules(request: DescribeInsightRulesRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
  ] = ZStream.accessStream(_.get.describeInsightRules(request))
  def putDashboard(request: PutDashboardRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.PutDashboardResponse.ReadOnly
  ] = ZIO.accessM(_.get.putDashboard(request))
  def describeAlarmHistory(request: DescribeAlarmHistoryRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
  ] = ZStream.accessStream(_.get.describeAlarmHistory(request))
  def stopMetricStreams(request: StopMetricStreamsRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
  ] = ZIO.accessM(_.get.stopMetricStreams(request))
  def getMetricStream(request: GetMetricStreamRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
  ] = ZIO.accessM(_.get.getMetricStream(request))
  def getMetricWidgetImage(request: GetMetricWidgetImageRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
  ] = ZIO.accessM(_.get.getMetricWidgetImage(request))
  def getMetricData(request: GetMetricDataRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
  ] = ZStream.accessStream(_.get.getMetricData(request))
  def getInsightRuleReport(request: GetInsightRuleReportRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInsightRuleReport(request))
  def getDashboard(request: GetDashboardRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDashboard(request))
  def enableInsightRules(request: EnableInsightRulesRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
  ] = ZIO.accessM(_.get.enableInsightRules(request))
  def deleteMetricStream(request: DeleteMetricStreamRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteMetricStream(request))
  def enableAlarmActions(
      request: EnableAlarmActionsRequest
  ): ZIO[CloudWatch, AwsError, Unit] =
    ZIO.accessM(_.get.enableAlarmActions(request))
  def listDashboards(request: ListDashboardsRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
  ] = ZStream.accessStream(_.get.listDashboards(request))
  def putMetricStream(request: PutMetricStreamRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
  ] = ZIO.accessM(_.get.putMetricStream(request))
  def deleteDashboards(request: DeleteDashboardsRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDashboards(request))
  def putInsightRule(request: PutInsightRuleRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
  ] = ZIO.accessM(_.get.putInsightRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def listMetrics(request: ListMetricsRequest): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
  ] = ZStream.accessStream(_.get.listMetrics(request))
  def putCompositeAlarm(
      request: PutCompositeAlarmRequest
  ): ZIO[CloudWatch, AwsError, Unit] =
    ZIO.accessM(_.get.putCompositeAlarm(request))
  def putMetricData(
      request: PutMetricDataRequest
  ): ZIO[CloudWatch, AwsError, Unit] = ZIO.accessM(_.get.putMetricData(request))
  def startMetricStreams(request: StartMetricStreamsRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
  ] = ZIO.accessM(_.get.startMetricStreams(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
  def getMetricStatistics(request: GetMetricStatisticsRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getMetricStatistics(request))
  def putAnomalyDetector(
      request: PutAnomalyDetectorRequest
  ): ZIO[CloudWatch, AwsError, ReadOnly] =
    ZIO.accessM(_.get.putAnomalyDetector(request))
  def describeAnomalyDetectors(
      request: DescribeAnomalyDetectorsRequest
  ): ZStream[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
  ] = ZStream.accessStream(_.get.describeAnomalyDetectors(request))
  def deleteAlarms(
      request: DeleteAlarmsRequest
  ): ZIO[CloudWatch, AwsError, Unit] = ZIO.accessM(_.get.deleteAlarms(request))
  def disableInsightRules(request: DisableInsightRulesRequest): ZIO[
    CloudWatch,
    AwsError,
    io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
  ] = ZIO.accessM(_.get.disableInsightRules(request))
  def setAlarmState(
      request: SetAlarmStateRequest
  ): ZIO[CloudWatch, AwsError, Unit] = ZIO.accessM(_.get.setAlarmState(request))
}
