package io.github.vigoo.zioaws.directconnect
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type ASN = Int
    type AmazonAddress = String
    type AssociatedGatewayId = String
    type AwsDevice = String
    type AwsDeviceV2 = String
    type BGPAuthKey = String
    type BGPPeerId = String
    type Bandwidth = String
    type BooleanFlag = Boolean
    type CIDR = String
    type ConnectionId = String
    type ConnectionName = String
    type Count = Int
    type CustomerAddress = String
    type DirectConnectGatewayAssociationId = String
    type DirectConnectGatewayAssociationProposalId = String
    type DirectConnectGatewayId = String
    type DirectConnectGatewayName = String
    type EndTime = Instant
    type FailureTestHistoryStatus = String
    type GatewayIdToAssociate = String
    type GatewayIdentifier = String
    type InterconnectId = String
    type InterconnectName = String
    type JumboFrameCapable = Boolean
    type LagId = String
    type LagName = String
    type LoaContent = Chunk[Byte]
    type LoaIssueTime = Instant
    type LocationCode = String
    type LocationName = String
    type LongAsn = Long
    type MTU = Int
    type MaxResultSetSize = Int
    type OwnerAccount = String
    type PaginationToken = String
    type PartnerName = String
    type PortSpeed = String
    type ProviderName = String
    type Region = String
    type ResourceArn = String
    type RouterConfig = String
    type StartTime = Instant
    type StateChangeError = String
    type TagKey = String
    type TagValue = String
    type TestDuration = Int
    type TestId = String
    type VLAN = Int
    type VirtualGatewayId = String
    type VirtualGatewayRegion = String
    type VirtualGatewayState = String
    type VirtualInterfaceId = String
    type VirtualInterfaceName = String
    type VirtualInterfaceRegion = String
    type VirtualInterfaceType = String
  }
  case class AcceptDirectConnectGatewayAssociationProposalRequest(directConnectGatewayId: primitives.DirectConnectGatewayId, proposalId: primitives.DirectConnectGatewayAssociationProposalId, associatedGatewayOwnerAccount: primitives.OwnerAccount, overrideAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest = {
      import AcceptDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest.builder().directConnectGatewayId(directConnectGatewayId: java.lang.String).proposalId(proposalId: java.lang.String).associatedGatewayOwnerAccount(associatedGatewayOwnerAccount: java.lang.String).optionallyWith(overrideAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.overrideAllowedPrefixesToDirectConnectGateway).build()
    }
    def asReadOnly: AcceptDirectConnectGatewayAssociationProposalRequest.ReadOnly = AcceptDirectConnectGatewayAssociationProposalRequest.wrap(buildAwsValue())
  }
  object AcceptDirectConnectGatewayAssociationProposalRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AcceptDirectConnectGatewayAssociationProposalRequest = AcceptDirectConnectGatewayAssociationProposalRequest(directConnectGatewayIdValue, proposalIdValue, associatedGatewayOwnerAccountValue, overrideAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }))
      def directConnectGatewayIdValue: primitives.DirectConnectGatewayId
      def proposalIdValue: primitives.DirectConnectGatewayAssociationProposalId
      def associatedGatewayOwnerAccountValue: primitives.OwnerAccount
      def overrideAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def directConnectGatewayId: ZIO[Any, Nothing, primitives.DirectConnectGatewayId] = ZIO.succeed(directConnectGatewayIdValue)
      def proposalId: ZIO[Any, Nothing, primitives.DirectConnectGatewayAssociationProposalId] = ZIO.succeed(proposalIdValue)
      def associatedGatewayOwnerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(associatedGatewayOwnerAccountValue)
      def overrideAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("overrideAllowedPrefixesToDirectConnectGateway", overrideAllowedPrefixesToDirectConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest) extends AcceptDirectConnectGatewayAssociationProposalRequest.ReadOnly {
      override def directConnectGatewayIdValue: primitives.DirectConnectGatewayId = impl.directConnectGatewayId(): primitives.DirectConnectGatewayId
      override def proposalIdValue: primitives.DirectConnectGatewayAssociationProposalId = impl.proposalId(): primitives.DirectConnectGatewayAssociationProposalId
      override def associatedGatewayOwnerAccountValue: primitives.OwnerAccount = impl.associatedGatewayOwnerAccount(): primitives.OwnerAccount
      override def overrideAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.overrideAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest): ReadOnly = new Wrapper(impl)
  }
  case class AcceptDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociation: scala.Option[DirectConnectGatewayAssociation] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse = {
      import AcceptDirectConnectGatewayAssociationProposalResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse.builder().optionallyWith(directConnectGatewayAssociation.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociation).build()
    }
    def asReadOnly: AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly = AcceptDirectConnectGatewayAssociationProposalResponse.wrap(buildAwsValue())
  }
  object AcceptDirectConnectGatewayAssociationProposalResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AcceptDirectConnectGatewayAssociationProposalResponse = AcceptDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociationValue.map(value => value.editable))
      def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly]
      def directConnectGatewayAssociation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociation", directConnectGatewayAssociationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse) extends AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly { override def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly] = scala.Option(impl.directConnectGatewayAssociation()).map(value => DirectConnectGatewayAssociation.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse): ReadOnly = new Wrapper(impl)
  }
  sealed trait AddressFamily { def unwrap: software.amazon.awssdk.services.directconnect.model.AddressFamily }
  object AddressFamily {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.AddressFamily): AddressFamily = value match {
      case software.amazon.awssdk.services.directconnect.model.AddressFamily.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV4 => ipv4
      case software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV6 => ipv6
    }
    final case object unknownToSdkVersion extends AddressFamily { override def unwrap: software.amazon.awssdk.services.directconnect.model.AddressFamily = software.amazon.awssdk.services.directconnect.model.AddressFamily.UNKNOWN_TO_SDK_VERSION }
    final case object ipv4 extends AddressFamily { override def unwrap: software.amazon.awssdk.services.directconnect.model.AddressFamily = software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV4 }
    final case object ipv6 extends AddressFamily { override def unwrap: software.amazon.awssdk.services.directconnect.model.AddressFamily = software.amazon.awssdk.services.directconnect.model.AddressFamily.IPV6 }
  }
  case class AllocateHostedConnectionRequest(connectionId: primitives.ConnectionId, ownerAccount: primitives.OwnerAccount, bandwidth: primitives.Bandwidth, connectionName: primitives.ConnectionName, vlan: primitives.VLAN, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest = {
      import AllocateHostedConnectionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest.builder().connectionId(connectionId: java.lang.String).ownerAccount(ownerAccount: java.lang.String).bandwidth(bandwidth: java.lang.String).connectionName(connectionName: java.lang.String).vlan(vlan: java.lang.Integer).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: AllocateHostedConnectionRequest.ReadOnly = AllocateHostedConnectionRequest.wrap(buildAwsValue())
  }
  object AllocateHostedConnectionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocateHostedConnectionRequest = AllocateHostedConnectionRequest(connectionIdValue, ownerAccountValue, bandwidthValue, connectionNameValue, vlanValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def connectionIdValue: primitives.ConnectionId
      def ownerAccountValue: primitives.OwnerAccount
      def bandwidthValue: primitives.Bandwidth
      def connectionNameValue: primitives.ConnectionName
      def vlanValue: primitives.VLAN
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def ownerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(ownerAccountValue)
      def bandwidth: ZIO[Any, Nothing, primitives.Bandwidth] = ZIO.succeed(bandwidthValue)
      def connectionName: ZIO[Any, Nothing, primitives.ConnectionName] = ZIO.succeed(connectionNameValue)
      def vlan: ZIO[Any, Nothing, primitives.VLAN] = ZIO.succeed(vlanValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest) extends AllocateHostedConnectionRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def ownerAccountValue: primitives.OwnerAccount = impl.ownerAccount(): primitives.OwnerAccount
      override def bandwidthValue: primitives.Bandwidth = impl.bandwidth(): primitives.Bandwidth
      override def connectionNameValue: primitives.ConnectionName = impl.connectionName(): primitives.ConnectionName
      override def vlanValue: primitives.VLAN = impl.vlan(): primitives.VLAN
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest): ReadOnly = new Wrapper(impl)
  }
  case class AllocateHostedConnectionResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse = {
      import AllocateHostedConnectionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: AllocateHostedConnectionResponse.ReadOnly = AllocateHostedConnectionResponse.wrap(buildAwsValue())
  }
  object AllocateHostedConnectionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocateHostedConnectionResponse = AllocateHostedConnectionResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse) extends AllocateHostedConnectionResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse): ReadOnly = new Wrapper(impl)
  }
  case class AllocatePrivateVirtualInterfaceRequest(connectionId: primitives.ConnectionId, ownerAccount: primitives.OwnerAccount, newPrivateVirtualInterfaceAllocation: NewPrivateVirtualInterfaceAllocation) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest = {
      import AllocatePrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).ownerAccount(ownerAccount: java.lang.String).newPrivateVirtualInterfaceAllocation(newPrivateVirtualInterfaceAllocation.buildAwsValue()).build()
    }
    def asReadOnly: AllocatePrivateVirtualInterfaceRequest.ReadOnly = AllocatePrivateVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object AllocatePrivateVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocatePrivateVirtualInterfaceRequest = AllocatePrivateVirtualInterfaceRequest(connectionIdValue, ownerAccountValue, newPrivateVirtualInterfaceAllocationValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def ownerAccountValue: primitives.OwnerAccount
      def newPrivateVirtualInterfaceAllocationValue: NewPrivateVirtualInterfaceAllocation.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def ownerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(ownerAccountValue)
      def newPrivateVirtualInterfaceAllocation: ZIO[Any, Nothing, NewPrivateVirtualInterfaceAllocation.ReadOnly] = ZIO.succeed(newPrivateVirtualInterfaceAllocationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest) extends AllocatePrivateVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def ownerAccountValue: primitives.OwnerAccount = impl.ownerAccount(): primitives.OwnerAccount
      override def newPrivateVirtualInterfaceAllocationValue: NewPrivateVirtualInterfaceAllocation.ReadOnly = NewPrivateVirtualInterfaceAllocation.wrap(impl.newPrivateVirtualInterfaceAllocation())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class AllocatePrivateVirtualInterfaceResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse = {
      import AllocatePrivateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: AllocatePrivateVirtualInterfaceResponse.ReadOnly = AllocatePrivateVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object AllocatePrivateVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocatePrivateVirtualInterfaceResponse = AllocatePrivateVirtualInterfaceResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse) extends AllocatePrivateVirtualInterfaceResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class AllocatePublicVirtualInterfaceRequest(connectionId: primitives.ConnectionId, ownerAccount: primitives.OwnerAccount, newPublicVirtualInterfaceAllocation: NewPublicVirtualInterfaceAllocation) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest = {
      import AllocatePublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).ownerAccount(ownerAccount: java.lang.String).newPublicVirtualInterfaceAllocation(newPublicVirtualInterfaceAllocation.buildAwsValue()).build()
    }
    def asReadOnly: AllocatePublicVirtualInterfaceRequest.ReadOnly = AllocatePublicVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object AllocatePublicVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocatePublicVirtualInterfaceRequest = AllocatePublicVirtualInterfaceRequest(connectionIdValue, ownerAccountValue, newPublicVirtualInterfaceAllocationValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def ownerAccountValue: primitives.OwnerAccount
      def newPublicVirtualInterfaceAllocationValue: NewPublicVirtualInterfaceAllocation.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def ownerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(ownerAccountValue)
      def newPublicVirtualInterfaceAllocation: ZIO[Any, Nothing, NewPublicVirtualInterfaceAllocation.ReadOnly] = ZIO.succeed(newPublicVirtualInterfaceAllocationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest) extends AllocatePublicVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def ownerAccountValue: primitives.OwnerAccount = impl.ownerAccount(): primitives.OwnerAccount
      override def newPublicVirtualInterfaceAllocationValue: NewPublicVirtualInterfaceAllocation.ReadOnly = NewPublicVirtualInterfaceAllocation.wrap(impl.newPublicVirtualInterfaceAllocation())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class AllocatePublicVirtualInterfaceResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse = {
      import AllocatePublicVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: AllocatePublicVirtualInterfaceResponse.ReadOnly = AllocatePublicVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object AllocatePublicVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocatePublicVirtualInterfaceResponse = AllocatePublicVirtualInterfaceResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse) extends AllocatePublicVirtualInterfaceResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class AllocateTransitVirtualInterfaceRequest(connectionId: primitives.ConnectionId, ownerAccount: primitives.OwnerAccount, newTransitVirtualInterfaceAllocation: NewTransitVirtualInterfaceAllocation) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest = {
      import AllocateTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).ownerAccount(ownerAccount: java.lang.String).newTransitVirtualInterfaceAllocation(newTransitVirtualInterfaceAllocation.buildAwsValue()).build()
    }
    def asReadOnly: AllocateTransitVirtualInterfaceRequest.ReadOnly = AllocateTransitVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object AllocateTransitVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocateTransitVirtualInterfaceRequest = AllocateTransitVirtualInterfaceRequest(connectionIdValue, ownerAccountValue, newTransitVirtualInterfaceAllocationValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def ownerAccountValue: primitives.OwnerAccount
      def newTransitVirtualInterfaceAllocationValue: NewTransitVirtualInterfaceAllocation.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def ownerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(ownerAccountValue)
      def newTransitVirtualInterfaceAllocation: ZIO[Any, Nothing, NewTransitVirtualInterfaceAllocation.ReadOnly] = ZIO.succeed(newTransitVirtualInterfaceAllocationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest) extends AllocateTransitVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def ownerAccountValue: primitives.OwnerAccount = impl.ownerAccount(): primitives.OwnerAccount
      override def newTransitVirtualInterfaceAllocationValue: NewTransitVirtualInterfaceAllocation.ReadOnly = NewTransitVirtualInterfaceAllocation.wrap(impl.newTransitVirtualInterfaceAllocation())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class AllocateTransitVirtualInterfaceResponse(virtualInterface: scala.Option[VirtualInterface] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse = {
      import AllocateTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse.builder().optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(_.virtualInterface).build()
    }
    def asReadOnly: AllocateTransitVirtualInterfaceResponse.ReadOnly = AllocateTransitVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object AllocateTransitVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AllocateTransitVirtualInterfaceResponse = AllocateTransitVirtualInterfaceResponse(virtualInterfaceValue.map(value => value.editable))
      def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly]
      def virtualInterface: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterface.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterface", virtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse) extends AllocateTransitVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly] = scala.Option(impl.virtualInterface()).map(value => VirtualInterface.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class AssociateConnectionWithLagRequest(connectionId: primitives.ConnectionId, lagId: primitives.LagId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest = {
      import AssociateConnectionWithLagRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest.builder().connectionId(connectionId: java.lang.String).lagId(lagId: java.lang.String).build()
    }
    def asReadOnly: AssociateConnectionWithLagRequest.ReadOnly = AssociateConnectionWithLagRequest.wrap(buildAwsValue())
  }
  object AssociateConnectionWithLagRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateConnectionWithLagRequest = AssociateConnectionWithLagRequest(connectionIdValue, lagIdValue)
      def connectionIdValue: primitives.ConnectionId
      def lagIdValue: primitives.LagId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def lagId: ZIO[Any, Nothing, primitives.LagId] = ZIO.succeed(lagIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest) extends AssociateConnectionWithLagRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def lagIdValue: primitives.LagId = impl.lagId(): primitives.LagId
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest): ReadOnly = new Wrapper(impl)
  }
  case class AssociateConnectionWithLagResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse = {
      import AssociateConnectionWithLagResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: AssociateConnectionWithLagResponse.ReadOnly = AssociateConnectionWithLagResponse.wrap(buildAwsValue())
  }
  object AssociateConnectionWithLagResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateConnectionWithLagResponse = AssociateConnectionWithLagResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse) extends AssociateConnectionWithLagResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse): ReadOnly = new Wrapper(impl)
  }
  case class AssociateHostedConnectionRequest(connectionId: primitives.ConnectionId, parentConnectionId: primitives.ConnectionId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest = {
      import AssociateHostedConnectionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest.builder().connectionId(connectionId: java.lang.String).parentConnectionId(parentConnectionId: java.lang.String).build()
    }
    def asReadOnly: AssociateHostedConnectionRequest.ReadOnly = AssociateHostedConnectionRequest.wrap(buildAwsValue())
  }
  object AssociateHostedConnectionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateHostedConnectionRequest = AssociateHostedConnectionRequest(connectionIdValue, parentConnectionIdValue)
      def connectionIdValue: primitives.ConnectionId
      def parentConnectionIdValue: primitives.ConnectionId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def parentConnectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(parentConnectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest) extends AssociateHostedConnectionRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def parentConnectionIdValue: primitives.ConnectionId = impl.parentConnectionId(): primitives.ConnectionId
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest): ReadOnly = new Wrapper(impl)
  }
  case class AssociateHostedConnectionResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse = {
      import AssociateHostedConnectionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: AssociateHostedConnectionResponse.ReadOnly = AssociateHostedConnectionResponse.wrap(buildAwsValue())
  }
  object AssociateHostedConnectionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateHostedConnectionResponse = AssociateHostedConnectionResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse) extends AssociateHostedConnectionResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse): ReadOnly = new Wrapper(impl)
  }
  case class AssociateVirtualInterfaceRequest(virtualInterfaceId: primitives.VirtualInterfaceId, connectionId: primitives.ConnectionId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest = {
      import AssociateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).connectionId(connectionId: java.lang.String).build()
    }
    def asReadOnly: AssociateVirtualInterfaceRequest.ReadOnly = AssociateVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object AssociateVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateVirtualInterfaceRequest = AssociateVirtualInterfaceRequest(virtualInterfaceIdValue, connectionIdValue)
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def connectionIdValue: primitives.ConnectionId
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest) extends AssociateVirtualInterfaceRequest.ReadOnly {
      override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class AssociateVirtualInterfaceResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse = {
      import AssociateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: AssociateVirtualInterfaceResponse.ReadOnly = AssociateVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object AssociateVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociateVirtualInterfaceResponse = AssociateVirtualInterfaceResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse) extends AssociateVirtualInterfaceResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class AssociatedGateway(id: scala.Option[primitives.GatewayIdentifier] = None, `type`: scala.Option[GatewayType] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, region: scala.Option[primitives.Region] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.AssociatedGateway = {
      import AssociatedGateway.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.AssociatedGateway.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(region.map(value => value: java.lang.String))(_.region).build()
    }
    def asReadOnly: AssociatedGateway.ReadOnly = AssociatedGateway.wrap(buildAwsValue())
  }
  object AssociatedGateway {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.AssociatedGateway] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AssociatedGateway = AssociatedGateway(idValue.map(value => value), typeValue.map(value => value), ownerAccountValue.map(value => value), regionValue.map(value => value))
      def idValue: scala.Option[primitives.GatewayIdentifier]
      def typeValue: scala.Option[GatewayType]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def regionValue: scala.Option[primitives.Region]
      def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GatewayIdentifier] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
      def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GatewayType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.AssociatedGateway) extends AssociatedGateway.ReadOnly {
      override def idValue: scala.Option[primitives.GatewayIdentifier] = scala.Option(impl.id()).map(value => value: primitives.GatewayIdentifier)
      override def typeValue: scala.Option[GatewayType] = scala.Option(impl.`type`()).map(value => GatewayType.wrap(value))
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.AssociatedGateway): ReadOnly = new Wrapper(impl)
  }
  type AvailablePortSpeeds = List[primitives.PortSpeed]
  case class BGPPeer(bgpPeerId: scala.Option[primitives.BGPPeerId] = None, asn: scala.Option[primitives.ASN] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, addressFamily: scala.Option[AddressFamily] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, bgpPeerState: scala.Option[BGPPeerState] = None, bgpStatus: scala.Option[BGPStatus] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.BGPPeer = {
      import BGPPeer.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.BGPPeer.builder().optionallyWith(bgpPeerId.map(value => value: java.lang.String))(_.bgpPeerId).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(bgpPeerState.map(value => value.unwrap))(_.bgpPeerState).optionallyWith(bgpStatus.map(value => value.unwrap))(_.bgpStatus).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).build()
    }
    def asReadOnly: BGPPeer.ReadOnly = BGPPeer.wrap(buildAwsValue())
  }
  object BGPPeer {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.BGPPeer] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: BGPPeer = BGPPeer(bgpPeerIdValue.map(value => value), asnValue.map(value => value), authKeyValue.map(value => value), addressFamilyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), bgpPeerStateValue.map(value => value), bgpStatusValue.map(value => value), awsDeviceV2Value.map(value => value))
      def bgpPeerIdValue: scala.Option[primitives.BGPPeerId]
      def asnValue: scala.Option[primitives.ASN]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def addressFamilyValue: scala.Option[AddressFamily]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def bgpPeerStateValue: scala.Option[BGPPeerState]
      def bgpStatusValue: scala.Option[BGPStatus]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def bgpPeerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPPeerId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeerId", bgpPeerIdValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def bgpPeerState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BGPPeerState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeerState", bgpPeerStateValue)
      def bgpStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BGPStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpStatus", bgpStatusValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.BGPPeer) extends BGPPeer.ReadOnly {
      override def bgpPeerIdValue: scala.Option[primitives.BGPPeerId] = scala.Option(impl.bgpPeerId()).map(value => value: primitives.BGPPeerId)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def bgpPeerStateValue: scala.Option[BGPPeerState] = scala.Option(impl.bgpPeerState()).map(value => BGPPeerState.wrap(value))
      override def bgpStatusValue: scala.Option[BGPStatus] = scala.Option(impl.bgpStatus()).map(value => BGPStatus.wrap(value))
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.BGPPeer): ReadOnly = new Wrapper(impl)
  }
  type BGPPeerIdList = List[primitives.BGPPeerId]
  type BGPPeerList = List[BGPPeer]
  sealed trait BGPPeerState { def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState }
  object BGPPeerState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.BGPPeerState): BGPPeerState = value match {
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.VERIFYING => verifying
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETED => deleted
    }
    final case object unknownToSdkVersion extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.UNKNOWN_TO_SDK_VERSION }
    final case object verifying extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.VERIFYING }
    final case object pending extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.PENDING }
    final case object available extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.AVAILABLE }
    final case object deleting extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETING }
    final case object deleted extends BGPPeerState { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPPeerState = software.amazon.awssdk.services.directconnect.model.BGPPeerState.DELETED }
  }
  sealed trait BGPStatus { def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus }
  object BGPStatus {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.BGPStatus): BGPStatus = value match {
      case software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.BGPStatus.UP => up
      case software.amazon.awssdk.services.directconnect.model.BGPStatus.DOWN => down
      case software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN => unknown
    }
    final case object unknownToSdkVersion extends BGPStatus { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus = software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN_TO_SDK_VERSION }
    final case object up extends BGPStatus { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus = software.amazon.awssdk.services.directconnect.model.BGPStatus.UP }
    final case object down extends BGPStatus { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus = software.amazon.awssdk.services.directconnect.model.BGPStatus.DOWN }
    final case object unknown extends BGPStatus { override def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus = software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN }
  }
  case class ConfirmConnectionRequest(connectionId: primitives.ConnectionId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest = {
      import ConfirmConnectionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest.builder().connectionId(connectionId: java.lang.String).build()
    }
    def asReadOnly: ConfirmConnectionRequest.ReadOnly = ConfirmConnectionRequest.wrap(buildAwsValue())
  }
  object ConfirmConnectionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmConnectionRequest = ConfirmConnectionRequest(connectionIdValue)
      def connectionIdValue: primitives.ConnectionId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest) extends ConfirmConnectionRequest.ReadOnly { override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmConnectionResponse(connectionState: scala.Option[ConnectionState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse = {
      import ConfirmConnectionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse.builder().optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).build()
    }
    def asReadOnly: ConfirmConnectionResponse.ReadOnly = ConfirmConnectionResponse.wrap(buildAwsValue())
  }
  object ConfirmConnectionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmConnectionResponse = ConfirmConnectionResponse(connectionStateValue.map(value => value))
      def connectionStateValue: scala.Option[ConnectionState]
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse) extends ConfirmConnectionResponse.ReadOnly { override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmPrivateVirtualInterfaceRequest(virtualInterfaceId: primitives.VirtualInterfaceId, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest = {
      import ConfirmPrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).build()
    }
    def asReadOnly: ConfirmPrivateVirtualInterfaceRequest.ReadOnly = ConfirmPrivateVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object ConfirmPrivateVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmPrivateVirtualInterfaceRequest = ConfirmPrivateVirtualInterfaceRequest(virtualInterfaceIdValue, virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value))
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest) extends ConfirmPrivateVirtualInterfaceRequest.ReadOnly {
      override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmPrivateVirtualInterfaceResponse(virtualInterfaceState: scala.Option[VirtualInterfaceState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse = {
      import ConfirmPrivateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.builder().optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).build()
    }
    def asReadOnly: ConfirmPrivateVirtualInterfaceResponse.ReadOnly = ConfirmPrivateVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object ConfirmPrivateVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmPrivateVirtualInterfaceResponse = ConfirmPrivateVirtualInterfaceResponse(virtualInterfaceStateValue.map(value => value))
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse) extends ConfirmPrivateVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmPublicVirtualInterfaceRequest(virtualInterfaceId: primitives.VirtualInterfaceId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest = {
      import ConfirmPublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).build()
    }
    def asReadOnly: ConfirmPublicVirtualInterfaceRequest.ReadOnly = ConfirmPublicVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object ConfirmPublicVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmPublicVirtualInterfaceRequest = ConfirmPublicVirtualInterfaceRequest(virtualInterfaceIdValue)
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest) extends ConfirmPublicVirtualInterfaceRequest.ReadOnly { override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmPublicVirtualInterfaceResponse(virtualInterfaceState: scala.Option[VirtualInterfaceState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse = {
      import ConfirmPublicVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse.builder().optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).build()
    }
    def asReadOnly: ConfirmPublicVirtualInterfaceResponse.ReadOnly = ConfirmPublicVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object ConfirmPublicVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmPublicVirtualInterfaceResponse = ConfirmPublicVirtualInterfaceResponse(virtualInterfaceStateValue.map(value => value))
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse) extends ConfirmPublicVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmTransitVirtualInterfaceRequest(virtualInterfaceId: primitives.VirtualInterfaceId, directConnectGatewayId: primitives.DirectConnectGatewayId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest = {
      import ConfirmTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).directConnectGatewayId(directConnectGatewayId: java.lang.String).build()
    }
    def asReadOnly: ConfirmTransitVirtualInterfaceRequest.ReadOnly = ConfirmTransitVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object ConfirmTransitVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmTransitVirtualInterfaceRequest = ConfirmTransitVirtualInterfaceRequest(virtualInterfaceIdValue, directConnectGatewayIdValue)
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def directConnectGatewayIdValue: primitives.DirectConnectGatewayId
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
      def directConnectGatewayId: ZIO[Any, Nothing, primitives.DirectConnectGatewayId] = ZIO.succeed(directConnectGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest) extends ConfirmTransitVirtualInterfaceRequest.ReadOnly {
      override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId
      override def directConnectGatewayIdValue: primitives.DirectConnectGatewayId = impl.directConnectGatewayId(): primitives.DirectConnectGatewayId
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class ConfirmTransitVirtualInterfaceResponse(virtualInterfaceState: scala.Option[VirtualInterfaceState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse = {
      import ConfirmTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse.builder().optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).build()
    }
    def asReadOnly: ConfirmTransitVirtualInterfaceResponse.ReadOnly = ConfirmTransitVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object ConfirmTransitVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConfirmTransitVirtualInterfaceResponse = ConfirmTransitVirtualInterfaceResponse(virtualInterfaceStateValue.map(value => value))
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse) extends ConfirmTransitVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class Connection(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.Connection = {
      import Connection.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.Connection.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: Connection.ReadOnly = Connection.wrap(buildAwsValue())
  }
  object Connection {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.Connection] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Connection = Connection(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.Connection) extends Connection.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.Connection): ReadOnly = new Wrapper(impl)
  }
  type ConnectionList = List[Connection]
  sealed trait ConnectionState { def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState }
  object ConnectionState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.ConnectionState): ConnectionState = value match {
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.ORDERING => ordering
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.REQUESTED => requested
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.DOWN => down
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETED => deleted
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.REJECTED => rejected
      case software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN => unknown
    }
    final case object unknownToSdkVersion extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN_TO_SDK_VERSION }
    final case object ordering extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.ORDERING }
    final case object requested extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.REQUESTED }
    final case object pending extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.PENDING }
    final case object available extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.AVAILABLE }
    final case object down extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.DOWN }
    final case object deleting extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETING }
    final case object deleted extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETED }
    final case object rejected extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.REJECTED }
    final case object unknown extends ConnectionState { override def unwrap: software.amazon.awssdk.services.directconnect.model.ConnectionState = software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN }
  }
  case class CreateBgpPeerRequest(virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, newBGPPeer: scala.Option[NewBGPPeer] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest = {
      import CreateBgpPeerRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest.builder().optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(newBGPPeer.map(value => value.buildAwsValue()))(_.newBGPPeer).build()
    }
    def asReadOnly: CreateBgpPeerRequest.ReadOnly = CreateBgpPeerRequest.wrap(buildAwsValue())
  }
  object CreateBgpPeerRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateBgpPeerRequest = CreateBgpPeerRequest(virtualInterfaceIdValue.map(value => value), newBGPPeerValue.map(value => value.editable))
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def newBGPPeerValue: scala.Option[NewBGPPeer.ReadOnly]
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def newBGPPeer: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NewBGPPeer.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newBGPPeer", newBGPPeerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest) extends CreateBgpPeerRequest.ReadOnly {
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def newBGPPeerValue: scala.Option[NewBGPPeer.ReadOnly] = scala.Option(impl.newBGPPeer()).map(value => NewBGPPeer.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateBgpPeerResponse(virtualInterface: scala.Option[VirtualInterface] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse = {
      import CreateBgpPeerResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse.builder().optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(_.virtualInterface).build()
    }
    def asReadOnly: CreateBgpPeerResponse.ReadOnly = CreateBgpPeerResponse.wrap(buildAwsValue())
  }
  object CreateBgpPeerResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateBgpPeerResponse = CreateBgpPeerResponse(virtualInterfaceValue.map(value => value.editable))
      def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly]
      def virtualInterface: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterface.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterface", virtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse) extends CreateBgpPeerResponse.ReadOnly { override def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly] = scala.Option(impl.virtualInterface()).map(value => VirtualInterface.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateConnectionRequest(location: primitives.LocationCode, bandwidth: primitives.Bandwidth, connectionName: primitives.ConnectionName, lagId: scala.Option[primitives.LagId] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest = {
      import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest.builder().location(location: java.lang.String).bandwidth(bandwidth: java.lang.String).connectionName(connectionName: java.lang.String).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateConnectionRequest.ReadOnly = CreateConnectionRequest.wrap(buildAwsValue())
  }
  object CreateConnectionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateConnectionRequest = CreateConnectionRequest(locationValue, bandwidthValue, connectionNameValue, lagIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def locationValue: primitives.LocationCode
      def bandwidthValue: primitives.Bandwidth
      def connectionNameValue: primitives.ConnectionName
      def lagIdValue: scala.Option[primitives.LagId]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def location: ZIO[Any, Nothing, primitives.LocationCode] = ZIO.succeed(locationValue)
      def bandwidth: ZIO[Any, Nothing, primitives.Bandwidth] = ZIO.succeed(bandwidthValue)
      def connectionName: ZIO[Any, Nothing, primitives.ConnectionName] = ZIO.succeed(connectionNameValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest) extends CreateConnectionRequest.ReadOnly {
      override def locationValue: primitives.LocationCode = impl.location(): primitives.LocationCode
      override def bandwidthValue: primitives.Bandwidth = impl.bandwidth(): primitives.Bandwidth
      override def connectionNameValue: primitives.ConnectionName = impl.connectionName(): primitives.ConnectionName
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateConnectionResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse = {
      import CreateConnectionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateConnectionResponse.ReadOnly = CreateConnectionResponse.wrap(buildAwsValue())
  }
  object CreateConnectionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateConnectionResponse = CreateConnectionResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse) extends CreateConnectionResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayAssociationProposalRequest(directConnectGatewayId: primitives.DirectConnectGatewayId, directConnectGatewayOwnerAccount: primitives.OwnerAccount, gatewayId: primitives.GatewayIdToAssociate, addAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None, removeAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest = {
      import CreateDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest.builder().directConnectGatewayId(directConnectGatewayId: java.lang.String).directConnectGatewayOwnerAccount(directConnectGatewayOwnerAccount: java.lang.String).gatewayId(gatewayId: java.lang.String).optionallyWith(addAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.addAllowedPrefixesToDirectConnectGateway).optionallyWith(removeAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.removeAllowedPrefixesToDirectConnectGateway).build()
    }
    def asReadOnly: CreateDirectConnectGatewayAssociationProposalRequest.ReadOnly = CreateDirectConnectGatewayAssociationProposalRequest.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayAssociationProposalRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayAssociationProposalRequest = CreateDirectConnectGatewayAssociationProposalRequest(directConnectGatewayIdValue, directConnectGatewayOwnerAccountValue, gatewayIdValue, addAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }), removeAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }))
      def directConnectGatewayIdValue: primitives.DirectConnectGatewayId
      def directConnectGatewayOwnerAccountValue: primitives.OwnerAccount
      def gatewayIdValue: primitives.GatewayIdToAssociate
      def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def removeAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def directConnectGatewayId: ZIO[Any, Nothing, primitives.DirectConnectGatewayId] = ZIO.succeed(directConnectGatewayIdValue)
      def directConnectGatewayOwnerAccount: ZIO[Any, Nothing, primitives.OwnerAccount] = ZIO.succeed(directConnectGatewayOwnerAccountValue)
      def gatewayId: ZIO[Any, Nothing, primitives.GatewayIdToAssociate] = ZIO.succeed(gatewayIdValue)
      def addAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addAllowedPrefixesToDirectConnectGateway", addAllowedPrefixesToDirectConnectGatewayValue)
      def removeAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("removeAllowedPrefixesToDirectConnectGateway", removeAllowedPrefixesToDirectConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest) extends CreateDirectConnectGatewayAssociationProposalRequest.ReadOnly {
      override def directConnectGatewayIdValue: primitives.DirectConnectGatewayId = impl.directConnectGatewayId(): primitives.DirectConnectGatewayId
      override def directConnectGatewayOwnerAccountValue: primitives.OwnerAccount = impl.directConnectGatewayOwnerAccount(): primitives.OwnerAccount
      override def gatewayIdValue: primitives.GatewayIdToAssociate = impl.gatewayId(): primitives.GatewayIdToAssociate
      override def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.addAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def removeAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.removeAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociationProposal: scala.Option[DirectConnectGatewayAssociationProposal] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse = {
      import CreateDirectConnectGatewayAssociationProposalResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse.builder().optionallyWith(directConnectGatewayAssociationProposal.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociationProposal).build()
    }
    def asReadOnly: CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly = CreateDirectConnectGatewayAssociationProposalResponse.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayAssociationProposalResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayAssociationProposalResponse = CreateDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociationProposalValue.map(value => value.editable))
      def directConnectGatewayAssociationProposalValue: scala.Option[DirectConnectGatewayAssociationProposal.ReadOnly]
      def directConnectGatewayAssociationProposal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociationProposal.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociationProposal", directConnectGatewayAssociationProposalValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse) extends CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly { override def directConnectGatewayAssociationProposalValue: scala.Option[DirectConnectGatewayAssociationProposal.ReadOnly] = scala.Option(impl.directConnectGatewayAssociationProposal()).map(value => DirectConnectGatewayAssociationProposal.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayAssociationRequest(directConnectGatewayId: primitives.DirectConnectGatewayId, gatewayId: scala.Option[primitives.GatewayIdToAssociate] = None, addAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest = {
      import CreateDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest.builder().directConnectGatewayId(directConnectGatewayId: java.lang.String).optionallyWith(gatewayId.map(value => value: java.lang.String))(_.gatewayId).optionallyWith(addAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.addAllowedPrefixesToDirectConnectGateway).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).build()
    }
    def asReadOnly: CreateDirectConnectGatewayAssociationRequest.ReadOnly = CreateDirectConnectGatewayAssociationRequest.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayAssociationRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayAssociationRequest = CreateDirectConnectGatewayAssociationRequest(directConnectGatewayIdValue, gatewayIdValue.map(value => value), addAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }), virtualGatewayIdValue.map(value => value))
      def directConnectGatewayIdValue: primitives.DirectConnectGatewayId
      def gatewayIdValue: scala.Option[primitives.GatewayIdToAssociate]
      def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayId: ZIO[Any, Nothing, primitives.DirectConnectGatewayId] = ZIO.succeed(directConnectGatewayIdValue)
      def gatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GatewayIdToAssociate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("gatewayId", gatewayIdValue)
      def addAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addAllowedPrefixesToDirectConnectGateway", addAllowedPrefixesToDirectConnectGatewayValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest) extends CreateDirectConnectGatewayAssociationRequest.ReadOnly {
      override def directConnectGatewayIdValue: primitives.DirectConnectGatewayId = impl.directConnectGatewayId(): primitives.DirectConnectGatewayId
      override def gatewayIdValue: scala.Option[primitives.GatewayIdToAssociate] = scala.Option(impl.gatewayId()).map(value => value: primitives.GatewayIdToAssociate)
      override def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.addAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayAssociationResponse(directConnectGatewayAssociation: scala.Option[DirectConnectGatewayAssociation] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse = {
      import CreateDirectConnectGatewayAssociationResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse.builder().optionallyWith(directConnectGatewayAssociation.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociation).build()
    }
    def asReadOnly: CreateDirectConnectGatewayAssociationResponse.ReadOnly = CreateDirectConnectGatewayAssociationResponse.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayAssociationResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayAssociationResponse = CreateDirectConnectGatewayAssociationResponse(directConnectGatewayAssociationValue.map(value => value.editable))
      def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly]
      def directConnectGatewayAssociation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociation", directConnectGatewayAssociationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse) extends CreateDirectConnectGatewayAssociationResponse.ReadOnly { override def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly] = scala.Option(impl.directConnectGatewayAssociation()).map(value => DirectConnectGatewayAssociation.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayRequest(directConnectGatewayName: primitives.DirectConnectGatewayName, amazonSideAsn: scala.Option[primitives.LongAsn] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest = {
      import CreateDirectConnectGatewayRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest.builder().directConnectGatewayName(directConnectGatewayName: java.lang.String).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).build()
    }
    def asReadOnly: CreateDirectConnectGatewayRequest.ReadOnly = CreateDirectConnectGatewayRequest.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayRequest = CreateDirectConnectGatewayRequest(directConnectGatewayNameValue, amazonSideAsnValue.map(value => value))
      def directConnectGatewayNameValue: primitives.DirectConnectGatewayName
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def directConnectGatewayName: ZIO[Any, Nothing, primitives.DirectConnectGatewayName] = ZIO.succeed(directConnectGatewayNameValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest) extends CreateDirectConnectGatewayRequest.ReadOnly {
      override def directConnectGatewayNameValue: primitives.DirectConnectGatewayName = impl.directConnectGatewayName(): primitives.DirectConnectGatewayName
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDirectConnectGatewayResponse(directConnectGateway: scala.Option[DirectConnectGateway] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse = {
      import CreateDirectConnectGatewayResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse.builder().optionallyWith(directConnectGateway.map(value => value.buildAwsValue()))(_.directConnectGateway).build()
    }
    def asReadOnly: CreateDirectConnectGatewayResponse.ReadOnly = CreateDirectConnectGatewayResponse.wrap(buildAwsValue())
  }
  object CreateDirectConnectGatewayResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDirectConnectGatewayResponse = CreateDirectConnectGatewayResponse(directConnectGatewayValue.map(value => value.editable))
      def directConnectGatewayValue: scala.Option[DirectConnectGateway.ReadOnly]
      def directConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGateway.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGateway", directConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse) extends CreateDirectConnectGatewayResponse.ReadOnly { override def directConnectGatewayValue: scala.Option[DirectConnectGateway.ReadOnly] = scala.Option(impl.directConnectGateway()).map(value => DirectConnectGateway.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateInterconnectRequest(interconnectName: primitives.InterconnectName, bandwidth: primitives.Bandwidth, location: primitives.LocationCode, lagId: scala.Option[primitives.LagId] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest = {
      import CreateInterconnectRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest.builder().interconnectName(interconnectName: java.lang.String).bandwidth(bandwidth: java.lang.String).location(location: java.lang.String).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateInterconnectRequest.ReadOnly = CreateInterconnectRequest.wrap(buildAwsValue())
  }
  object CreateInterconnectRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateInterconnectRequest = CreateInterconnectRequest(interconnectNameValue, bandwidthValue, locationValue, lagIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def interconnectNameValue: primitives.InterconnectName
      def bandwidthValue: primitives.Bandwidth
      def locationValue: primitives.LocationCode
      def lagIdValue: scala.Option[primitives.LagId]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def interconnectName: ZIO[Any, Nothing, primitives.InterconnectName] = ZIO.succeed(interconnectNameValue)
      def bandwidth: ZIO[Any, Nothing, primitives.Bandwidth] = ZIO.succeed(bandwidthValue)
      def location: ZIO[Any, Nothing, primitives.LocationCode] = ZIO.succeed(locationValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest) extends CreateInterconnectRequest.ReadOnly {
      override def interconnectNameValue: primitives.InterconnectName = impl.interconnectName(): primitives.InterconnectName
      override def bandwidthValue: primitives.Bandwidth = impl.bandwidth(): primitives.Bandwidth
      override def locationValue: primitives.LocationCode = impl.location(): primitives.LocationCode
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateInterconnectResponse(interconnectId: scala.Option[primitives.InterconnectId] = None, interconnectName: scala.Option[primitives.InterconnectName] = None, interconnectState: scala.Option[InterconnectState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse = {
      import CreateInterconnectResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse.builder().optionallyWith(interconnectId.map(value => value: java.lang.String))(_.interconnectId).optionallyWith(interconnectName.map(value => value: java.lang.String))(_.interconnectName).optionallyWith(interconnectState.map(value => value.unwrap))(_.interconnectState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateInterconnectResponse.ReadOnly = CreateInterconnectResponse.wrap(buildAwsValue())
  }
  object CreateInterconnectResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateInterconnectResponse = CreateInterconnectResponse(interconnectIdValue.map(value => value), interconnectNameValue.map(value => value), interconnectStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def interconnectIdValue: scala.Option[primitives.InterconnectId]
      def interconnectNameValue: scala.Option[primitives.InterconnectName]
      def interconnectStateValue: scala.Option[InterconnectState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def interconnectId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InterconnectId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectId", interconnectIdValue)
      def interconnectName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InterconnectName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectName", interconnectNameValue)
      def interconnectState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InterconnectState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectState", interconnectStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse) extends CreateInterconnectResponse.ReadOnly {
      override def interconnectIdValue: scala.Option[primitives.InterconnectId] = scala.Option(impl.interconnectId()).map(value => value: primitives.InterconnectId)
      override def interconnectNameValue: scala.Option[primitives.InterconnectName] = scala.Option(impl.interconnectName()).map(value => value: primitives.InterconnectName)
      override def interconnectStateValue: scala.Option[InterconnectState] = scala.Option(impl.interconnectState()).map(value => InterconnectState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateLagRequest(numberOfConnections: primitives.Count, location: primitives.LocationCode, connectionsBandwidth: primitives.Bandwidth, lagName: primitives.LagName, connectionId: scala.Option[primitives.ConnectionId] = None, tags: scala.Option[Iterable[Tag]] = None, childConnectionTags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateLagRequest = {
      import CreateLagRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateLagRequest.builder().numberOfConnections(numberOfConnections: java.lang.Integer).location(location: java.lang.String).connectionsBandwidth(connectionsBandwidth: java.lang.String).lagName(lagName: java.lang.String).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(childConnectionTags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.childConnectionTags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateLagRequest.ReadOnly = CreateLagRequest.wrap(buildAwsValue())
  }
  object CreateLagRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateLagRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateLagRequest = CreateLagRequest(numberOfConnectionsValue, locationValue, connectionsBandwidthValue, lagNameValue, connectionIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), childConnectionTagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def numberOfConnectionsValue: primitives.Count
      def locationValue: primitives.LocationCode
      def connectionsBandwidthValue: primitives.Bandwidth
      def lagNameValue: primitives.LagName
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def childConnectionTagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def numberOfConnections: ZIO[Any, Nothing, primitives.Count] = ZIO.succeed(numberOfConnectionsValue)
      def location: ZIO[Any, Nothing, primitives.LocationCode] = ZIO.succeed(locationValue)
      def connectionsBandwidth: ZIO[Any, Nothing, primitives.Bandwidth] = ZIO.succeed(connectionsBandwidthValue)
      def lagName: ZIO[Any, Nothing, primitives.LagName] = ZIO.succeed(lagNameValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def childConnectionTags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("childConnectionTags", childConnectionTagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateLagRequest) extends CreateLagRequest.ReadOnly {
      override def numberOfConnectionsValue: primitives.Count = impl.numberOfConnections(): primitives.Count
      override def locationValue: primitives.LocationCode = impl.location(): primitives.LocationCode
      override def connectionsBandwidthValue: primitives.Bandwidth = impl.connectionsBandwidth(): primitives.Bandwidth
      override def lagNameValue: primitives.LagName = impl.lagName(): primitives.LagName
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def childConnectionTagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.childConnectionTags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateLagRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateLagResponse(connectionsBandwidth: scala.Option[primitives.Bandwidth] = None, numberOfConnections: scala.Option[primitives.Count] = None, lagId: scala.Option[primitives.LagId] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, lagName: scala.Option[primitives.LagName] = None, lagState: scala.Option[LagState] = None, location: scala.Option[primitives.LocationCode] = None, region: scala.Option[primitives.Region] = None, minimumLinks: scala.Option[primitives.Count] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, connections: scala.Option[Iterable[Connection]] = None, allowsHostedConnections: scala.Option[primitives.BooleanFlag] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateLagResponse = {
      import CreateLagResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateLagResponse.builder().optionallyWith(connectionsBandwidth.map(value => value: java.lang.String))(_.connectionsBandwidth).optionallyWith(numberOfConnections.map(value => value: java.lang.Integer))(_.numberOfConnections).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(lagName.map(value => value: java.lang.String))(_.lagName).optionallyWith(lagState.map(value => value.unwrap))(_.lagState).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(minimumLinks.map(value => value: java.lang.Integer))(_.minimumLinks).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).optionallyWith(allowsHostedConnections.map(value => value: java.lang.Boolean))(_.allowsHostedConnections).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: CreateLagResponse.ReadOnly = CreateLagResponse.wrap(buildAwsValue())
  }
  object CreateLagResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateLagResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateLagResponse = CreateLagResponse(connectionsBandwidthValue.map(value => value), numberOfConnectionsValue.map(value => value), lagIdValue.map(value => value), ownerAccountValue.map(value => value), lagNameValue.map(value => value), lagStateValue.map(value => value), locationValue.map(value => value), regionValue.map(value => value), minimumLinksValue.map(value => value), awsDeviceValue.map(value => value), awsDeviceV2Value.map(value => value), connectionsValue.map(value => value.map { item => 
        item.editable
      }), allowsHostedConnectionsValue.map(value => value), jumboFrameCapableValue.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def connectionsBandwidthValue: scala.Option[primitives.Bandwidth]
      def numberOfConnectionsValue: scala.Option[primitives.Count]
      def lagIdValue: scala.Option[primitives.LagId]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def lagNameValue: scala.Option[primitives.LagName]
      def lagStateValue: scala.Option[LagState]
      def locationValue: scala.Option[primitives.LocationCode]
      def regionValue: scala.Option[primitives.Region]
      def minimumLinksValue: scala.Option[primitives.Count]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def connectionsBandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidthValue)
      def numberOfConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfConnections", numberOfConnectionsValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def lagName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagName", lagNameValue)
      def lagState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LagState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagState", lagStateValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def minimumLinks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumLinks", minimumLinksValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
      def allowsHostedConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanFlag] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowsHostedConnections", allowsHostedConnectionsValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateLagResponse) extends CreateLagResponse.ReadOnly {
      override def connectionsBandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.connectionsBandwidth()).map(value => value: primitives.Bandwidth)
      override def numberOfConnectionsValue: scala.Option[primitives.Count] = scala.Option(impl.numberOfConnections()).map(value => value: primitives.Count)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def lagNameValue: scala.Option[primitives.LagName] = scala.Option(impl.lagName()).map(value => value: primitives.LagName)
      override def lagStateValue: scala.Option[LagState] = scala.Option(impl.lagState()).map(value => LagState.wrap(value))
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def minimumLinksValue: scala.Option[primitives.Count] = scala.Option(impl.minimumLinks()).map(value => value: primitives.Count)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
      override def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag] = scala.Option(impl.allowsHostedConnections()).map(value => value: primitives.BooleanFlag)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateLagResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreatePrivateVirtualInterfaceRequest(connectionId: primitives.ConnectionId, newPrivateVirtualInterface: NewPrivateVirtualInterface) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest = {
      import CreatePrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).newPrivateVirtualInterface(newPrivateVirtualInterface.buildAwsValue()).build()
    }
    def asReadOnly: CreatePrivateVirtualInterfaceRequest.ReadOnly = CreatePrivateVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object CreatePrivateVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreatePrivateVirtualInterfaceRequest = CreatePrivateVirtualInterfaceRequest(connectionIdValue, newPrivateVirtualInterfaceValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def newPrivateVirtualInterfaceValue: NewPrivateVirtualInterface.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def newPrivateVirtualInterface: ZIO[Any, Nothing, NewPrivateVirtualInterface.ReadOnly] = ZIO.succeed(newPrivateVirtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest) extends CreatePrivateVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def newPrivateVirtualInterfaceValue: NewPrivateVirtualInterface.ReadOnly = NewPrivateVirtualInterface.wrap(impl.newPrivateVirtualInterface())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreatePrivateVirtualInterfaceResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse = {
      import CreatePrivateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreatePrivateVirtualInterfaceResponse.ReadOnly = CreatePrivateVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object CreatePrivateVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreatePrivateVirtualInterfaceResponse = CreatePrivateVirtualInterfaceResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse) extends CreatePrivateVirtualInterfaceResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreatePublicVirtualInterfaceRequest(connectionId: primitives.ConnectionId, newPublicVirtualInterface: NewPublicVirtualInterface) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest = {
      import CreatePublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).newPublicVirtualInterface(newPublicVirtualInterface.buildAwsValue()).build()
    }
    def asReadOnly: CreatePublicVirtualInterfaceRequest.ReadOnly = CreatePublicVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object CreatePublicVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreatePublicVirtualInterfaceRequest = CreatePublicVirtualInterfaceRequest(connectionIdValue, newPublicVirtualInterfaceValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def newPublicVirtualInterfaceValue: NewPublicVirtualInterface.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def newPublicVirtualInterface: ZIO[Any, Nothing, NewPublicVirtualInterface.ReadOnly] = ZIO.succeed(newPublicVirtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest) extends CreatePublicVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def newPublicVirtualInterfaceValue: NewPublicVirtualInterface.ReadOnly = NewPublicVirtualInterface.wrap(impl.newPublicVirtualInterface())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreatePublicVirtualInterfaceResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse = {
      import CreatePublicVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreatePublicVirtualInterfaceResponse.ReadOnly = CreatePublicVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object CreatePublicVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreatePublicVirtualInterfaceResponse = CreatePublicVirtualInterfaceResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse) extends CreatePublicVirtualInterfaceResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateTransitVirtualInterfaceRequest(connectionId: primitives.ConnectionId, newTransitVirtualInterface: NewTransitVirtualInterface) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest = {
      import CreateTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest.builder().connectionId(connectionId: java.lang.String).newTransitVirtualInterface(newTransitVirtualInterface.buildAwsValue()).build()
    }
    def asReadOnly: CreateTransitVirtualInterfaceRequest.ReadOnly = CreateTransitVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object CreateTransitVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateTransitVirtualInterfaceRequest = CreateTransitVirtualInterfaceRequest(connectionIdValue, newTransitVirtualInterfaceValue.editable)
      def connectionIdValue: primitives.ConnectionId
      def newTransitVirtualInterfaceValue: NewTransitVirtualInterface.ReadOnly
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def newTransitVirtualInterface: ZIO[Any, Nothing, NewTransitVirtualInterface.ReadOnly] = ZIO.succeed(newTransitVirtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest) extends CreateTransitVirtualInterfaceRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def newTransitVirtualInterfaceValue: NewTransitVirtualInterface.ReadOnly = NewTransitVirtualInterface.wrap(impl.newTransitVirtualInterface())
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateTransitVirtualInterfaceResponse(virtualInterface: scala.Option[VirtualInterface] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse = {
      import CreateTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse.builder().optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(_.virtualInterface).build()
    }
    def asReadOnly: CreateTransitVirtualInterfaceResponse.ReadOnly = CreateTransitVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object CreateTransitVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateTransitVirtualInterfaceResponse = CreateTransitVirtualInterfaceResponse(virtualInterfaceValue.map(value => value.editable))
      def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly]
      def virtualInterface: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterface.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterface", virtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse) extends CreateTransitVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly] = scala.Option(impl.virtualInterface()).map(value => VirtualInterface.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteBgpPeerRequest(virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, asn: scala.Option[primitives.ASN] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, bgpPeerId: scala.Option[primitives.BGPPeerId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest = {
      import DeleteBgpPeerRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest.builder().optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(bgpPeerId.map(value => value: java.lang.String))(_.bgpPeerId).build()
    }
    def asReadOnly: DeleteBgpPeerRequest.ReadOnly = DeleteBgpPeerRequest.wrap(buildAwsValue())
  }
  object DeleteBgpPeerRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteBgpPeerRequest = DeleteBgpPeerRequest(virtualInterfaceIdValue.map(value => value), asnValue.map(value => value), customerAddressValue.map(value => value), bgpPeerIdValue.map(value => value))
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def asnValue: scala.Option[primitives.ASN]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def bgpPeerIdValue: scala.Option[primitives.BGPPeerId]
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def bgpPeerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPPeerId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeerId", bgpPeerIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest) extends DeleteBgpPeerRequest.ReadOnly {
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def bgpPeerIdValue: scala.Option[primitives.BGPPeerId] = scala.Option(impl.bgpPeerId()).map(value => value: primitives.BGPPeerId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteBgpPeerResponse(virtualInterface: scala.Option[VirtualInterface] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse = {
      import DeleteBgpPeerResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse.builder().optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(_.virtualInterface).build()
    }
    def asReadOnly: DeleteBgpPeerResponse.ReadOnly = DeleteBgpPeerResponse.wrap(buildAwsValue())
  }
  object DeleteBgpPeerResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteBgpPeerResponse = DeleteBgpPeerResponse(virtualInterfaceValue.map(value => value.editable))
      def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly]
      def virtualInterface: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterface.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterface", virtualInterfaceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse) extends DeleteBgpPeerResponse.ReadOnly { override def virtualInterfaceValue: scala.Option[VirtualInterface.ReadOnly] = scala.Option(impl.virtualInterface()).map(value => VirtualInterface.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteConnectionRequest(connectionId: primitives.ConnectionId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest = {
      import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest.builder().connectionId(connectionId: java.lang.String).build()
    }
    def asReadOnly: DeleteConnectionRequest.ReadOnly = DeleteConnectionRequest.wrap(buildAwsValue())
  }
  object DeleteConnectionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteConnectionRequest = DeleteConnectionRequest(connectionIdValue)
      def connectionIdValue: primitives.ConnectionId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest) extends DeleteConnectionRequest.ReadOnly { override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteConnectionResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse = {
      import DeleteConnectionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: DeleteConnectionResponse.ReadOnly = DeleteConnectionResponse.wrap(buildAwsValue())
  }
  object DeleteConnectionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteConnectionResponse = DeleteConnectionResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse) extends DeleteConnectionResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayAssociationProposalRequest(proposalId: primitives.DirectConnectGatewayAssociationProposalId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest = {
      import DeleteDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest.builder().proposalId(proposalId: java.lang.String).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayAssociationProposalRequest.ReadOnly = DeleteDirectConnectGatewayAssociationProposalRequest.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayAssociationProposalRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayAssociationProposalRequest = DeleteDirectConnectGatewayAssociationProposalRequest(proposalIdValue)
      def proposalIdValue: primitives.DirectConnectGatewayAssociationProposalId
      def proposalId: ZIO[Any, Nothing, primitives.DirectConnectGatewayAssociationProposalId] = ZIO.succeed(proposalIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest) extends DeleteDirectConnectGatewayAssociationProposalRequest.ReadOnly { override def proposalIdValue: primitives.DirectConnectGatewayAssociationProposalId = impl.proposalId(): primitives.DirectConnectGatewayAssociationProposalId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociationProposal: scala.Option[DirectConnectGatewayAssociationProposal] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse = {
      import DeleteDirectConnectGatewayAssociationProposalResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.builder().optionallyWith(directConnectGatewayAssociationProposal.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociationProposal).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly = DeleteDirectConnectGatewayAssociationProposalResponse.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayAssociationProposalResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayAssociationProposalResponse = DeleteDirectConnectGatewayAssociationProposalResponse(directConnectGatewayAssociationProposalValue.map(value => value.editable))
      def directConnectGatewayAssociationProposalValue: scala.Option[DirectConnectGatewayAssociationProposal.ReadOnly]
      def directConnectGatewayAssociationProposal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociationProposal.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociationProposal", directConnectGatewayAssociationProposalValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse) extends DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly { override def directConnectGatewayAssociationProposalValue: scala.Option[DirectConnectGatewayAssociationProposal.ReadOnly] = scala.Option(impl.directConnectGatewayAssociationProposal()).map(value => DirectConnectGatewayAssociationProposal.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayAssociationRequest(associationId: scala.Option[primitives.DirectConnectGatewayAssociationId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest = {
      import DeleteDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest.builder().optionallyWith(associationId.map(value => value: java.lang.String))(_.associationId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayAssociationRequest.ReadOnly = DeleteDirectConnectGatewayAssociationRequest.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayAssociationRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayAssociationRequest = DeleteDirectConnectGatewayAssociationRequest(associationIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), virtualGatewayIdValue.map(value => value))
      def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def associationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationId", associationIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest) extends DeleteDirectConnectGatewayAssociationRequest.ReadOnly {
      override def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId] = scala.Option(impl.associationId()).map(value => value: primitives.DirectConnectGatewayAssociationId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayAssociationResponse(directConnectGatewayAssociation: scala.Option[DirectConnectGatewayAssociation] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse = {
      import DeleteDirectConnectGatewayAssociationResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.builder().optionallyWith(directConnectGatewayAssociation.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociation).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayAssociationResponse.ReadOnly = DeleteDirectConnectGatewayAssociationResponse.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayAssociationResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayAssociationResponse = DeleteDirectConnectGatewayAssociationResponse(directConnectGatewayAssociationValue.map(value => value.editable))
      def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly]
      def directConnectGatewayAssociation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociation", directConnectGatewayAssociationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse) extends DeleteDirectConnectGatewayAssociationResponse.ReadOnly { override def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly] = scala.Option(impl.directConnectGatewayAssociation()).map(value => DirectConnectGatewayAssociation.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayRequest(directConnectGatewayId: primitives.DirectConnectGatewayId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest = {
      import DeleteDirectConnectGatewayRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest.builder().directConnectGatewayId(directConnectGatewayId: java.lang.String).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayRequest.ReadOnly = DeleteDirectConnectGatewayRequest.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayRequest = DeleteDirectConnectGatewayRequest(directConnectGatewayIdValue)
      def directConnectGatewayIdValue: primitives.DirectConnectGatewayId
      def directConnectGatewayId: ZIO[Any, Nothing, primitives.DirectConnectGatewayId] = ZIO.succeed(directConnectGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest) extends DeleteDirectConnectGatewayRequest.ReadOnly { override def directConnectGatewayIdValue: primitives.DirectConnectGatewayId = impl.directConnectGatewayId(): primitives.DirectConnectGatewayId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDirectConnectGatewayResponse(directConnectGateway: scala.Option[DirectConnectGateway] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse = {
      import DeleteDirectConnectGatewayResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse.builder().optionallyWith(directConnectGateway.map(value => value.buildAwsValue()))(_.directConnectGateway).build()
    }
    def asReadOnly: DeleteDirectConnectGatewayResponse.ReadOnly = DeleteDirectConnectGatewayResponse.wrap(buildAwsValue())
  }
  object DeleteDirectConnectGatewayResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDirectConnectGatewayResponse = DeleteDirectConnectGatewayResponse(directConnectGatewayValue.map(value => value.editable))
      def directConnectGatewayValue: scala.Option[DirectConnectGateway.ReadOnly]
      def directConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGateway.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGateway", directConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse) extends DeleteDirectConnectGatewayResponse.ReadOnly { override def directConnectGatewayValue: scala.Option[DirectConnectGateway.ReadOnly] = scala.Option(impl.directConnectGateway()).map(value => DirectConnectGateway.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteInterconnectRequest(interconnectId: primitives.InterconnectId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest = {
      import DeleteInterconnectRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest.builder().interconnectId(interconnectId: java.lang.String).build()
    }
    def asReadOnly: DeleteInterconnectRequest.ReadOnly = DeleteInterconnectRequest.wrap(buildAwsValue())
  }
  object DeleteInterconnectRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteInterconnectRequest = DeleteInterconnectRequest(interconnectIdValue)
      def interconnectIdValue: primitives.InterconnectId
      def interconnectId: ZIO[Any, Nothing, primitives.InterconnectId] = ZIO.succeed(interconnectIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest) extends DeleteInterconnectRequest.ReadOnly { override def interconnectIdValue: primitives.InterconnectId = impl.interconnectId(): primitives.InterconnectId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteInterconnectResponse(interconnectState: scala.Option[InterconnectState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse = {
      import DeleteInterconnectResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse.builder().optionallyWith(interconnectState.map(value => value.unwrap))(_.interconnectState).build()
    }
    def asReadOnly: DeleteInterconnectResponse.ReadOnly = DeleteInterconnectResponse.wrap(buildAwsValue())
  }
  object DeleteInterconnectResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteInterconnectResponse = DeleteInterconnectResponse(interconnectStateValue.map(value => value))
      def interconnectStateValue: scala.Option[InterconnectState]
      def interconnectState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InterconnectState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectState", interconnectStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse) extends DeleteInterconnectResponse.ReadOnly { override def interconnectStateValue: scala.Option[InterconnectState] = scala.Option(impl.interconnectState()).map(value => InterconnectState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteLagRequest(lagId: primitives.LagId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteLagRequest = {
      import DeleteLagRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteLagRequest.builder().lagId(lagId: java.lang.String).build()
    }
    def asReadOnly: DeleteLagRequest.ReadOnly = DeleteLagRequest.wrap(buildAwsValue())
  }
  object DeleteLagRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteLagRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteLagRequest = DeleteLagRequest(lagIdValue)
      def lagIdValue: primitives.LagId
      def lagId: ZIO[Any, Nothing, primitives.LagId] = ZIO.succeed(lagIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteLagRequest) extends DeleteLagRequest.ReadOnly { override def lagIdValue: primitives.LagId = impl.lagId(): primitives.LagId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteLagRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteLagResponse(connectionsBandwidth: scala.Option[primitives.Bandwidth] = None, numberOfConnections: scala.Option[primitives.Count] = None, lagId: scala.Option[primitives.LagId] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, lagName: scala.Option[primitives.LagName] = None, lagState: scala.Option[LagState] = None, location: scala.Option[primitives.LocationCode] = None, region: scala.Option[primitives.Region] = None, minimumLinks: scala.Option[primitives.Count] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, connections: scala.Option[Iterable[Connection]] = None, allowsHostedConnections: scala.Option[primitives.BooleanFlag] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteLagResponse = {
      import DeleteLagResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteLagResponse.builder().optionallyWith(connectionsBandwidth.map(value => value: java.lang.String))(_.connectionsBandwidth).optionallyWith(numberOfConnections.map(value => value: java.lang.Integer))(_.numberOfConnections).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(lagName.map(value => value: java.lang.String))(_.lagName).optionallyWith(lagState.map(value => value.unwrap))(_.lagState).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(minimumLinks.map(value => value: java.lang.Integer))(_.minimumLinks).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).optionallyWith(allowsHostedConnections.map(value => value: java.lang.Boolean))(_.allowsHostedConnections).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: DeleteLagResponse.ReadOnly = DeleteLagResponse.wrap(buildAwsValue())
  }
  object DeleteLagResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteLagResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteLagResponse = DeleteLagResponse(connectionsBandwidthValue.map(value => value), numberOfConnectionsValue.map(value => value), lagIdValue.map(value => value), ownerAccountValue.map(value => value), lagNameValue.map(value => value), lagStateValue.map(value => value), locationValue.map(value => value), regionValue.map(value => value), minimumLinksValue.map(value => value), awsDeviceValue.map(value => value), awsDeviceV2Value.map(value => value), connectionsValue.map(value => value.map { item => 
        item.editable
      }), allowsHostedConnectionsValue.map(value => value), jumboFrameCapableValue.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def connectionsBandwidthValue: scala.Option[primitives.Bandwidth]
      def numberOfConnectionsValue: scala.Option[primitives.Count]
      def lagIdValue: scala.Option[primitives.LagId]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def lagNameValue: scala.Option[primitives.LagName]
      def lagStateValue: scala.Option[LagState]
      def locationValue: scala.Option[primitives.LocationCode]
      def regionValue: scala.Option[primitives.Region]
      def minimumLinksValue: scala.Option[primitives.Count]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def connectionsBandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidthValue)
      def numberOfConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfConnections", numberOfConnectionsValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def lagName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagName", lagNameValue)
      def lagState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LagState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagState", lagStateValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def minimumLinks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumLinks", minimumLinksValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
      def allowsHostedConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanFlag] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowsHostedConnections", allowsHostedConnectionsValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteLagResponse) extends DeleteLagResponse.ReadOnly {
      override def connectionsBandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.connectionsBandwidth()).map(value => value: primitives.Bandwidth)
      override def numberOfConnectionsValue: scala.Option[primitives.Count] = scala.Option(impl.numberOfConnections()).map(value => value: primitives.Count)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def lagNameValue: scala.Option[primitives.LagName] = scala.Option(impl.lagName()).map(value => value: primitives.LagName)
      override def lagStateValue: scala.Option[LagState] = scala.Option(impl.lagState()).map(value => LagState.wrap(value))
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def minimumLinksValue: scala.Option[primitives.Count] = scala.Option(impl.minimumLinks()).map(value => value: primitives.Count)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
      override def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag] = scala.Option(impl.allowsHostedConnections()).map(value => value: primitives.BooleanFlag)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteLagResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteVirtualInterfaceRequest(virtualInterfaceId: primitives.VirtualInterfaceId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest = {
      import DeleteVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).build()
    }
    def asReadOnly: DeleteVirtualInterfaceRequest.ReadOnly = DeleteVirtualInterfaceRequest.wrap(buildAwsValue())
  }
  object DeleteVirtualInterfaceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteVirtualInterfaceRequest = DeleteVirtualInterfaceRequest(virtualInterfaceIdValue)
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest) extends DeleteVirtualInterfaceRequest.ReadOnly { override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteVirtualInterfaceResponse(virtualInterfaceState: scala.Option[VirtualInterfaceState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse = {
      import DeleteVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse.builder().optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).build()
    }
    def asReadOnly: DeleteVirtualInterfaceResponse.ReadOnly = DeleteVirtualInterfaceResponse.wrap(buildAwsValue())
  }
  object DeleteVirtualInterfaceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteVirtualInterfaceResponse = DeleteVirtualInterfaceResponse(virtualInterfaceStateValue.map(value => value))
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse) extends DeleteVirtualInterfaceResponse.ReadOnly { override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeConnectionsRequest(connectionId: scala.Option[primitives.ConnectionId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest = {
      import DescribeConnectionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest.builder().optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).build()
    }
    def asReadOnly: DescribeConnectionsRequest.ReadOnly = DescribeConnectionsRequest.wrap(buildAwsValue())
  }
  object DescribeConnectionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeConnectionsRequest = DescribeConnectionsRequest(connectionIdValue.map(value => value))
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest) extends DescribeConnectionsRequest.ReadOnly { override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeConnectionsResponse(connections: scala.Option[Iterable[Connection]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse = {
      import DescribeConnectionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse.builder().optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).build()
    }
    def asReadOnly: DescribeConnectionsResponse.ReadOnly = DescribeConnectionsResponse.wrap(buildAwsValue())
  }
  object DescribeConnectionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeConnectionsResponse = DescribeConnectionsResponse(connectionsValue.map(value => value.map { item => 
        item.editable
      }))
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse) extends DescribeConnectionsResponse.ReadOnly {
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAssociationProposalsRequest(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, proposalId: scala.Option[primitives.DirectConnectGatewayAssociationProposalId] = None, associatedGatewayId: scala.Option[primitives.AssociatedGatewayId] = None, maxResults: scala.Option[primitives.MaxResultSetSize] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest = {
      import DescribeDirectConnectGatewayAssociationProposalsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(proposalId.map(value => value: java.lang.String))(_.proposalId).optionallyWith(associatedGatewayId.map(value => value: java.lang.String))(_.associatedGatewayId).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAssociationProposalsRequest.ReadOnly = DescribeDirectConnectGatewayAssociationProposalsRequest.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAssociationProposalsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAssociationProposalsRequest = DescribeDirectConnectGatewayAssociationProposalsRequest(directConnectGatewayIdValue.map(value => value), proposalIdValue.map(value => value), associatedGatewayIdValue.map(value => value), maxResultsValue.map(value => value), nextTokenValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def proposalIdValue: scala.Option[primitives.DirectConnectGatewayAssociationProposalId]
      def associatedGatewayIdValue: scala.Option[primitives.AssociatedGatewayId]
      def maxResultsValue: scala.Option[primitives.MaxResultSetSize]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def proposalId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationProposalId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("proposalId", proposalIdValue)
      def associatedGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AssociatedGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedGatewayId", associatedGatewayIdValue)
      def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultSetSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest) extends DescribeDirectConnectGatewayAssociationProposalsRequest.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def proposalIdValue: scala.Option[primitives.DirectConnectGatewayAssociationProposalId] = scala.Option(impl.proposalId()).map(value => value: primitives.DirectConnectGatewayAssociationProposalId)
      override def associatedGatewayIdValue: scala.Option[primitives.AssociatedGatewayId] = scala.Option(impl.associatedGatewayId()).map(value => value: primitives.AssociatedGatewayId)
      override def maxResultsValue: scala.Option[primitives.MaxResultSetSize] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultSetSize)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAssociationProposalsResponse(directConnectGatewayAssociationProposals: scala.Option[Iterable[DirectConnectGatewayAssociationProposal]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse = {
      import DescribeDirectConnectGatewayAssociationProposalsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.builder().optionallyWith(directConnectGatewayAssociationProposals.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.directConnectGatewayAssociationProposals).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly = DescribeDirectConnectGatewayAssociationProposalsResponse.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAssociationProposalsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAssociationProposalsResponse = DescribeDirectConnectGatewayAssociationProposalsResponse(directConnectGatewayAssociationProposalsValue.map(value => value.map { item => 
        item.editable
      }), nextTokenValue.map(value => value))
      def directConnectGatewayAssociationProposalsValue: scala.Option[List[DirectConnectGatewayAssociationProposal.ReadOnly]]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayAssociationProposals: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DirectConnectGatewayAssociationProposal.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociationProposals", directConnectGatewayAssociationProposalsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse) extends DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly {
      override def directConnectGatewayAssociationProposalsValue: scala.Option[List[DirectConnectGatewayAssociationProposal.ReadOnly]] = scala.Option(impl.directConnectGatewayAssociationProposals()).map(value => value.asScala.map { item => 
        DirectConnectGatewayAssociationProposal.wrap(item)
      }.toList)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAssociationsRequest(associationId: scala.Option[primitives.DirectConnectGatewayAssociationId] = None, associatedGatewayId: scala.Option[primitives.AssociatedGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, maxResults: scala.Option[primitives.MaxResultSetSize] = None, nextToken: scala.Option[primitives.PaginationToken] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest = {
      import DescribeDirectConnectGatewayAssociationsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.builder().optionallyWith(associationId.map(value => value: java.lang.String))(_.associationId).optionallyWith(associatedGatewayId.map(value => value: java.lang.String))(_.associatedGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAssociationsRequest.ReadOnly = DescribeDirectConnectGatewayAssociationsRequest.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAssociationsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAssociationsRequest = DescribeDirectConnectGatewayAssociationsRequest(associationIdValue.map(value => value), associatedGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), maxResultsValue.map(value => value), nextTokenValue.map(value => value), virtualGatewayIdValue.map(value => value))
      def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId]
      def associatedGatewayIdValue: scala.Option[primitives.AssociatedGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def maxResultsValue: scala.Option[primitives.MaxResultSetSize]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def associationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationId", associationIdValue)
      def associatedGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AssociatedGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedGatewayId", associatedGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultSetSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest) extends DescribeDirectConnectGatewayAssociationsRequest.ReadOnly {
      override def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId] = scala.Option(impl.associationId()).map(value => value: primitives.DirectConnectGatewayAssociationId)
      override def associatedGatewayIdValue: scala.Option[primitives.AssociatedGatewayId] = scala.Option(impl.associatedGatewayId()).map(value => value: primitives.AssociatedGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def maxResultsValue: scala.Option[primitives.MaxResultSetSize] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultSetSize)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAssociationsResponse(directConnectGatewayAssociations: scala.Option[Iterable[DirectConnectGatewayAssociation]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse = {
      import DescribeDirectConnectGatewayAssociationsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.builder().optionallyWith(directConnectGatewayAssociations.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.directConnectGatewayAssociations).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAssociationsResponse.ReadOnly = DescribeDirectConnectGatewayAssociationsResponse.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAssociationsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAssociationsResponse = DescribeDirectConnectGatewayAssociationsResponse(directConnectGatewayAssociationsValue.map(value => value.map { item => 
        item.editable
      }), nextTokenValue.map(value => value))
      def directConnectGatewayAssociationsValue: scala.Option[List[DirectConnectGatewayAssociation.ReadOnly]]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayAssociations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DirectConnectGatewayAssociation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociations", directConnectGatewayAssociationsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse) extends DescribeDirectConnectGatewayAssociationsResponse.ReadOnly {
      override def directConnectGatewayAssociationsValue: scala.Option[List[DirectConnectGatewayAssociation.ReadOnly]] = scala.Option(impl.directConnectGatewayAssociations()).map(value => value.asScala.map { item => 
        DirectConnectGatewayAssociation.wrap(item)
      }.toList)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAttachmentsRequest(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, maxResults: scala.Option[primitives.MaxResultSetSize] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest = {
      import DescribeDirectConnectGatewayAttachmentsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAttachmentsRequest.ReadOnly = DescribeDirectConnectGatewayAttachmentsRequest.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAttachmentsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAttachmentsRequest = DescribeDirectConnectGatewayAttachmentsRequest(directConnectGatewayIdValue.map(value => value), virtualInterfaceIdValue.map(value => value), maxResultsValue.map(value => value), nextTokenValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def maxResultsValue: scala.Option[primitives.MaxResultSetSize]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultSetSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest) extends DescribeDirectConnectGatewayAttachmentsRequest.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def maxResultsValue: scala.Option[primitives.MaxResultSetSize] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultSetSize)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewayAttachmentsResponse(directConnectGatewayAttachments: scala.Option[Iterable[DirectConnectGatewayAttachment]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse = {
      import DescribeDirectConnectGatewayAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.builder().optionallyWith(directConnectGatewayAttachments.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.directConnectGatewayAttachments).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly = DescribeDirectConnectGatewayAttachmentsResponse.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewayAttachmentsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewayAttachmentsResponse = DescribeDirectConnectGatewayAttachmentsResponse(directConnectGatewayAttachmentsValue.map(value => value.map { item => 
        item.editable
      }), nextTokenValue.map(value => value))
      def directConnectGatewayAttachmentsValue: scala.Option[List[DirectConnectGatewayAttachment.ReadOnly]]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayAttachments: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DirectConnectGatewayAttachment.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAttachments", directConnectGatewayAttachmentsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse) extends DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly {
      override def directConnectGatewayAttachmentsValue: scala.Option[List[DirectConnectGatewayAttachment.ReadOnly]] = scala.Option(impl.directConnectGatewayAttachments()).map(value => value.asScala.map { item => 
        DirectConnectGatewayAttachment.wrap(item)
      }.toList)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewaysRequest(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, maxResults: scala.Option[primitives.MaxResultSetSize] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest = {
      import DescribeDirectConnectGatewaysRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewaysRequest.ReadOnly = DescribeDirectConnectGatewaysRequest.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewaysRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewaysRequest = DescribeDirectConnectGatewaysRequest(directConnectGatewayIdValue.map(value => value), maxResultsValue.map(value => value), nextTokenValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def maxResultsValue: scala.Option[primitives.MaxResultSetSize]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultSetSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest) extends DescribeDirectConnectGatewaysRequest.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def maxResultsValue: scala.Option[primitives.MaxResultSetSize] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultSetSize)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDirectConnectGatewaysResponse(directConnectGateways: scala.Option[Iterable[DirectConnectGateway]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse = {
      import DescribeDirectConnectGatewaysResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse.builder().optionallyWith(directConnectGateways.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.directConnectGateways).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: DescribeDirectConnectGatewaysResponse.ReadOnly = DescribeDirectConnectGatewaysResponse.wrap(buildAwsValue())
  }
  object DescribeDirectConnectGatewaysResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDirectConnectGatewaysResponse = DescribeDirectConnectGatewaysResponse(directConnectGatewaysValue.map(value => value.map { item => 
        item.editable
      }), nextTokenValue.map(value => value))
      def directConnectGatewaysValue: scala.Option[List[DirectConnectGateway.ReadOnly]]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def directConnectGateways: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DirectConnectGateway.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGateways", directConnectGatewaysValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse) extends DescribeDirectConnectGatewaysResponse.ReadOnly {
      override def directConnectGatewaysValue: scala.Option[List[DirectConnectGateway.ReadOnly]] = scala.Option(impl.directConnectGateways()).map(value => value.asScala.map { item => 
        DirectConnectGateway.wrap(item)
      }.toList)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeHostedConnectionsRequest(connectionId: primitives.ConnectionId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest = {
      import DescribeHostedConnectionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest.builder().connectionId(connectionId: java.lang.String).build()
    }
    def asReadOnly: DescribeHostedConnectionsRequest.ReadOnly = DescribeHostedConnectionsRequest.wrap(buildAwsValue())
  }
  object DescribeHostedConnectionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeHostedConnectionsRequest = DescribeHostedConnectionsRequest(connectionIdValue)
      def connectionIdValue: primitives.ConnectionId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest) extends DescribeHostedConnectionsRequest.ReadOnly { override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeHostedConnectionsResponse(connections: scala.Option[Iterable[Connection]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse = {
      import DescribeHostedConnectionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse.builder().optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).build()
    }
    def asReadOnly: DescribeHostedConnectionsResponse.ReadOnly = DescribeHostedConnectionsResponse.wrap(buildAwsValue())
  }
  object DescribeHostedConnectionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeHostedConnectionsResponse = DescribeHostedConnectionsResponse(connectionsValue.map(value => value.map { item => 
        item.editable
      }))
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse) extends DescribeHostedConnectionsResponse.ReadOnly {
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeInterconnectsRequest(interconnectId: scala.Option[primitives.InterconnectId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest = {
      import DescribeInterconnectsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest.builder().optionallyWith(interconnectId.map(value => value: java.lang.String))(_.interconnectId).build()
    }
    def asReadOnly: DescribeInterconnectsRequest.ReadOnly = DescribeInterconnectsRequest.wrap(buildAwsValue())
  }
  object DescribeInterconnectsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeInterconnectsRequest = DescribeInterconnectsRequest(interconnectIdValue.map(value => value))
      def interconnectIdValue: scala.Option[primitives.InterconnectId]
      def interconnectId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InterconnectId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectId", interconnectIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest) extends DescribeInterconnectsRequest.ReadOnly { override def interconnectIdValue: scala.Option[primitives.InterconnectId] = scala.Option(impl.interconnectId()).map(value => value: primitives.InterconnectId) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeInterconnectsResponse(interconnects: scala.Option[Iterable[Interconnect]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse = {
      import DescribeInterconnectsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse.builder().optionallyWith(interconnects.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.interconnects).build()
    }
    def asReadOnly: DescribeInterconnectsResponse.ReadOnly = DescribeInterconnectsResponse.wrap(buildAwsValue())
  }
  object DescribeInterconnectsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeInterconnectsResponse = DescribeInterconnectsResponse(interconnectsValue.map(value => value.map { item => 
        item.editable
      }))
      def interconnectsValue: scala.Option[List[Interconnect.ReadOnly]]
      def interconnects: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Interconnect.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnects", interconnectsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse) extends DescribeInterconnectsResponse.ReadOnly {
      override def interconnectsValue: scala.Option[List[Interconnect.ReadOnly]] = scala.Option(impl.interconnects()).map(value => value.asScala.map { item => 
        Interconnect.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeLagsRequest(lagId: scala.Option[primitives.LagId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest = {
      import DescribeLagsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest.builder().optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).build()
    }
    def asReadOnly: DescribeLagsRequest.ReadOnly = DescribeLagsRequest.wrap(buildAwsValue())
  }
  object DescribeLagsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeLagsRequest = DescribeLagsRequest(lagIdValue.map(value => value))
      def lagIdValue: scala.Option[primitives.LagId]
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest) extends DescribeLagsRequest.ReadOnly { override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeLagsResponse(lags: scala.Option[Iterable[Lag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse = {
      import DescribeLagsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse.builder().optionallyWith(lags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.lags).build()
    }
    def asReadOnly: DescribeLagsResponse.ReadOnly = DescribeLagsResponse.wrap(buildAwsValue())
  }
  object DescribeLagsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeLagsResponse = DescribeLagsResponse(lagsValue.map(value => value.map { item => 
        item.editable
      }))
      def lagsValue: scala.Option[List[Lag.ReadOnly]]
      def lags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Lag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lags", lagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse) extends DescribeLagsResponse.ReadOnly {
      override def lagsValue: scala.Option[List[Lag.ReadOnly]] = scala.Option(impl.lags()).map(value => value.asScala.map { item => 
        Lag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeLoaRequest(connectionId: primitives.ConnectionId, providerName: scala.Option[primitives.ProviderName] = None, loaContentType: scala.Option[LoaContentType] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest = {
      import DescribeLoaRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest.builder().connectionId(connectionId: java.lang.String).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).optionallyWith(loaContentType.map(value => value.unwrap))(_.loaContentType).build()
    }
    def asReadOnly: DescribeLoaRequest.ReadOnly = DescribeLoaRequest.wrap(buildAwsValue())
  }
  object DescribeLoaRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeLoaRequest = DescribeLoaRequest(connectionIdValue, providerNameValue.map(value => value), loaContentTypeValue.map(value => value))
      def connectionIdValue: primitives.ConnectionId
      def providerNameValue: scala.Option[primitives.ProviderName]
      def loaContentTypeValue: scala.Option[LoaContentType]
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
      def loaContentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoaContentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaContentType", loaContentTypeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest) extends DescribeLoaRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
      override def loaContentTypeValue: scala.Option[LoaContentType] = scala.Option(impl.loaContentType()).map(value => LoaContentType.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeLoaResponse(loaContent: scala.Option[primitives.LoaContent] = None, loaContentType: scala.Option[LoaContentType] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse = {
      import DescribeLoaResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse.builder().optionallyWith(loaContent.map(value => SdkBytes.fromByteArray(value.toArray[Byte])))(_.loaContent).optionallyWith(loaContentType.map(value => value.unwrap))(_.loaContentType).build()
    }
    def asReadOnly: DescribeLoaResponse.ReadOnly = DescribeLoaResponse.wrap(buildAwsValue())
  }
  object DescribeLoaResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeLoaResponse = DescribeLoaResponse(loaContentValue.map(value => value), loaContentTypeValue.map(value => value))
      def loaContentValue: scala.Option[primitives.LoaContent]
      def loaContentTypeValue: scala.Option[LoaContentType]
      def loaContent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaContent] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaContent", loaContentValue)
      def loaContentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoaContentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaContentType", loaContentTypeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse) extends DescribeLoaResponse.ReadOnly {
      override def loaContentValue: scala.Option[primitives.LoaContent] = scala.Option(impl.loaContent()).map(value => Chunk.fromByteBuffer(value.asByteBuffer()))
      override def loaContentTypeValue: scala.Option[LoaContentType] = scala.Option(impl.loaContentType()).map(value => LoaContentType.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeLocationsResponse(locations: scala.Option[Iterable[Location]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse = {
      import DescribeLocationsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse.builder().optionallyWith(locations.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.locations).build()
    }
    def asReadOnly: DescribeLocationsResponse.ReadOnly = DescribeLocationsResponse.wrap(buildAwsValue())
  }
  object DescribeLocationsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeLocationsResponse = DescribeLocationsResponse(locationsValue.map(value => value.map { item => 
        item.editable
      }))
      def locationsValue: scala.Option[List[Location.ReadOnly]]
      def locations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Location.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("locations", locationsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse) extends DescribeLocationsResponse.ReadOnly {
      override def locationsValue: scala.Option[List[Location.ReadOnly]] = scala.Option(impl.locations()).map(value => value.asScala.map { item => 
        Location.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeTagsRequest(resourceArns: Iterable[primitives.ResourceArn]) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest = {
      import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest.builder().resourceArns(resourceArns.map { item => 
        item: java.lang.String
      }.asJavaCollection).build()
    }
    def asReadOnly: DescribeTagsRequest.ReadOnly = DescribeTagsRequest.wrap(buildAwsValue())
  }
  object DescribeTagsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeTagsRequest = DescribeTagsRequest(resourceArnsValue)
      def resourceArnsValue: List[primitives.ResourceArn]
      def resourceArns: ZIO[Any, Nothing, List[primitives.ResourceArn]] = ZIO.succeed(resourceArnsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest) extends DescribeTagsRequest.ReadOnly {
      override def resourceArnsValue: List[primitives.ResourceArn] = impl.resourceArns().asScala.map { item => 
        item: primitives.ResourceArn
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeTagsResponse(resourceTags: scala.Option[Iterable[ResourceTag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse = {
      import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse.builder().optionallyWith(resourceTags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.resourceTags).build()
    }
    def asReadOnly: DescribeTagsResponse.ReadOnly = DescribeTagsResponse.wrap(buildAwsValue())
  }
  object DescribeTagsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeTagsResponse = DescribeTagsResponse(resourceTagsValue.map(value => value.map { item => 
        item.editable
      }))
      def resourceTagsValue: scala.Option[List[ResourceTag.ReadOnly]]
      def resourceTags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ResourceTag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceTags", resourceTagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse) extends DescribeTagsResponse.ReadOnly {
      override def resourceTagsValue: scala.Option[List[ResourceTag.ReadOnly]] = scala.Option(impl.resourceTags()).map(value => value.asScala.map { item => 
        ResourceTag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeVirtualGatewaysResponse(virtualGateways: scala.Option[Iterable[VirtualGateway]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse = {
      import DescribeVirtualGatewaysResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse.builder().optionallyWith(virtualGateways.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.virtualGateways).build()
    }
    def asReadOnly: DescribeVirtualGatewaysResponse.ReadOnly = DescribeVirtualGatewaysResponse.wrap(buildAwsValue())
  }
  object DescribeVirtualGatewaysResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeVirtualGatewaysResponse = DescribeVirtualGatewaysResponse(virtualGatewaysValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualGatewaysValue: scala.Option[List[VirtualGateway.ReadOnly]]
      def virtualGateways: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VirtualGateway.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGateways", virtualGatewaysValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse) extends DescribeVirtualGatewaysResponse.ReadOnly {
      override def virtualGatewaysValue: scala.Option[List[VirtualGateway.ReadOnly]] = scala.Option(impl.virtualGateways()).map(value => value.asScala.map { item => 
        VirtualGateway.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeVirtualInterfacesRequest(connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest = {
      import DescribeVirtualInterfacesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest.builder().optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).build()
    }
    def asReadOnly: DescribeVirtualInterfacesRequest.ReadOnly = DescribeVirtualInterfacesRequest.wrap(buildAwsValue())
  }
  object DescribeVirtualInterfacesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeVirtualInterfacesRequest = DescribeVirtualInterfacesRequest(connectionIdValue.map(value => value), virtualInterfaceIdValue.map(value => value))
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest) extends DescribeVirtualInterfacesRequest.ReadOnly {
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeVirtualInterfacesResponse(virtualInterfaces: scala.Option[Iterable[VirtualInterface]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse = {
      import DescribeVirtualInterfacesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse.builder().optionallyWith(virtualInterfaces.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.virtualInterfaces).build()
    }
    def asReadOnly: DescribeVirtualInterfacesResponse.ReadOnly = DescribeVirtualInterfacesResponse.wrap(buildAwsValue())
  }
  object DescribeVirtualInterfacesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeVirtualInterfacesResponse = DescribeVirtualInterfacesResponse(virtualInterfacesValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfacesValue: scala.Option[List[VirtualInterface.ReadOnly]]
      def virtualInterfaces: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VirtualInterface.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaces", virtualInterfacesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse) extends DescribeVirtualInterfacesResponse.ReadOnly {
      override def virtualInterfacesValue: scala.Option[List[VirtualInterface.ReadOnly]] = scala.Option(impl.virtualInterfaces()).map(value => value.asScala.map { item => 
        VirtualInterface.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DirectConnectGateway(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, directConnectGatewayName: scala.Option[primitives.DirectConnectGatewayName] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, directConnectGatewayState: scala.Option[DirectConnectGatewayState] = None, stateChangeError: scala.Option[primitives.StateChangeError] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DirectConnectGateway = {
      import DirectConnectGateway.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DirectConnectGateway.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(directConnectGatewayName.map(value => value: java.lang.String))(_.directConnectGatewayName).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(directConnectGatewayState.map(value => value.unwrap))(_.directConnectGatewayState).optionallyWith(stateChangeError.map(value => value: java.lang.String))(_.stateChangeError).build()
    }
    def asReadOnly: DirectConnectGateway.ReadOnly = DirectConnectGateway.wrap(buildAwsValue())
  }
  object DirectConnectGateway {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DirectConnectGateway] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DirectConnectGateway = DirectConnectGateway(directConnectGatewayIdValue.map(value => value), directConnectGatewayNameValue.map(value => value), amazonSideAsnValue.map(value => value), ownerAccountValue.map(value => value), directConnectGatewayStateValue.map(value => value), stateChangeErrorValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def directConnectGatewayNameValue: scala.Option[primitives.DirectConnectGatewayName]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def directConnectGatewayStateValue: scala.Option[DirectConnectGatewayState]
      def stateChangeErrorValue: scala.Option[primitives.StateChangeError]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def directConnectGatewayName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayName", directConnectGatewayNameValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def directConnectGatewayState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayState", directConnectGatewayStateValue)
      def stateChangeError: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StateChangeError] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("stateChangeError", stateChangeErrorValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGateway) extends DirectConnectGateway.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def directConnectGatewayNameValue: scala.Option[primitives.DirectConnectGatewayName] = scala.Option(impl.directConnectGatewayName()).map(value => value: primitives.DirectConnectGatewayName)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def directConnectGatewayStateValue: scala.Option[DirectConnectGatewayState] = scala.Option(impl.directConnectGatewayState()).map(value => DirectConnectGatewayState.wrap(value))
      override def stateChangeErrorValue: scala.Option[primitives.StateChangeError] = scala.Option(impl.stateChangeError()).map(value => value: primitives.StateChangeError)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGateway): ReadOnly = new Wrapper(impl)
  }
  case class DirectConnectGatewayAssociation(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, directConnectGatewayOwnerAccount: scala.Option[primitives.OwnerAccount] = None, associationState: scala.Option[DirectConnectGatewayAssociationState] = None, stateChangeError: scala.Option[primitives.StateChangeError] = None, associatedGateway: scala.Option[AssociatedGateway] = None, associationId: scala.Option[primitives.DirectConnectGatewayAssociationId] = None, allowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, virtualGatewayRegion: scala.Option[primitives.VirtualGatewayRegion] = None, virtualGatewayOwnerAccount: scala.Option[primitives.OwnerAccount] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation = {
      import DirectConnectGatewayAssociation.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(directConnectGatewayOwnerAccount.map(value => value: java.lang.String))(_.directConnectGatewayOwnerAccount).optionallyWith(associationState.map(value => value.unwrap))(_.associationState).optionallyWith(stateChangeError.map(value => value: java.lang.String))(_.stateChangeError).optionallyWith(associatedGateway.map(value => value.buildAwsValue()))(_.associatedGateway).optionallyWith(associationId.map(value => value: java.lang.String))(_.associationId).optionallyWith(allowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.allowedPrefixesToDirectConnectGateway).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(virtualGatewayRegion.map(value => value: java.lang.String))(_.virtualGatewayRegion).optionallyWith(virtualGatewayOwnerAccount.map(value => value: java.lang.String))(_.virtualGatewayOwnerAccount).build()
    }
    def asReadOnly: DirectConnectGatewayAssociation.ReadOnly = DirectConnectGatewayAssociation.wrap(buildAwsValue())
  }
  object DirectConnectGatewayAssociation {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DirectConnectGatewayAssociation = DirectConnectGatewayAssociation(directConnectGatewayIdValue.map(value => value), directConnectGatewayOwnerAccountValue.map(value => value), associationStateValue.map(value => value), stateChangeErrorValue.map(value => value), associatedGatewayValue.map(value => value.editable), associationIdValue.map(value => value), allowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }), virtualGatewayIdValue.map(value => value), virtualGatewayRegionValue.map(value => value), virtualGatewayOwnerAccountValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def directConnectGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount]
      def associationStateValue: scala.Option[DirectConnectGatewayAssociationState]
      def stateChangeErrorValue: scala.Option[primitives.StateChangeError]
      def associatedGatewayValue: scala.Option[AssociatedGateway.ReadOnly]
      def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId]
      def allowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def virtualGatewayRegionValue: scala.Option[primitives.VirtualGatewayRegion]
      def virtualGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def directConnectGatewayOwnerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayOwnerAccount", directConnectGatewayOwnerAccountValue)
      def associationState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociationState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationState", associationStateValue)
      def stateChangeError: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StateChangeError] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("stateChangeError", stateChangeErrorValue)
      def associatedGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AssociatedGateway.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedGateway", associatedGatewayValue)
      def associationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationId", associationIdValue)
      def allowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedPrefixesToDirectConnectGateway", allowedPrefixesToDirectConnectGatewayValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def virtualGatewayRegion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayRegion] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayRegion", virtualGatewayRegionValue)
      def virtualGatewayOwnerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayOwnerAccount", virtualGatewayOwnerAccountValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation) extends DirectConnectGatewayAssociation.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def directConnectGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.directConnectGatewayOwnerAccount()).map(value => value: primitives.OwnerAccount)
      override def associationStateValue: scala.Option[DirectConnectGatewayAssociationState] = scala.Option(impl.associationState()).map(value => DirectConnectGatewayAssociationState.wrap(value))
      override def stateChangeErrorValue: scala.Option[primitives.StateChangeError] = scala.Option(impl.stateChangeError()).map(value => value: primitives.StateChangeError)
      override def associatedGatewayValue: scala.Option[AssociatedGateway.ReadOnly] = scala.Option(impl.associatedGateway()).map(value => AssociatedGateway.wrap(value))
      override def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId] = scala.Option(impl.associationId()).map(value => value: primitives.DirectConnectGatewayAssociationId)
      override def allowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.allowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def virtualGatewayRegionValue: scala.Option[primitives.VirtualGatewayRegion] = scala.Option(impl.virtualGatewayRegion()).map(value => value: primitives.VirtualGatewayRegion)
      override def virtualGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.virtualGatewayOwnerAccount()).map(value => value: primitives.OwnerAccount)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation): ReadOnly = new Wrapper(impl)
  }
  type DirectConnectGatewayAssociationList = List[DirectConnectGatewayAssociation]
  case class DirectConnectGatewayAssociationProposal(proposalId: scala.Option[primitives.DirectConnectGatewayAssociationProposalId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, directConnectGatewayOwnerAccount: scala.Option[primitives.OwnerAccount] = None, proposalState: scala.Option[DirectConnectGatewayAssociationProposalState] = None, associatedGateway: scala.Option[AssociatedGateway] = None, existingAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None, requestedAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal = {
      import DirectConnectGatewayAssociationProposal.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal.builder().optionallyWith(proposalId.map(value => value: java.lang.String))(_.proposalId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(directConnectGatewayOwnerAccount.map(value => value: java.lang.String))(_.directConnectGatewayOwnerAccount).optionallyWith(proposalState.map(value => value.unwrap))(_.proposalState).optionallyWith(associatedGateway.map(value => value.buildAwsValue()))(_.associatedGateway).optionallyWith(existingAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.existingAllowedPrefixesToDirectConnectGateway).optionallyWith(requestedAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.requestedAllowedPrefixesToDirectConnectGateway).build()
    }
    def asReadOnly: DirectConnectGatewayAssociationProposal.ReadOnly = DirectConnectGatewayAssociationProposal.wrap(buildAwsValue())
  }
  object DirectConnectGatewayAssociationProposal {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DirectConnectGatewayAssociationProposal = DirectConnectGatewayAssociationProposal(proposalIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), directConnectGatewayOwnerAccountValue.map(value => value), proposalStateValue.map(value => value), associatedGatewayValue.map(value => value.editable), existingAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }), requestedAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }))
      def proposalIdValue: scala.Option[primitives.DirectConnectGatewayAssociationProposalId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def directConnectGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount]
      def proposalStateValue: scala.Option[DirectConnectGatewayAssociationProposalState]
      def associatedGatewayValue: scala.Option[AssociatedGateway.ReadOnly]
      def existingAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def requestedAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def proposalId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationProposalId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("proposalId", proposalIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def directConnectGatewayOwnerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayOwnerAccount", directConnectGatewayOwnerAccountValue)
      def proposalState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociationProposalState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("proposalState", proposalStateValue)
      def associatedGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AssociatedGateway.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedGateway", associatedGatewayValue)
      def existingAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("existingAllowedPrefixesToDirectConnectGateway", existingAllowedPrefixesToDirectConnectGatewayValue)
      def requestedAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestedAllowedPrefixesToDirectConnectGateway", requestedAllowedPrefixesToDirectConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal) extends DirectConnectGatewayAssociationProposal.ReadOnly {
      override def proposalIdValue: scala.Option[primitives.DirectConnectGatewayAssociationProposalId] = scala.Option(impl.proposalId()).map(value => value: primitives.DirectConnectGatewayAssociationProposalId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def directConnectGatewayOwnerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.directConnectGatewayOwnerAccount()).map(value => value: primitives.OwnerAccount)
      override def proposalStateValue: scala.Option[DirectConnectGatewayAssociationProposalState] = scala.Option(impl.proposalState()).map(value => DirectConnectGatewayAssociationProposalState.wrap(value))
      override def associatedGatewayValue: scala.Option[AssociatedGateway.ReadOnly] = scala.Option(impl.associatedGateway()).map(value => AssociatedGateway.wrap(value))
      override def existingAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.existingAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def requestedAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.requestedAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal): ReadOnly = new Wrapper(impl)
  }
  type DirectConnectGatewayAssociationProposalList = List[DirectConnectGatewayAssociationProposal]
  sealed trait DirectConnectGatewayAssociationProposalState { def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState }
  object DirectConnectGatewayAssociationProposalState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState): DirectConnectGatewayAssociationProposalState = value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.REQUESTED => requested
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.ACCEPTED => accepted
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.DELETED => deleted
    }
    final case object unknownToSdkVersion extends DirectConnectGatewayAssociationProposalState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.UNKNOWN_TO_SDK_VERSION }
    final case object requested extends DirectConnectGatewayAssociationProposalState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.REQUESTED }
    final case object accepted extends DirectConnectGatewayAssociationProposalState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.ACCEPTED }
    final case object deleted extends DirectConnectGatewayAssociationProposalState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposalState.DELETED }
  }
  sealed trait DirectConnectGatewayAssociationState { def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState }
  object DirectConnectGatewayAssociationState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState): DirectConnectGatewayAssociationState = value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATING => associating
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATED => associated
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATING => disassociating
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATED => disassociated
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UPDATING => updating
    }
    final case object unknownToSdkVersion extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UNKNOWN_TO_SDK_VERSION }
    final case object associating extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATING }
    final case object associated extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.ASSOCIATED }
    final case object disassociating extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATING }
    final case object disassociated extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.DISASSOCIATED }
    final case object updating extends DirectConnectGatewayAssociationState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState.UPDATING }
  }
  case class DirectConnectGatewayAttachment(directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, virtualInterfaceRegion: scala.Option[primitives.VirtualInterfaceRegion] = None, virtualInterfaceOwnerAccount: scala.Option[primitives.OwnerAccount] = None, attachmentState: scala.Option[DirectConnectGatewayAttachmentState] = None, attachmentType: scala.Option[DirectConnectGatewayAttachmentType] = None, stateChangeError: scala.Option[primitives.StateChangeError] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment = {
      import DirectConnectGatewayAttachment.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment.builder().optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(virtualInterfaceRegion.map(value => value: java.lang.String))(_.virtualInterfaceRegion).optionallyWith(virtualInterfaceOwnerAccount.map(value => value: java.lang.String))(_.virtualInterfaceOwnerAccount).optionallyWith(attachmentState.map(value => value.unwrap))(_.attachmentState).optionallyWith(attachmentType.map(value => value.unwrap))(_.attachmentType).optionallyWith(stateChangeError.map(value => value: java.lang.String))(_.stateChangeError).build()
    }
    def asReadOnly: DirectConnectGatewayAttachment.ReadOnly = DirectConnectGatewayAttachment.wrap(buildAwsValue())
  }
  object DirectConnectGatewayAttachment {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DirectConnectGatewayAttachment = DirectConnectGatewayAttachment(directConnectGatewayIdValue.map(value => value), virtualInterfaceIdValue.map(value => value), virtualInterfaceRegionValue.map(value => value), virtualInterfaceOwnerAccountValue.map(value => value), attachmentStateValue.map(value => value), attachmentTypeValue.map(value => value), stateChangeErrorValue.map(value => value))
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def virtualInterfaceRegionValue: scala.Option[primitives.VirtualInterfaceRegion]
      def virtualInterfaceOwnerAccountValue: scala.Option[primitives.OwnerAccount]
      def attachmentStateValue: scala.Option[DirectConnectGatewayAttachmentState]
      def attachmentTypeValue: scala.Option[DirectConnectGatewayAttachmentType]
      def stateChangeErrorValue: scala.Option[primitives.StateChangeError]
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def virtualInterfaceRegion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceRegion] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceRegion", virtualInterfaceRegionValue)
      def virtualInterfaceOwnerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceOwnerAccount", virtualInterfaceOwnerAccountValue)
      def attachmentState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAttachmentState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachmentState", attachmentStateValue)
      def attachmentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAttachmentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachmentType", attachmentTypeValue)
      def stateChangeError: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StateChangeError] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("stateChangeError", stateChangeErrorValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment) extends DirectConnectGatewayAttachment.ReadOnly {
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def virtualInterfaceRegionValue: scala.Option[primitives.VirtualInterfaceRegion] = scala.Option(impl.virtualInterfaceRegion()).map(value => value: primitives.VirtualInterfaceRegion)
      override def virtualInterfaceOwnerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.virtualInterfaceOwnerAccount()).map(value => value: primitives.OwnerAccount)
      override def attachmentStateValue: scala.Option[DirectConnectGatewayAttachmentState] = scala.Option(impl.attachmentState()).map(value => DirectConnectGatewayAttachmentState.wrap(value))
      override def attachmentTypeValue: scala.Option[DirectConnectGatewayAttachmentType] = scala.Option(impl.attachmentType()).map(value => DirectConnectGatewayAttachmentType.wrap(value))
      override def stateChangeErrorValue: scala.Option[primitives.StateChangeError] = scala.Option(impl.stateChangeError()).map(value => value: primitives.StateChangeError)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment): ReadOnly = new Wrapper(impl)
  }
  type DirectConnectGatewayAttachmentList = List[DirectConnectGatewayAttachment]
  sealed trait DirectConnectGatewayAttachmentState { def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState }
  object DirectConnectGatewayAttachmentState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState): DirectConnectGatewayAttachmentState = value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHING => attaching
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHED => attached
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHING => detaching
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHED => detached
    }
    final case object unknownToSdkVersion extends DirectConnectGatewayAttachmentState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION }
    final case object attaching extends DirectConnectGatewayAttachmentState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHING }
    final case object attached extends DirectConnectGatewayAttachmentState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.ATTACHED }
    final case object detaching extends DirectConnectGatewayAttachmentState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHING }
    final case object detached extends DirectConnectGatewayAttachmentState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState.DETACHED }
  }
  sealed trait DirectConnectGatewayAttachmentType { def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType }
  object DirectConnectGatewayAttachmentType {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType): DirectConnectGatewayAttachmentType = value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.TRANSIT_VIRTUAL_INTERFACE => TransitVirtualInterface
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.PRIVATE_VIRTUAL_INTERFACE => PrivateVirtualInterface
    }
    final case object unknownToSdkVersion extends DirectConnectGatewayAttachmentType { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.UNKNOWN_TO_SDK_VERSION }
    final case object TransitVirtualInterface extends DirectConnectGatewayAttachmentType { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.TRANSIT_VIRTUAL_INTERFACE }
    final case object PrivateVirtualInterface extends DirectConnectGatewayAttachmentType { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType.PRIVATE_VIRTUAL_INTERFACE }
  }
  type DirectConnectGatewayList = List[DirectConnectGateway]
  sealed trait DirectConnectGatewayState { def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState }
  object DirectConnectGatewayState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState): DirectConnectGatewayState = value match {
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETED => deleted
    }
    final case object unknownToSdkVersion extends DirectConnectGatewayState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.UNKNOWN_TO_SDK_VERSION }
    final case object pending extends DirectConnectGatewayState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.PENDING }
    final case object available extends DirectConnectGatewayState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.AVAILABLE }
    final case object deleting extends DirectConnectGatewayState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETING }
    final case object deleted extends DirectConnectGatewayState { override def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState = software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETED }
  }
  case class DisassociateConnectionFromLagRequest(connectionId: primitives.ConnectionId, lagId: primitives.LagId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest = {
      import DisassociateConnectionFromLagRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest.builder().connectionId(connectionId: java.lang.String).lagId(lagId: java.lang.String).build()
    }
    def asReadOnly: DisassociateConnectionFromLagRequest.ReadOnly = DisassociateConnectionFromLagRequest.wrap(buildAwsValue())
  }
  object DisassociateConnectionFromLagRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DisassociateConnectionFromLagRequest = DisassociateConnectionFromLagRequest(connectionIdValue, lagIdValue)
      def connectionIdValue: primitives.ConnectionId
      def lagIdValue: primitives.LagId
      def connectionId: ZIO[Any, Nothing, primitives.ConnectionId] = ZIO.succeed(connectionIdValue)
      def lagId: ZIO[Any, Nothing, primitives.LagId] = ZIO.succeed(lagIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest) extends DisassociateConnectionFromLagRequest.ReadOnly {
      override def connectionIdValue: primitives.ConnectionId = impl.connectionId(): primitives.ConnectionId
      override def lagIdValue: primitives.LagId = impl.lagId(): primitives.LagId
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest): ReadOnly = new Wrapper(impl)
  }
  case class DisassociateConnectionFromLagResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, connectionId: scala.Option[primitives.ConnectionId] = None, connectionName: scala.Option[primitives.ConnectionName] = None, connectionState: scala.Option[ConnectionState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, vlan: scala.Option[primitives.VLAN] = None, partnerName: scala.Option[primitives.PartnerName] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse = {
      import DisassociateConnectionFromLagResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(connectionName.map(value => value: java.lang.String))(_.connectionName).optionallyWith(connectionState.map(value => value.unwrap))(_.connectionState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(partnerName.map(value => value: java.lang.String))(_.partnerName).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: DisassociateConnectionFromLagResponse.ReadOnly = DisassociateConnectionFromLagResponse.wrap(buildAwsValue())
  }
  object DisassociateConnectionFromLagResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DisassociateConnectionFromLagResponse = DisassociateConnectionFromLagResponse(ownerAccountValue.map(value => value), connectionIdValue.map(value => value), connectionNameValue.map(value => value), connectionStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), vlanValue.map(value => value), partnerNameValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def connectionNameValue: scala.Option[primitives.ConnectionName]
      def connectionStateValue: scala.Option[ConnectionState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def vlanValue: scala.Option[primitives.VLAN]
      def partnerNameValue: scala.Option[primitives.PartnerName]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def connectionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionName", connectionNameValue)
      def connectionState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionState", connectionStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def partnerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PartnerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("partnerName", partnerNameValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse) extends DisassociateConnectionFromLagResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def connectionNameValue: scala.Option[primitives.ConnectionName] = scala.Option(impl.connectionName()).map(value => value: primitives.ConnectionName)
      override def connectionStateValue: scala.Option[ConnectionState] = scala.Option(impl.connectionState()).map(value => ConnectionState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def partnerNameValue: scala.Option[primitives.PartnerName] = scala.Option(impl.partnerName()).map(value => value: primitives.PartnerName)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse): ReadOnly = new Wrapper(impl)
  }
  sealed trait GatewayType { def unwrap: software.amazon.awssdk.services.directconnect.model.GatewayType }
  object GatewayType {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.GatewayType): GatewayType = value match {
      case software.amazon.awssdk.services.directconnect.model.GatewayType.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.GatewayType.VIRTUAL_PRIVATE_GATEWAY => virtualPrivateGateway
      case software.amazon.awssdk.services.directconnect.model.GatewayType.TRANSIT_GATEWAY => transitGateway
    }
    final case object unknownToSdkVersion extends GatewayType { override def unwrap: software.amazon.awssdk.services.directconnect.model.GatewayType = software.amazon.awssdk.services.directconnect.model.GatewayType.UNKNOWN_TO_SDK_VERSION }
    final case object virtualPrivateGateway extends GatewayType { override def unwrap: software.amazon.awssdk.services.directconnect.model.GatewayType = software.amazon.awssdk.services.directconnect.model.GatewayType.VIRTUAL_PRIVATE_GATEWAY }
    final case object transitGateway extends GatewayType { override def unwrap: software.amazon.awssdk.services.directconnect.model.GatewayType = software.amazon.awssdk.services.directconnect.model.GatewayType.TRANSIT_GATEWAY }
  }
  sealed trait HasLogicalRedundancy { def unwrap: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy }
  object HasLogicalRedundancy {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy): HasLogicalRedundancy = value match {
      case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN => unknown
      case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.YES => yes
      case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.NO => no
    }
    final case object unknownToSdkVersion extends HasLogicalRedundancy { override def unwrap: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy = software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN_TO_SDK_VERSION }
    final case object unknown extends HasLogicalRedundancy { override def unwrap: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy = software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN }
    final case object yes extends HasLogicalRedundancy { override def unwrap: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy = software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.YES }
    final case object no extends HasLogicalRedundancy { override def unwrap: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy = software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.NO }
  }
  case class Interconnect(interconnectId: scala.Option[primitives.InterconnectId] = None, interconnectName: scala.Option[primitives.InterconnectName] = None, interconnectState: scala.Option[InterconnectState] = None, region: scala.Option[primitives.Region] = None, location: scala.Option[primitives.LocationCode] = None, bandwidth: scala.Option[primitives.Bandwidth] = None, loaIssueTime: scala.Option[primitives.LoaIssueTime] = None, lagId: scala.Option[primitives.LagId] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.Interconnect = {
      import Interconnect.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.Interconnect.builder().optionallyWith(interconnectId.map(value => value: java.lang.String))(_.interconnectId).optionallyWith(interconnectName.map(value => value: java.lang.String))(_.interconnectName).optionallyWith(interconnectState.map(value => value.unwrap))(_.interconnectState).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(bandwidth.map(value => value: java.lang.String))(_.bandwidth).optionallyWith(loaIssueTime.map(value => value: java.time.Instant))(_.loaIssueTime).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: Interconnect.ReadOnly = Interconnect.wrap(buildAwsValue())
  }
  object Interconnect {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.Interconnect] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Interconnect = Interconnect(interconnectIdValue.map(value => value), interconnectNameValue.map(value => value), interconnectStateValue.map(value => value), regionValue.map(value => value), locationValue.map(value => value), bandwidthValue.map(value => value), loaIssueTimeValue.map(value => value), lagIdValue.map(value => value), awsDeviceValue.map(value => value), jumboFrameCapableValue.map(value => value), awsDeviceV2Value.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def interconnectIdValue: scala.Option[primitives.InterconnectId]
      def interconnectNameValue: scala.Option[primitives.InterconnectName]
      def interconnectStateValue: scala.Option[InterconnectState]
      def regionValue: scala.Option[primitives.Region]
      def locationValue: scala.Option[primitives.LocationCode]
      def bandwidthValue: scala.Option[primitives.Bandwidth]
      def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime]
      def lagIdValue: scala.Option[primitives.LagId]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def interconnectId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InterconnectId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectId", interconnectIdValue)
      def interconnectName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InterconnectName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectName", interconnectNameValue)
      def interconnectState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InterconnectState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("interconnectState", interconnectStateValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def bandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bandwidth", bandwidthValue)
      def loaIssueTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LoaIssueTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loaIssueTime", loaIssueTimeValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.Interconnect) extends Interconnect.ReadOnly {
      override def interconnectIdValue: scala.Option[primitives.InterconnectId] = scala.Option(impl.interconnectId()).map(value => value: primitives.InterconnectId)
      override def interconnectNameValue: scala.Option[primitives.InterconnectName] = scala.Option(impl.interconnectName()).map(value => value: primitives.InterconnectName)
      override def interconnectStateValue: scala.Option[InterconnectState] = scala.Option(impl.interconnectState()).map(value => InterconnectState.wrap(value))
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def bandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.bandwidth()).map(value => value: primitives.Bandwidth)
      override def loaIssueTimeValue: scala.Option[primitives.LoaIssueTime] = scala.Option(impl.loaIssueTime()).map(value => value: primitives.LoaIssueTime)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.Interconnect): ReadOnly = new Wrapper(impl)
  }
  type InterconnectList = List[Interconnect]
  sealed trait InterconnectState { def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState }
  object InterconnectState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.InterconnectState): InterconnectState = value match {
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.REQUESTED => requested
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.DOWN => down
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETED => deleted
      case software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN => unknown
    }
    final case object unknownToSdkVersion extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN_TO_SDK_VERSION }
    final case object requested extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.REQUESTED }
    final case object pending extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.PENDING }
    final case object available extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.AVAILABLE }
    final case object down extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.DOWN }
    final case object deleting extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETING }
    final case object deleted extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETED }
    final case object unknown extends InterconnectState { override def unwrap: software.amazon.awssdk.services.directconnect.model.InterconnectState = software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN }
  }
  case class Lag(connectionsBandwidth: scala.Option[primitives.Bandwidth] = None, numberOfConnections: scala.Option[primitives.Count] = None, lagId: scala.Option[primitives.LagId] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, lagName: scala.Option[primitives.LagName] = None, lagState: scala.Option[LagState] = None, location: scala.Option[primitives.LocationCode] = None, region: scala.Option[primitives.Region] = None, minimumLinks: scala.Option[primitives.Count] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, connections: scala.Option[Iterable[Connection]] = None, allowsHostedConnections: scala.Option[primitives.BooleanFlag] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.Lag = {
      import Lag.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.Lag.builder().optionallyWith(connectionsBandwidth.map(value => value: java.lang.String))(_.connectionsBandwidth).optionallyWith(numberOfConnections.map(value => value: java.lang.Integer))(_.numberOfConnections).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(lagName.map(value => value: java.lang.String))(_.lagName).optionallyWith(lagState.map(value => value.unwrap))(_.lagState).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(minimumLinks.map(value => value: java.lang.Integer))(_.minimumLinks).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).optionallyWith(allowsHostedConnections.map(value => value: java.lang.Boolean))(_.allowsHostedConnections).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: Lag.ReadOnly = Lag.wrap(buildAwsValue())
  }
  object Lag {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.Lag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Lag = Lag(connectionsBandwidthValue.map(value => value), numberOfConnectionsValue.map(value => value), lagIdValue.map(value => value), ownerAccountValue.map(value => value), lagNameValue.map(value => value), lagStateValue.map(value => value), locationValue.map(value => value), regionValue.map(value => value), minimumLinksValue.map(value => value), awsDeviceValue.map(value => value), awsDeviceV2Value.map(value => value), connectionsValue.map(value => value.map { item => 
        item.editable
      }), allowsHostedConnectionsValue.map(value => value), jumboFrameCapableValue.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def connectionsBandwidthValue: scala.Option[primitives.Bandwidth]
      def numberOfConnectionsValue: scala.Option[primitives.Count]
      def lagIdValue: scala.Option[primitives.LagId]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def lagNameValue: scala.Option[primitives.LagName]
      def lagStateValue: scala.Option[LagState]
      def locationValue: scala.Option[primitives.LocationCode]
      def regionValue: scala.Option[primitives.Region]
      def minimumLinksValue: scala.Option[primitives.Count]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def connectionsBandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidthValue)
      def numberOfConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfConnections", numberOfConnectionsValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def lagName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagName", lagNameValue)
      def lagState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LagState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagState", lagStateValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def minimumLinks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumLinks", minimumLinksValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
      def allowsHostedConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanFlag] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowsHostedConnections", allowsHostedConnectionsValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.Lag) extends Lag.ReadOnly {
      override def connectionsBandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.connectionsBandwidth()).map(value => value: primitives.Bandwidth)
      override def numberOfConnectionsValue: scala.Option[primitives.Count] = scala.Option(impl.numberOfConnections()).map(value => value: primitives.Count)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def lagNameValue: scala.Option[primitives.LagName] = scala.Option(impl.lagName()).map(value => value: primitives.LagName)
      override def lagStateValue: scala.Option[LagState] = scala.Option(impl.lagState()).map(value => LagState.wrap(value))
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def minimumLinksValue: scala.Option[primitives.Count] = scala.Option(impl.minimumLinks()).map(value => value: primitives.Count)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
      override def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag] = scala.Option(impl.allowsHostedConnections()).map(value => value: primitives.BooleanFlag)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.Lag): ReadOnly = new Wrapper(impl)
  }
  type LagList = List[Lag]
  sealed trait LagState { def unwrap: software.amazon.awssdk.services.directconnect.model.LagState }
  object LagState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.LagState): LagState = value match {
      case software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.LagState.REQUESTED => requested
      case software.amazon.awssdk.services.directconnect.model.LagState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.LagState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.LagState.DOWN => down
      case software.amazon.awssdk.services.directconnect.model.LagState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.LagState.DELETED => deleted
      case software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN => unknown
    }
    final case object unknownToSdkVersion extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN_TO_SDK_VERSION }
    final case object requested extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.REQUESTED }
    final case object pending extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.PENDING }
    final case object available extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.AVAILABLE }
    final case object down extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.DOWN }
    final case object deleting extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.DELETING }
    final case object deleted extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.DELETED }
    final case object unknown extends LagState { override def unwrap: software.amazon.awssdk.services.directconnect.model.LagState = software.amazon.awssdk.services.directconnect.model.LagState.UNKNOWN }
  }
  case class ListVirtualInterfaceTestHistoryRequest(testId: scala.Option[primitives.TestId] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, bgpPeers: scala.Option[Iterable[primitives.BGPPeerId]] = None, status: scala.Option[primitives.FailureTestHistoryStatus] = None, maxResults: scala.Option[primitives.MaxResultSetSize] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest = {
      import ListVirtualInterfaceTestHistoryRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest.builder().optionallyWith(testId.map(value => value: java.lang.String))(_.testId).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(bgpPeers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.bgpPeers).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: ListVirtualInterfaceTestHistoryRequest.ReadOnly = ListVirtualInterfaceTestHistoryRequest.wrap(buildAwsValue())
  }
  object ListVirtualInterfaceTestHistoryRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ListVirtualInterfaceTestHistoryRequest = ListVirtualInterfaceTestHistoryRequest(testIdValue.map(value => value), virtualInterfaceIdValue.map(value => value), bgpPeersValue.map(value => value), statusValue.map(value => value), maxResultsValue.map(value => value), nextTokenValue.map(value => value))
      def testIdValue: scala.Option[primitives.TestId]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]]
      def statusValue: scala.Option[primitives.FailureTestHistoryStatus]
      def maxResultsValue: scala.Option[primitives.MaxResultSetSize]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def testId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TestId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("testId", testIdValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.BGPPeerId]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.FailureTestHistoryStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultSetSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest) extends ListVirtualInterfaceTestHistoryRequest.ReadOnly {
      override def testIdValue: scala.Option[primitives.TestId] = scala.Option(impl.testId()).map(value => value: primitives.TestId)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        item: primitives.BGPPeerId
      }.toList)
      override def statusValue: scala.Option[primitives.FailureTestHistoryStatus] = scala.Option(impl.status()).map(value => value: primitives.FailureTestHistoryStatus)
      override def maxResultsValue: scala.Option[primitives.MaxResultSetSize] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultSetSize)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest): ReadOnly = new Wrapper(impl)
  }
  case class ListVirtualInterfaceTestHistoryResponse(virtualInterfaceTestHistory: scala.Option[Iterable[VirtualInterfaceTestHistory]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse = {
      import ListVirtualInterfaceTestHistoryResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse.builder().optionallyWith(virtualInterfaceTestHistory.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.virtualInterfaceTestHistory).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
    }
    def asReadOnly: ListVirtualInterfaceTestHistoryResponse.ReadOnly = ListVirtualInterfaceTestHistoryResponse.wrap(buildAwsValue())
  }
  object ListVirtualInterfaceTestHistoryResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ListVirtualInterfaceTestHistoryResponse = ListVirtualInterfaceTestHistoryResponse(virtualInterfaceTestHistoryValue.map(value => value.map { item => 
        item.editable
      }), nextTokenValue.map(value => value))
      def virtualInterfaceTestHistoryValue: scala.Option[List[VirtualInterfaceTestHistory.ReadOnly]]
      def nextTokenValue: scala.Option[primitives.PaginationToken]
      def virtualInterfaceTestHistory: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VirtualInterfaceTestHistory.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceTestHistory", virtualInterfaceTestHistoryValue)
      def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse) extends ListVirtualInterfaceTestHistoryResponse.ReadOnly {
      override def virtualInterfaceTestHistoryValue: scala.Option[List[VirtualInterfaceTestHistory.ReadOnly]] = scala.Option(impl.virtualInterfaceTestHistory()).map(value => value.asScala.map { item => 
        VirtualInterfaceTestHistory.wrap(item)
      }.toList)
      override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse): ReadOnly = new Wrapper(impl)
  }
  sealed trait LoaContentType { def unwrap: software.amazon.awssdk.services.directconnect.model.LoaContentType }
  object LoaContentType {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.LoaContentType): LoaContentType = value match {
      case software.amazon.awssdk.services.directconnect.model.LoaContentType.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.LoaContentType.APPLICATION_PDF => `application/pdf`
    }
    final case object unknownToSdkVersion extends LoaContentType { override def unwrap: software.amazon.awssdk.services.directconnect.model.LoaContentType = software.amazon.awssdk.services.directconnect.model.LoaContentType.UNKNOWN_TO_SDK_VERSION }
    final case object `application/pdf` extends LoaContentType { override def unwrap: software.amazon.awssdk.services.directconnect.model.LoaContentType = software.amazon.awssdk.services.directconnect.model.LoaContentType.APPLICATION_PDF }
  }
  case class Location(locationCode: scala.Option[primitives.LocationCode] = None, locationName: scala.Option[primitives.LocationName] = None, region: scala.Option[primitives.Region] = None, availablePortSpeeds: scala.Option[Iterable[primitives.PortSpeed]] = None, availableProviders: scala.Option[Iterable[primitives.ProviderName]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.Location = {
      import Location.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.Location.builder().optionallyWith(locationCode.map(value => value: java.lang.String))(_.locationCode).optionallyWith(locationName.map(value => value: java.lang.String))(_.locationName).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(availablePortSpeeds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.availablePortSpeeds).optionallyWith(availableProviders.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.availableProviders).build()
    }
    def asReadOnly: Location.ReadOnly = Location.wrap(buildAwsValue())
  }
  object Location {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.Location] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Location = Location(locationCodeValue.map(value => value), locationNameValue.map(value => value), regionValue.map(value => value), availablePortSpeedsValue.map(value => value), availableProvidersValue.map(value => value))
      def locationCodeValue: scala.Option[primitives.LocationCode]
      def locationNameValue: scala.Option[primitives.LocationName]
      def regionValue: scala.Option[primitives.Region]
      def availablePortSpeedsValue: scala.Option[List[primitives.PortSpeed]]
      def availableProvidersValue: scala.Option[List[primitives.ProviderName]]
      def locationCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("locationCode", locationCodeValue)
      def locationName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("locationName", locationNameValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def availablePortSpeeds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.PortSpeed]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availablePortSpeeds", availablePortSpeedsValue)
      def availableProviders: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.ProviderName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availableProviders", availableProvidersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.Location) extends Location.ReadOnly {
      override def locationCodeValue: scala.Option[primitives.LocationCode] = scala.Option(impl.locationCode()).map(value => value: primitives.LocationCode)
      override def locationNameValue: scala.Option[primitives.LocationName] = scala.Option(impl.locationName()).map(value => value: primitives.LocationName)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def availablePortSpeedsValue: scala.Option[List[primitives.PortSpeed]] = scala.Option(impl.availablePortSpeeds()).map(value => value.asScala.map { item => 
        item: primitives.PortSpeed
      }.toList)
      override def availableProvidersValue: scala.Option[List[primitives.ProviderName]] = scala.Option(impl.availableProviders()).map(value => value.asScala.map { item => 
        item: primitives.ProviderName
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.Location): ReadOnly = new Wrapper(impl)
  }
  type LocationList = List[Location]
  case class NewBGPPeer(asn: scala.Option[primitives.ASN] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, addressFamily: scala.Option[AddressFamily] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewBGPPeer = {
      import NewBGPPeer.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewBGPPeer.builder().optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).build()
    }
    def asReadOnly: NewBGPPeer.ReadOnly = NewBGPPeer.wrap(buildAwsValue())
  }
  object NewBGPPeer {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewBGPPeer] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewBGPPeer = NewBGPPeer(asnValue.map(value => value), authKeyValue.map(value => value), addressFamilyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value))
      def asnValue: scala.Option[primitives.ASN]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def addressFamilyValue: scala.Option[AddressFamily]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewBGPPeer) extends NewBGPPeer.ReadOnly {
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewBGPPeer): ReadOnly = new Wrapper(impl)
  }
  case class NewPrivateVirtualInterface(virtualInterfaceName: primitives.VirtualInterfaceName, vlan: primitives.VLAN, asn: primitives.ASN, mtu: scala.Option[primitives.MTU] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface = {
      import NewPrivateVirtualInterface.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface.builder().virtualInterfaceName(virtualInterfaceName: java.lang.String).vlan(vlan: java.lang.Integer).asn(asn: java.lang.Integer).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewPrivateVirtualInterface.ReadOnly = NewPrivateVirtualInterface.wrap(buildAwsValue())
  }
  object NewPrivateVirtualInterface {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewPrivateVirtualInterface = NewPrivateVirtualInterface(virtualInterfaceNameValue, vlanValue, asnValue, mtuValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: primitives.VirtualInterfaceName
      def vlanValue: primitives.VLAN
      def asnValue: primitives.ASN
      def mtuValue: scala.Option[primitives.MTU]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, Nothing, primitives.VirtualInterfaceName] = ZIO.succeed(virtualInterfaceNameValue)
      def vlan: ZIO[Any, Nothing, primitives.VLAN] = ZIO.succeed(vlanValue)
      def asn: ZIO[Any, Nothing, primitives.ASN] = ZIO.succeed(asnValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface) extends NewPrivateVirtualInterface.ReadOnly {
      override def virtualInterfaceNameValue: primitives.VirtualInterfaceName = impl.virtualInterfaceName(): primitives.VirtualInterfaceName
      override def vlanValue: primitives.VLAN = impl.vlan(): primitives.VLAN
      override def asnValue: primitives.ASN = impl.asn(): primitives.ASN
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface): ReadOnly = new Wrapper(impl)
  }
  case class NewPrivateVirtualInterfaceAllocation(virtualInterfaceName: primitives.VirtualInterfaceName, vlan: primitives.VLAN, asn: primitives.ASN, mtu: scala.Option[primitives.MTU] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, addressFamily: scala.Option[AddressFamily] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation = {
      import NewPrivateVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation.builder().virtualInterfaceName(virtualInterfaceName: java.lang.String).vlan(vlan: java.lang.Integer).asn(asn: java.lang.Integer).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewPrivateVirtualInterfaceAllocation.ReadOnly = NewPrivateVirtualInterfaceAllocation.wrap(buildAwsValue())
  }
  object NewPrivateVirtualInterfaceAllocation {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewPrivateVirtualInterfaceAllocation = NewPrivateVirtualInterfaceAllocation(virtualInterfaceNameValue, vlanValue, asnValue, mtuValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), addressFamilyValue.map(value => value), customerAddressValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: primitives.VirtualInterfaceName
      def vlanValue: primitives.VLAN
      def asnValue: primitives.ASN
      def mtuValue: scala.Option[primitives.MTU]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, Nothing, primitives.VirtualInterfaceName] = ZIO.succeed(virtualInterfaceNameValue)
      def vlan: ZIO[Any, Nothing, primitives.VLAN] = ZIO.succeed(vlanValue)
      def asn: ZIO[Any, Nothing, primitives.ASN] = ZIO.succeed(asnValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation) extends NewPrivateVirtualInterfaceAllocation.ReadOnly {
      override def virtualInterfaceNameValue: primitives.VirtualInterfaceName = impl.virtualInterfaceName(): primitives.VirtualInterfaceName
      override def vlanValue: primitives.VLAN = impl.vlan(): primitives.VLAN
      override def asnValue: primitives.ASN = impl.asn(): primitives.ASN
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation): ReadOnly = new Wrapper(impl)
  }
  case class NewPublicVirtualInterface(virtualInterfaceName: primitives.VirtualInterfaceName, vlan: primitives.VLAN, asn: primitives.ASN, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface = {
      import NewPublicVirtualInterface.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface.builder().virtualInterfaceName(virtualInterfaceName: java.lang.String).vlan(vlan: java.lang.Integer).asn(asn: java.lang.Integer).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewPublicVirtualInterface.ReadOnly = NewPublicVirtualInterface.wrap(buildAwsValue())
  }
  object NewPublicVirtualInterface {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewPublicVirtualInterface = NewPublicVirtualInterface(virtualInterfaceNameValue, vlanValue, asnValue, authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: primitives.VirtualInterfaceName
      def vlanValue: primitives.VLAN
      def asnValue: primitives.ASN
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, Nothing, primitives.VirtualInterfaceName] = ZIO.succeed(virtualInterfaceNameValue)
      def vlan: ZIO[Any, Nothing, primitives.VLAN] = ZIO.succeed(vlanValue)
      def asn: ZIO[Any, Nothing, primitives.ASN] = ZIO.succeed(asnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface) extends NewPublicVirtualInterface.ReadOnly {
      override def virtualInterfaceNameValue: primitives.VirtualInterfaceName = impl.virtualInterfaceName(): primitives.VirtualInterfaceName
      override def vlanValue: primitives.VLAN = impl.vlan(): primitives.VLAN
      override def asnValue: primitives.ASN = impl.asn(): primitives.ASN
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface): ReadOnly = new Wrapper(impl)
  }
  case class NewPublicVirtualInterfaceAllocation(virtualInterfaceName: primitives.VirtualInterfaceName, vlan: primitives.VLAN, asn: primitives.ASN, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation = {
      import NewPublicVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation.builder().virtualInterfaceName(virtualInterfaceName: java.lang.String).vlan(vlan: java.lang.Integer).asn(asn: java.lang.Integer).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewPublicVirtualInterfaceAllocation.ReadOnly = NewPublicVirtualInterfaceAllocation.wrap(buildAwsValue())
  }
  object NewPublicVirtualInterfaceAllocation {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewPublicVirtualInterfaceAllocation = NewPublicVirtualInterfaceAllocation(virtualInterfaceNameValue, vlanValue, asnValue, authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: primitives.VirtualInterfaceName
      def vlanValue: primitives.VLAN
      def asnValue: primitives.ASN
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, Nothing, primitives.VirtualInterfaceName] = ZIO.succeed(virtualInterfaceNameValue)
      def vlan: ZIO[Any, Nothing, primitives.VLAN] = ZIO.succeed(vlanValue)
      def asn: ZIO[Any, Nothing, primitives.ASN] = ZIO.succeed(asnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation) extends NewPublicVirtualInterfaceAllocation.ReadOnly {
      override def virtualInterfaceNameValue: primitives.VirtualInterfaceName = impl.virtualInterfaceName(): primitives.VirtualInterfaceName
      override def vlanValue: primitives.VLAN = impl.vlan(): primitives.VLAN
      override def asnValue: primitives.ASN = impl.asn(): primitives.ASN
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation): ReadOnly = new Wrapper(impl)
  }
  case class NewTransitVirtualInterface(virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, mtu: scala.Option[primitives.MTU] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface = {
      import NewTransitVirtualInterface.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface.builder().optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewTransitVirtualInterface.ReadOnly = NewTransitVirtualInterface.wrap(buildAwsValue())
  }
  object NewTransitVirtualInterface {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewTransitVirtualInterface = NewTransitVirtualInterface(virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), mtuValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), directConnectGatewayIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def mtuValue: scala.Option[primitives.MTU]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface) extends NewTransitVirtualInterface.ReadOnly {
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface): ReadOnly = new Wrapper(impl)
  }
  case class NewTransitVirtualInterfaceAllocation(virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, mtu: scala.Option[primitives.MTU] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation = {
      import NewTransitVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation.builder().optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: NewTransitVirtualInterfaceAllocation.ReadOnly = NewTransitVirtualInterfaceAllocation.wrap(buildAwsValue())
  }
  object NewTransitVirtualInterfaceAllocation {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: NewTransitVirtualInterfaceAllocation = NewTransitVirtualInterfaceAllocation(virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), mtuValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def mtuValue: scala.Option[primitives.MTU]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation) extends NewTransitVirtualInterfaceAllocation.ReadOnly {
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation): ReadOnly = new Wrapper(impl)
  }
  type ProviderList = List[primitives.ProviderName]
  type ResourceArnList = List[primitives.ResourceArn]
  case class ResourceTag(resourceArn: scala.Option[primitives.ResourceArn] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.ResourceTag = {
      import ResourceTag.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.ResourceTag.builder().optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: ResourceTag.ReadOnly = ResourceTag.wrap(buildAwsValue())
  }
  object ResourceTag {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.ResourceTag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ResourceTag = ResourceTag(resourceArnValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def resourceArnValue: scala.Option[primitives.ResourceArn]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.ResourceTag) extends ResourceTag.ReadOnly {
      override def resourceArnValue: scala.Option[primitives.ResourceArn] = scala.Option(impl.resourceArn()).map(value => value: primitives.ResourceArn)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.ResourceTag): ReadOnly = new Wrapper(impl)
  }
  type ResourceTagList = List[ResourceTag]
  case class RouteFilterPrefix(cidr: scala.Option[primitives.CIDR] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix = {
      import RouteFilterPrefix.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.builder().optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr).build()
    }
    def asReadOnly: RouteFilterPrefix.ReadOnly = RouteFilterPrefix.wrap(buildAwsValue())
  }
  object RouteFilterPrefix {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: RouteFilterPrefix = RouteFilterPrefix(cidrValue.map(value => value))
      def cidrValue: scala.Option[primitives.CIDR]
      def cidr: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CIDR] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidr", cidrValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix) extends RouteFilterPrefix.ReadOnly { override def cidrValue: scala.Option[primitives.CIDR] = scala.Option(impl.cidr()).map(value => value: primitives.CIDR) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix): ReadOnly = new Wrapper(impl)
  }
  type RouteFilterPrefixList = List[RouteFilterPrefix]
  case class StartBgpFailoverTestRequest(virtualInterfaceId: primitives.VirtualInterfaceId, bgpPeers: scala.Option[Iterable[primitives.BGPPeerId]] = None, testDurationInMinutes: scala.Option[primitives.TestDuration] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest = {
      import StartBgpFailoverTestRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).optionallyWith(bgpPeers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.bgpPeers).optionallyWith(testDurationInMinutes.map(value => value: java.lang.Integer))(_.testDurationInMinutes).build()
    }
    def asReadOnly: StartBgpFailoverTestRequest.ReadOnly = StartBgpFailoverTestRequest.wrap(buildAwsValue())
  }
  object StartBgpFailoverTestRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: StartBgpFailoverTestRequest = StartBgpFailoverTestRequest(virtualInterfaceIdValue, bgpPeersValue.map(value => value), testDurationInMinutesValue.map(value => value))
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]]
      def testDurationInMinutesValue: scala.Option[primitives.TestDuration]
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.BGPPeerId]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def testDurationInMinutes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TestDuration] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("testDurationInMinutes", testDurationInMinutesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest) extends StartBgpFailoverTestRequest.ReadOnly {
      override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId
      override def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        item: primitives.BGPPeerId
      }.toList)
      override def testDurationInMinutesValue: scala.Option[primitives.TestDuration] = scala.Option(impl.testDurationInMinutes()).map(value => value: primitives.TestDuration)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest): ReadOnly = new Wrapper(impl)
  }
  case class StartBgpFailoverTestResponse(virtualInterfaceTest: scala.Option[VirtualInterfaceTestHistory] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse = {
      import StartBgpFailoverTestResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse.builder().optionallyWith(virtualInterfaceTest.map(value => value.buildAwsValue()))(_.virtualInterfaceTest).build()
    }
    def asReadOnly: StartBgpFailoverTestResponse.ReadOnly = StartBgpFailoverTestResponse.wrap(buildAwsValue())
  }
  object StartBgpFailoverTestResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: StartBgpFailoverTestResponse = StartBgpFailoverTestResponse(virtualInterfaceTestValue.map(value => value.editable))
      def virtualInterfaceTestValue: scala.Option[VirtualInterfaceTestHistory.ReadOnly]
      def virtualInterfaceTest: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceTestHistory.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceTest", virtualInterfaceTestValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse) extends StartBgpFailoverTestResponse.ReadOnly { override def virtualInterfaceTestValue: scala.Option[VirtualInterfaceTestHistory.ReadOnly] = scala.Option(impl.virtualInterfaceTest()).map(value => VirtualInterfaceTestHistory.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse): ReadOnly = new Wrapper(impl)
  }
  case class StopBgpFailoverTestRequest(virtualInterfaceId: primitives.VirtualInterfaceId) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest = {
      import StopBgpFailoverTestRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).build()
    }
    def asReadOnly: StopBgpFailoverTestRequest.ReadOnly = StopBgpFailoverTestRequest.wrap(buildAwsValue())
  }
  object StopBgpFailoverTestRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: StopBgpFailoverTestRequest = StopBgpFailoverTestRequest(virtualInterfaceIdValue)
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest) extends StopBgpFailoverTestRequest.ReadOnly { override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest): ReadOnly = new Wrapper(impl)
  }
  case class StopBgpFailoverTestResponse(virtualInterfaceTest: scala.Option[VirtualInterfaceTestHistory] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse = {
      import StopBgpFailoverTestResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse.builder().optionallyWith(virtualInterfaceTest.map(value => value.buildAwsValue()))(_.virtualInterfaceTest).build()
    }
    def asReadOnly: StopBgpFailoverTestResponse.ReadOnly = StopBgpFailoverTestResponse.wrap(buildAwsValue())
  }
  object StopBgpFailoverTestResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: StopBgpFailoverTestResponse = StopBgpFailoverTestResponse(virtualInterfaceTestValue.map(value => value.editable))
      def virtualInterfaceTestValue: scala.Option[VirtualInterfaceTestHistory.ReadOnly]
      def virtualInterfaceTest: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceTestHistory.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceTest", virtualInterfaceTestValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse) extends StopBgpFailoverTestResponse.ReadOnly { override def virtualInterfaceTestValue: scala.Option[VirtualInterfaceTestHistory.ReadOnly] = scala.Option(impl.virtualInterfaceTest()).map(value => VirtualInterfaceTestHistory.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse): ReadOnly = new Wrapper(impl)
  }
  case class Tag(key: primitives.TagKey, value: scala.Option[primitives.TagValue] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.Tag = {
      import Tag.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.Tag.builder().key(key: java.lang.String).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
    }
    def asReadOnly: Tag.ReadOnly = Tag.wrap(buildAwsValue())
  }
  object Tag {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.Tag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Tag = Tag(keyValue, valueValue.map(value => value))
      def keyValue: primitives.TagKey
      def valueValue: scala.Option[primitives.TagValue]
      def key: ZIO[Any, Nothing, primitives.TagKey] = ZIO.succeed(keyValue)
      def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TagValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.Tag) extends Tag.ReadOnly {
      override def keyValue: primitives.TagKey = impl.key(): primitives.TagKey
      override def valueValue: scala.Option[primitives.TagValue] = scala.Option(impl.value()).map(value => value: primitives.TagValue)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.Tag): ReadOnly = new Wrapper(impl)
  }
  type TagKeyList = List[primitives.TagKey]
  type TagList = List[Tag]
  case class TagResourceRequest(resourceArn: primitives.ResourceArn, tags: Iterable[Tag]) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.TagResourceRequest = {
      import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.TagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tags(tags.map { item => 
        item.buildAwsValue()
      }.asJavaCollection).build()
    }
    def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
  }
  object TagResourceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: TagResourceRequest = TagResourceRequest(resourceArnValue, tagsValue.map { item => 
        item.editable
      })
      def resourceArnValue: primitives.ResourceArn
      def tagsValue: List[Tag.ReadOnly]
      def resourceArn: ZIO[Any, Nothing, primitives.ResourceArn] = ZIO.succeed(resourceArnValue)
      def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
      override def resourceArnValue: primitives.ResourceArn = impl.resourceArn(): primitives.ResourceArn
      override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
        Tag.wrap(item)
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
  }
  case class TagResourceResponse() {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.TagResourceResponse = {
      import TagResourceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.TagResourceResponse.builder().build()
    }
    def asReadOnly: TagResourceResponse.ReadOnly = TagResourceResponse.wrap(buildAwsValue())
  }
  object TagResourceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.TagResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly { def editable: TagResourceResponse = TagResourceResponse() }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.TagResourceResponse) extends TagResourceResponse.ReadOnly
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.TagResourceResponse): ReadOnly = new Wrapper(impl)
  }
  case class UntagResourceRequest(resourceArn: primitives.ResourceArn, tagKeys: Iterable[primitives.TagKey]) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UntagResourceRequest = {
      import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UntagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tagKeys(tagKeys.map { item => 
        item: java.lang.String
      }.asJavaCollection).build()
    }
    def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
  }
  object UntagResourceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UntagResourceRequest = UntagResourceRequest(resourceArnValue, tagKeysValue)
      def resourceArnValue: primitives.ResourceArn
      def tagKeysValue: List[primitives.TagKey]
      def resourceArn: ZIO[Any, Nothing, primitives.ResourceArn] = ZIO.succeed(resourceArnValue)
      def tagKeys: ZIO[Any, Nothing, List[primitives.TagKey]] = ZIO.succeed(tagKeysValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
      override def resourceArnValue: primitives.ResourceArn = impl.resourceArn(): primitives.ResourceArn
      override def tagKeysValue: List[primitives.TagKey] = impl.tagKeys().asScala.map { item => 
        item: primitives.TagKey
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
  }
  case class UntagResourceResponse() {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UntagResourceResponse = {
      import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UntagResourceResponse.builder().build()
    }
    def asReadOnly: UntagResourceResponse.ReadOnly = UntagResourceResponse.wrap(buildAwsValue())
  }
  object UntagResourceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UntagResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly { def editable: UntagResourceResponse = UntagResourceResponse() }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UntagResourceResponse) extends UntagResourceResponse.ReadOnly
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UntagResourceResponse): ReadOnly = new Wrapper(impl)
  }
  case class UpdateDirectConnectGatewayAssociationRequest(associationId: scala.Option[primitives.DirectConnectGatewayAssociationId] = None, addAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None, removeAllowedPrefixesToDirectConnectGateway: scala.Option[Iterable[RouteFilterPrefix]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest = {
      import UpdateDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest.builder().optionallyWith(associationId.map(value => value: java.lang.String))(_.associationId).optionallyWith(addAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.addAllowedPrefixesToDirectConnectGateway).optionallyWith(removeAllowedPrefixesToDirectConnectGateway.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.removeAllowedPrefixesToDirectConnectGateway).build()
    }
    def asReadOnly: UpdateDirectConnectGatewayAssociationRequest.ReadOnly = UpdateDirectConnectGatewayAssociationRequest.wrap(buildAwsValue())
  }
  object UpdateDirectConnectGatewayAssociationRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateDirectConnectGatewayAssociationRequest = UpdateDirectConnectGatewayAssociationRequest(associationIdValue.map(value => value), addAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }), removeAllowedPrefixesToDirectConnectGatewayValue.map(value => value.map { item => 
        item.editable
      }))
      def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId]
      def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def removeAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def associationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayAssociationId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationId", associationIdValue)
      def addAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addAllowedPrefixesToDirectConnectGateway", addAllowedPrefixesToDirectConnectGatewayValue)
      def removeAllowedPrefixesToDirectConnectGateway: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("removeAllowedPrefixesToDirectConnectGateway", removeAllowedPrefixesToDirectConnectGatewayValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest) extends UpdateDirectConnectGatewayAssociationRequest.ReadOnly {
      override def associationIdValue: scala.Option[primitives.DirectConnectGatewayAssociationId] = scala.Option(impl.associationId()).map(value => value: primitives.DirectConnectGatewayAssociationId)
      override def addAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.addAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def removeAllowedPrefixesToDirectConnectGatewayValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.removeAllowedPrefixesToDirectConnectGateway()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest): ReadOnly = new Wrapper(impl)
  }
  case class UpdateDirectConnectGatewayAssociationResponse(directConnectGatewayAssociation: scala.Option[DirectConnectGatewayAssociation] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse = {
      import UpdateDirectConnectGatewayAssociationResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.builder().optionallyWith(directConnectGatewayAssociation.map(value => value.buildAwsValue()))(_.directConnectGatewayAssociation).build()
    }
    def asReadOnly: UpdateDirectConnectGatewayAssociationResponse.ReadOnly = UpdateDirectConnectGatewayAssociationResponse.wrap(buildAwsValue())
  }
  object UpdateDirectConnectGatewayAssociationResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateDirectConnectGatewayAssociationResponse = UpdateDirectConnectGatewayAssociationResponse(directConnectGatewayAssociationValue.map(value => value.editable))
      def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly]
      def directConnectGatewayAssociation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DirectConnectGatewayAssociation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayAssociation", directConnectGatewayAssociationValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse) extends UpdateDirectConnectGatewayAssociationResponse.ReadOnly { override def directConnectGatewayAssociationValue: scala.Option[DirectConnectGatewayAssociation.ReadOnly] = scala.Option(impl.directConnectGatewayAssociation()).map(value => DirectConnectGatewayAssociation.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse): ReadOnly = new Wrapper(impl)
  }
  case class UpdateLagRequest(lagId: primitives.LagId, lagName: scala.Option[primitives.LagName] = None, minimumLinks: scala.Option[primitives.Count] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateLagRequest = {
      import UpdateLagRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateLagRequest.builder().lagId(lagId: java.lang.String).optionallyWith(lagName.map(value => value: java.lang.String))(_.lagName).optionallyWith(minimumLinks.map(value => value: java.lang.Integer))(_.minimumLinks).build()
    }
    def asReadOnly: UpdateLagRequest.ReadOnly = UpdateLagRequest.wrap(buildAwsValue())
  }
  object UpdateLagRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateLagRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateLagRequest = UpdateLagRequest(lagIdValue, lagNameValue.map(value => value), minimumLinksValue.map(value => value))
      def lagIdValue: primitives.LagId
      def lagNameValue: scala.Option[primitives.LagName]
      def minimumLinksValue: scala.Option[primitives.Count]
      def lagId: ZIO[Any, Nothing, primitives.LagId] = ZIO.succeed(lagIdValue)
      def lagName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagName", lagNameValue)
      def minimumLinks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumLinks", minimumLinksValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateLagRequest) extends UpdateLagRequest.ReadOnly {
      override def lagIdValue: primitives.LagId = impl.lagId(): primitives.LagId
      override def lagNameValue: scala.Option[primitives.LagName] = scala.Option(impl.lagName()).map(value => value: primitives.LagName)
      override def minimumLinksValue: scala.Option[primitives.Count] = scala.Option(impl.minimumLinks()).map(value => value: primitives.Count)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateLagRequest): ReadOnly = new Wrapper(impl)
  }
  case class UpdateLagResponse(connectionsBandwidth: scala.Option[primitives.Bandwidth] = None, numberOfConnections: scala.Option[primitives.Count] = None, lagId: scala.Option[primitives.LagId] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, lagName: scala.Option[primitives.LagName] = None, lagState: scala.Option[LagState] = None, location: scala.Option[primitives.LocationCode] = None, region: scala.Option[primitives.Region] = None, minimumLinks: scala.Option[primitives.Count] = None, awsDevice: scala.Option[primitives.AwsDevice] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, connections: scala.Option[Iterable[Connection]] = None, allowsHostedConnections: scala.Option[primitives.BooleanFlag] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, hasLogicalRedundancy: scala.Option[HasLogicalRedundancy] = None, tags: scala.Option[Iterable[Tag]] = None, providerName: scala.Option[primitives.ProviderName] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateLagResponse = {
      import UpdateLagResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateLagResponse.builder().optionallyWith(connectionsBandwidth.map(value => value: java.lang.String))(_.connectionsBandwidth).optionallyWith(numberOfConnections.map(value => value: java.lang.Integer))(_.numberOfConnections).optionallyWith(lagId.map(value => value: java.lang.String))(_.lagId).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(lagName.map(value => value: java.lang.String))(_.lagName).optionallyWith(lagState.map(value => value.unwrap))(_.lagState).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(minimumLinks.map(value => value: java.lang.Integer))(_.minimumLinks).optionallyWith(awsDevice.map(value => value: java.lang.String))(_.awsDevice).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(connections.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.connections).optionallyWith(allowsHostedConnections.map(value => value: java.lang.Boolean))(_.allowsHostedConnections).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(_.hasLogicalRedundancy).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(providerName.map(value => value: java.lang.String))(_.providerName).build()
    }
    def asReadOnly: UpdateLagResponse.ReadOnly = UpdateLagResponse.wrap(buildAwsValue())
  }
  object UpdateLagResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateLagResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateLagResponse = UpdateLagResponse(connectionsBandwidthValue.map(value => value), numberOfConnectionsValue.map(value => value), lagIdValue.map(value => value), ownerAccountValue.map(value => value), lagNameValue.map(value => value), lagStateValue.map(value => value), locationValue.map(value => value), regionValue.map(value => value), minimumLinksValue.map(value => value), awsDeviceValue.map(value => value), awsDeviceV2Value.map(value => value), connectionsValue.map(value => value.map { item => 
        item.editable
      }), allowsHostedConnectionsValue.map(value => value), jumboFrameCapableValue.map(value => value), hasLogicalRedundancyValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), providerNameValue.map(value => value))
      def connectionsBandwidthValue: scala.Option[primitives.Bandwidth]
      def numberOfConnectionsValue: scala.Option[primitives.Count]
      def lagIdValue: scala.Option[primitives.LagId]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def lagNameValue: scala.Option[primitives.LagName]
      def lagStateValue: scala.Option[LagState]
      def locationValue: scala.Option[primitives.LocationCode]
      def regionValue: scala.Option[primitives.Region]
      def minimumLinksValue: scala.Option[primitives.Count]
      def awsDeviceValue: scala.Option[primitives.AwsDevice]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def connectionsValue: scala.Option[List[Connection.ReadOnly]]
      def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def providerNameValue: scala.Option[primitives.ProviderName]
      def connectionsBandwidth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Bandwidth] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidthValue)
      def numberOfConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfConnections", numberOfConnectionsValue)
      def lagId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagId", lagIdValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def lagName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LagName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagName", lagNameValue)
      def lagState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LagState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lagState", lagStateValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def minimumLinks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Count] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumLinks", minimumLinksValue)
      def awsDevice: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDevice] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDevice", awsDeviceValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def connections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Connection.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connections", connectionsValue)
      def allowsHostedConnections: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanFlag] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowsHostedConnections", allowsHostedConnectionsValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def hasLogicalRedundancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HasLogicalRedundancy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancyValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def providerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ProviderName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("providerName", providerNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateLagResponse) extends UpdateLagResponse.ReadOnly {
      override def connectionsBandwidthValue: scala.Option[primitives.Bandwidth] = scala.Option(impl.connectionsBandwidth()).map(value => value: primitives.Bandwidth)
      override def numberOfConnectionsValue: scala.Option[primitives.Count] = scala.Option(impl.numberOfConnections()).map(value => value: primitives.Count)
      override def lagIdValue: scala.Option[primitives.LagId] = scala.Option(impl.lagId()).map(value => value: primitives.LagId)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def lagNameValue: scala.Option[primitives.LagName] = scala.Option(impl.lagName()).map(value => value: primitives.LagName)
      override def lagStateValue: scala.Option[LagState] = scala.Option(impl.lagState()).map(value => LagState.wrap(value))
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def minimumLinksValue: scala.Option[primitives.Count] = scala.Option(impl.minimumLinks()).map(value => value: primitives.Count)
      override def awsDeviceValue: scala.Option[primitives.AwsDevice] = scala.Option(impl.awsDevice()).map(value => value: primitives.AwsDevice)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def connectionsValue: scala.Option[List[Connection.ReadOnly]] = scala.Option(impl.connections()).map(value => value.asScala.map { item => 
        Connection.wrap(item)
      }.toList)
      override def allowsHostedConnectionsValue: scala.Option[primitives.BooleanFlag] = scala.Option(impl.allowsHostedConnections()).map(value => value: primitives.BooleanFlag)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def hasLogicalRedundancyValue: scala.Option[HasLogicalRedundancy] = scala.Option(impl.hasLogicalRedundancy()).map(value => HasLogicalRedundancy.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def providerNameValue: scala.Option[primitives.ProviderName] = scala.Option(impl.providerName()).map(value => value: primitives.ProviderName)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateLagResponse): ReadOnly = new Wrapper(impl)
  }
  case class UpdateVirtualInterfaceAttributesRequest(virtualInterfaceId: primitives.VirtualInterfaceId, mtu: scala.Option[primitives.MTU] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest = {
      import UpdateVirtualInterfaceAttributesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest.builder().virtualInterfaceId(virtualInterfaceId: java.lang.String).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).build()
    }
    def asReadOnly: UpdateVirtualInterfaceAttributesRequest.ReadOnly = UpdateVirtualInterfaceAttributesRequest.wrap(buildAwsValue())
  }
  object UpdateVirtualInterfaceAttributesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateVirtualInterfaceAttributesRequest = UpdateVirtualInterfaceAttributesRequest(virtualInterfaceIdValue, mtuValue.map(value => value))
      def virtualInterfaceIdValue: primitives.VirtualInterfaceId
      def mtuValue: scala.Option[primitives.MTU]
      def virtualInterfaceId: ZIO[Any, Nothing, primitives.VirtualInterfaceId] = ZIO.succeed(virtualInterfaceIdValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest) extends UpdateVirtualInterfaceAttributesRequest.ReadOnly {
      override def virtualInterfaceIdValue: primitives.VirtualInterfaceId = impl.virtualInterfaceId(): primitives.VirtualInterfaceId
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest): ReadOnly = new Wrapper(impl)
  }
  case class UpdateVirtualInterfaceAttributesResponse(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse = {
      import UpdateVirtualInterfaceAttributesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: UpdateVirtualInterfaceAttributesResponse.ReadOnly = UpdateVirtualInterfaceAttributesResponse.wrap(buildAwsValue())
  }
  object UpdateVirtualInterfaceAttributesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: UpdateVirtualInterfaceAttributesResponse = UpdateVirtualInterfaceAttributesResponse(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse) extends UpdateVirtualInterfaceAttributesResponse.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse): ReadOnly = new Wrapper(impl)
  }
  case class VirtualGateway(virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, virtualGatewayState: scala.Option[primitives.VirtualGatewayState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.VirtualGateway = {
      import VirtualGateway.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.VirtualGateway.builder().optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(virtualGatewayState.map(value => value: java.lang.String))(_.virtualGatewayState).build()
    }
    def asReadOnly: VirtualGateway.ReadOnly = VirtualGateway.wrap(buildAwsValue())
  }
  object VirtualGateway {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.VirtualGateway] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: VirtualGateway = VirtualGateway(virtualGatewayIdValue.map(value => value), virtualGatewayStateValue.map(value => value))
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def virtualGatewayStateValue: scala.Option[primitives.VirtualGatewayState]
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def virtualGatewayState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayState", virtualGatewayStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.VirtualGateway) extends VirtualGateway.ReadOnly {
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def virtualGatewayStateValue: scala.Option[primitives.VirtualGatewayState] = scala.Option(impl.virtualGatewayState()).map(value => value: primitives.VirtualGatewayState)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.VirtualGateway): ReadOnly = new Wrapper(impl)
  }
  type VirtualGatewayList = List[VirtualGateway]
  case class VirtualInterface(ownerAccount: scala.Option[primitives.OwnerAccount] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, location: scala.Option[primitives.LocationCode] = None, connectionId: scala.Option[primitives.ConnectionId] = None, virtualInterfaceType: scala.Option[primitives.VirtualInterfaceType] = None, virtualInterfaceName: scala.Option[primitives.VirtualInterfaceName] = None, vlan: scala.Option[primitives.VLAN] = None, asn: scala.Option[primitives.ASN] = None, amazonSideAsn: scala.Option[primitives.LongAsn] = None, authKey: scala.Option[primitives.BGPAuthKey] = None, amazonAddress: scala.Option[primitives.AmazonAddress] = None, customerAddress: scala.Option[primitives.CustomerAddress] = None, addressFamily: scala.Option[AddressFamily] = None, virtualInterfaceState: scala.Option[VirtualInterfaceState] = None, customerRouterConfig: scala.Option[primitives.RouterConfig] = None, mtu: scala.Option[primitives.MTU] = None, jumboFrameCapable: scala.Option[primitives.JumboFrameCapable] = None, virtualGatewayId: scala.Option[primitives.VirtualGatewayId] = None, directConnectGatewayId: scala.Option[primitives.DirectConnectGatewayId] = None, routeFilterPrefixes: scala.Option[Iterable[RouteFilterPrefix]] = None, bgpPeers: scala.Option[Iterable[BGPPeer]] = None, region: scala.Option[primitives.Region] = None, awsDeviceV2: scala.Option[primitives.AwsDeviceV2] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.VirtualInterface = {
      import VirtualInterface.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.VirtualInterface.builder().optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(location.map(value => value: java.lang.String))(_.location).optionallyWith(connectionId.map(value => value: java.lang.String))(_.connectionId).optionallyWith(virtualInterfaceType.map(value => value: java.lang.String))(_.virtualInterfaceType).optionallyWith(virtualInterfaceName.map(value => value: java.lang.String))(_.virtualInterfaceName).optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan).optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn).optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(_.amazonSideAsn).optionallyWith(authKey.map(value => value: java.lang.String))(_.authKey).optionallyWith(amazonAddress.map(value => value: java.lang.String))(_.amazonAddress).optionallyWith(customerAddress.map(value => value: java.lang.String))(_.customerAddress).optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily).optionallyWith(virtualInterfaceState.map(value => value.unwrap))(_.virtualInterfaceState).optionallyWith(customerRouterConfig.map(value => value: java.lang.String))(_.customerRouterConfig).optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu).optionallyWith(jumboFrameCapable.map(value => value: java.lang.Boolean))(_.jumboFrameCapable).optionallyWith(virtualGatewayId.map(value => value: java.lang.String))(_.virtualGatewayId).optionallyWith(directConnectGatewayId.map(value => value: java.lang.String))(_.directConnectGatewayId).optionallyWith(routeFilterPrefixes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.routeFilterPrefixes).optionallyWith(bgpPeers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.bgpPeers).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(awsDeviceV2.map(value => value: java.lang.String))(_.awsDeviceV2).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: VirtualInterface.ReadOnly = VirtualInterface.wrap(buildAwsValue())
  }
  object VirtualInterface {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.VirtualInterface] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: VirtualInterface = VirtualInterface(ownerAccountValue.map(value => value), virtualInterfaceIdValue.map(value => value), locationValue.map(value => value), connectionIdValue.map(value => value), virtualInterfaceTypeValue.map(value => value), virtualInterfaceNameValue.map(value => value), vlanValue.map(value => value), asnValue.map(value => value), amazonSideAsnValue.map(value => value), authKeyValue.map(value => value), amazonAddressValue.map(value => value), customerAddressValue.map(value => value), addressFamilyValue.map(value => value), virtualInterfaceStateValue.map(value => value), customerRouterConfigValue.map(value => value), mtuValue.map(value => value), jumboFrameCapableValue.map(value => value), virtualGatewayIdValue.map(value => value), directConnectGatewayIdValue.map(value => value), routeFilterPrefixesValue.map(value => value.map { item => 
        item.editable
      }), bgpPeersValue.map(value => value.map { item => 
        item.editable
      }), regionValue.map(value => value), awsDeviceV2Value.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def locationValue: scala.Option[primitives.LocationCode]
      def connectionIdValue: scala.Option[primitives.ConnectionId]
      def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType]
      def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName]
      def vlanValue: scala.Option[primitives.VLAN]
      def asnValue: scala.Option[primitives.ASN]
      def amazonSideAsnValue: scala.Option[primitives.LongAsn]
      def authKeyValue: scala.Option[primitives.BGPAuthKey]
      def amazonAddressValue: scala.Option[primitives.AmazonAddress]
      def customerAddressValue: scala.Option[primitives.CustomerAddress]
      def addressFamilyValue: scala.Option[AddressFamily]
      def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState]
      def customerRouterConfigValue: scala.Option[primitives.RouterConfig]
      def mtuValue: scala.Option[primitives.MTU]
      def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable]
      def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId]
      def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId]
      def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]]
      def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]]
      def regionValue: scala.Option[primitives.Region]
      def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LocationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
      def connectionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ConnectionId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionId", connectionIdValue)
      def virtualInterfaceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceTypeValue)
      def virtualInterfaceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceNameValue)
      def vlan: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VLAN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vlan", vlanValue)
      def asn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ASN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("asn", asnValue)
      def amazonSideAsn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongAsn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsnValue)
      def authKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BGPAuthKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("authKey", authKeyValue)
      def amazonAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmazonAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amazonAddress", amazonAddressValue)
      def customerAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CustomerAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAddress", customerAddressValue)
      def addressFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AddressFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addressFamily", addressFamilyValue)
      def virtualInterfaceState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VirtualInterfaceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceStateValue)
      def customerRouterConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RouterConfig] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfigValue)
      def mtu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MTU] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mtu", mtuValue)
      def jumboFrameCapable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.JumboFrameCapable] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapableValue)
      def virtualGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayIdValue)
      def directConnectGatewayId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DirectConnectGatewayId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("directConnectGatewayId", directConnectGatewayIdValue)
      def routeFilterPrefixes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RouteFilterPrefix.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixesValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BGPPeer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def awsDeviceV2: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsDeviceV2] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2Value)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.VirtualInterface) extends VirtualInterface.ReadOnly {
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def locationValue: scala.Option[primitives.LocationCode] = scala.Option(impl.location()).map(value => value: primitives.LocationCode)
      override def connectionIdValue: scala.Option[primitives.ConnectionId] = scala.Option(impl.connectionId()).map(value => value: primitives.ConnectionId)
      override def virtualInterfaceTypeValue: scala.Option[primitives.VirtualInterfaceType] = scala.Option(impl.virtualInterfaceType()).map(value => value: primitives.VirtualInterfaceType)
      override def virtualInterfaceNameValue: scala.Option[primitives.VirtualInterfaceName] = scala.Option(impl.virtualInterfaceName()).map(value => value: primitives.VirtualInterfaceName)
      override def vlanValue: scala.Option[primitives.VLAN] = scala.Option(impl.vlan()).map(value => value: primitives.VLAN)
      override def asnValue: scala.Option[primitives.ASN] = scala.Option(impl.asn()).map(value => value: primitives.ASN)
      override def amazonSideAsnValue: scala.Option[primitives.LongAsn] = scala.Option(impl.amazonSideAsn()).map(value => value: primitives.LongAsn)
      override def authKeyValue: scala.Option[primitives.BGPAuthKey] = scala.Option(impl.authKey()).map(value => value: primitives.BGPAuthKey)
      override def amazonAddressValue: scala.Option[primitives.AmazonAddress] = scala.Option(impl.amazonAddress()).map(value => value: primitives.AmazonAddress)
      override def customerAddressValue: scala.Option[primitives.CustomerAddress] = scala.Option(impl.customerAddress()).map(value => value: primitives.CustomerAddress)
      override def addressFamilyValue: scala.Option[AddressFamily] = scala.Option(impl.addressFamily()).map(value => AddressFamily.wrap(value))
      override def virtualInterfaceStateValue: scala.Option[VirtualInterfaceState] = scala.Option(impl.virtualInterfaceState()).map(value => VirtualInterfaceState.wrap(value))
      override def customerRouterConfigValue: scala.Option[primitives.RouterConfig] = scala.Option(impl.customerRouterConfig()).map(value => value: primitives.RouterConfig)
      override def mtuValue: scala.Option[primitives.MTU] = scala.Option(impl.mtu()).map(value => value: primitives.MTU)
      override def jumboFrameCapableValue: scala.Option[primitives.JumboFrameCapable] = scala.Option(impl.jumboFrameCapable()).map(value => value: primitives.JumboFrameCapable)
      override def virtualGatewayIdValue: scala.Option[primitives.VirtualGatewayId] = scala.Option(impl.virtualGatewayId()).map(value => value: primitives.VirtualGatewayId)
      override def directConnectGatewayIdValue: scala.Option[primitives.DirectConnectGatewayId] = scala.Option(impl.directConnectGatewayId()).map(value => value: primitives.DirectConnectGatewayId)
      override def routeFilterPrefixesValue: scala.Option[List[RouteFilterPrefix.ReadOnly]] = scala.Option(impl.routeFilterPrefixes()).map(value => value.asScala.map { item => 
        RouteFilterPrefix.wrap(item)
      }.toList)
      override def bgpPeersValue: scala.Option[List[BGPPeer.ReadOnly]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        BGPPeer.wrap(item)
      }.toList)
      override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
      override def awsDeviceV2Value: scala.Option[primitives.AwsDeviceV2] = scala.Option(impl.awsDeviceV2()).map(value => value: primitives.AwsDeviceV2)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.VirtualInterface): ReadOnly = new Wrapper(impl)
  }
  type VirtualInterfaceList = List[VirtualInterface]
  sealed trait VirtualInterfaceState { def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState }
  object VirtualInterfaceState {
    def wrap(value: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState): VirtualInterfaceState = value match {
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.CONFIRMING => confirming
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.VERIFYING => verifying
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.PENDING => pending
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.AVAILABLE => available
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DOWN => down
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETING => deleting
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETED => deleted
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.REJECTED => rejected
      case software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN => unknown
    }
    final case object unknownToSdkVersion extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN_TO_SDK_VERSION }
    final case object confirming extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.CONFIRMING }
    final case object verifying extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.VERIFYING }
    final case object pending extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.PENDING }
    final case object available extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.AVAILABLE }
    final case object down extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DOWN }
    final case object deleting extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETING }
    final case object deleted extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.DELETED }
    final case object rejected extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.REJECTED }
    final case object unknown extends VirtualInterfaceState { override def unwrap: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState = software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState.UNKNOWN }
  }
  case class VirtualInterfaceTestHistory(testId: scala.Option[primitives.TestId] = None, virtualInterfaceId: scala.Option[primitives.VirtualInterfaceId] = None, bgpPeers: scala.Option[Iterable[primitives.BGPPeerId]] = None, status: scala.Option[primitives.FailureTestHistoryStatus] = None, ownerAccount: scala.Option[primitives.OwnerAccount] = None, testDurationInMinutes: scala.Option[primitives.TestDuration] = None, startTime: scala.Option[primitives.StartTime] = None, endTime: scala.Option[primitives.EndTime] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory = {
      import VirtualInterfaceTestHistory.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory.builder().optionallyWith(testId.map(value => value: java.lang.String))(_.testId).optionallyWith(virtualInterfaceId.map(value => value: java.lang.String))(_.virtualInterfaceId).optionallyWith(bgpPeers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.bgpPeers).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(ownerAccount.map(value => value: java.lang.String))(_.ownerAccount).optionallyWith(testDurationInMinutes.map(value => value: java.lang.Integer))(_.testDurationInMinutes).optionallyWith(startTime.map(value => value: java.time.Instant))(_.startTime).optionallyWith(endTime.map(value => value: java.time.Instant))(_.endTime).build()
    }
    def asReadOnly: VirtualInterfaceTestHistory.ReadOnly = VirtualInterfaceTestHistory.wrap(buildAwsValue())
  }
  object VirtualInterfaceTestHistory {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: VirtualInterfaceTestHistory = VirtualInterfaceTestHistory(testIdValue.map(value => value), virtualInterfaceIdValue.map(value => value), bgpPeersValue.map(value => value), statusValue.map(value => value), ownerAccountValue.map(value => value), testDurationInMinutesValue.map(value => value), startTimeValue.map(value => value), endTimeValue.map(value => value))
      def testIdValue: scala.Option[primitives.TestId]
      def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId]
      def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]]
      def statusValue: scala.Option[primitives.FailureTestHistoryStatus]
      def ownerAccountValue: scala.Option[primitives.OwnerAccount]
      def testDurationInMinutesValue: scala.Option[primitives.TestDuration]
      def startTimeValue: scala.Option[primitives.StartTime]
      def endTimeValue: scala.Option[primitives.EndTime]
      def testId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TestId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("testId", testIdValue)
      def virtualInterfaceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.VirtualInterfaceId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceIdValue)
      def bgpPeers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.BGPPeerId]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bgpPeers", bgpPeersValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.FailureTestHistoryStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def ownerAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OwnerAccount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccount", ownerAccountValue)
      def testDurationInMinutes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TestDuration] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("testDurationInMinutes", testDurationInMinutesValue)
      def startTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StartTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startTime", startTimeValue)
      def endTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.EndTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endTime", endTimeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory) extends VirtualInterfaceTestHistory.ReadOnly {
      override def testIdValue: scala.Option[primitives.TestId] = scala.Option(impl.testId()).map(value => value: primitives.TestId)
      override def virtualInterfaceIdValue: scala.Option[primitives.VirtualInterfaceId] = scala.Option(impl.virtualInterfaceId()).map(value => value: primitives.VirtualInterfaceId)
      override def bgpPeersValue: scala.Option[List[primitives.BGPPeerId]] = scala.Option(impl.bgpPeers()).map(value => value.asScala.map { item => 
        item: primitives.BGPPeerId
      }.toList)
      override def statusValue: scala.Option[primitives.FailureTestHistoryStatus] = scala.Option(impl.status()).map(value => value: primitives.FailureTestHistoryStatus)
      override def ownerAccountValue: scala.Option[primitives.OwnerAccount] = scala.Option(impl.ownerAccount()).map(value => value: primitives.OwnerAccount)
      override def testDurationInMinutesValue: scala.Option[primitives.TestDuration] = scala.Option(impl.testDurationInMinutes()).map(value => value: primitives.TestDuration)
      override def startTimeValue: scala.Option[primitives.StartTime] = scala.Option(impl.startTime()).map(value => value: primitives.StartTime)
      override def endTimeValue: scala.Option[primitives.EndTime] = scala.Option(impl.endTime()).map(value => value: primitives.EndTime)
    }
    def wrap(impl: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory): ReadOnly = new Wrapper(impl)
  }
  type VirtualInterfaceTestHistoryList = List[VirtualInterfaceTestHistory]
}