package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core._
import io.github.vigoo.zioaws.core.aspects._
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.services.directconnect.{ DirectConnectAsyncClient, DirectConnectAsyncClientBuilder }
import zio.{ Chunk, Has, IO, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters._
package object directconnect {
  import model._
  type DirectConnect = Has[DirectConnect.Service]
  object DirectConnect {
    trait Service extends AspectSupport[Service] {
      val api: DirectConnectAsyncClient
      def allocatePrivateVirtualInterface(request: AllocatePrivateVirtualInterfaceRequest): IO[AwsError, AllocatePrivateVirtualInterfaceResponse.ReadOnly]
      def createTransitVirtualInterface(request: CreateTransitVirtualInterfaceRequest): IO[AwsError, CreateTransitVirtualInterfaceResponse.ReadOnly]
      def describeTags(request: DescribeTagsRequest): IO[AwsError, DescribeTagsResponse.ReadOnly]
      def stopBgpFailoverTest(request: StopBgpFailoverTestRequest): IO[AwsError, StopBgpFailoverTestResponse.ReadOnly]
      def createDirectConnectGateway(request: CreateDirectConnectGatewayRequest): IO[AwsError, CreateDirectConnectGatewayResponse.ReadOnly]
      def associateHostedConnection(request: AssociateHostedConnectionRequest): IO[AwsError, AssociateHostedConnectionResponse.ReadOnly]
      def describeDirectConnectGatewayAttachments(request: DescribeDirectConnectGatewayAttachmentsRequest): IO[AwsError, DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly]
      def describeDirectConnectGateways(request: DescribeDirectConnectGatewaysRequest): IO[AwsError, DescribeDirectConnectGatewaysResponse.ReadOnly]
      def listVirtualInterfaceTestHistory(request: ListVirtualInterfaceTestHistoryRequest): IO[AwsError, ListVirtualInterfaceTestHistoryResponse.ReadOnly]
      def disassociateConnectionFromLag(request: DisassociateConnectionFromLagRequest): IO[AwsError, DisassociateConnectionFromLagResponse.ReadOnly]
      def allocateHostedConnection(request: AllocateHostedConnectionRequest): IO[AwsError, AllocateHostedConnectionResponse.ReadOnly]
      def describeHostedConnections(request: DescribeHostedConnectionsRequest): IO[AwsError, DescribeHostedConnectionsResponse.ReadOnly]
      def createConnection(request: CreateConnectionRequest): IO[AwsError, CreateConnectionResponse.ReadOnly]
      def confirmPublicVirtualInterface(request: ConfirmPublicVirtualInterfaceRequest): IO[AwsError, ConfirmPublicVirtualInterfaceResponse.ReadOnly]
      def startBgpFailoverTest(request: StartBgpFailoverTestRequest): IO[AwsError, StartBgpFailoverTestResponse.ReadOnly]
      def deleteDirectConnectGatewayAssociation(request: DeleteDirectConnectGatewayAssociationRequest): IO[AwsError, DeleteDirectConnectGatewayAssociationResponse.ReadOnly]
      def updateLag(request: UpdateLagRequest): IO[AwsError, UpdateLagResponse.ReadOnly]
      def deleteBGPPeer(request: DeleteBgpPeerRequest): IO[AwsError, DeleteBgpPeerResponse.ReadOnly]
      def confirmConnection(request: ConfirmConnectionRequest): IO[AwsError, ConfirmConnectionResponse.ReadOnly]
      def describeDirectConnectGatewayAssociations(request: DescribeDirectConnectGatewayAssociationsRequest): IO[AwsError, DescribeDirectConnectGatewayAssociationsResponse.ReadOnly]
      def acceptDirectConnectGatewayAssociationProposal(request: AcceptDirectConnectGatewayAssociationProposalRequest): IO[AwsError, AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly]
      def allocatePublicVirtualInterface(request: AllocatePublicVirtualInterfaceRequest): IO[AwsError, AllocatePublicVirtualInterfaceResponse.ReadOnly]
      def deleteVirtualInterface(request: DeleteVirtualInterfaceRequest): IO[AwsError, DeleteVirtualInterfaceResponse.ReadOnly]
      def createPublicVirtualInterface(request: CreatePublicVirtualInterfaceRequest): IO[AwsError, CreatePublicVirtualInterfaceResponse.ReadOnly]
      def deleteInterconnect(request: DeleteInterconnectRequest): IO[AwsError, DeleteInterconnectResponse.ReadOnly]
      def untagResource(request: UntagResourceRequest): IO[AwsError, UntagResourceResponse.ReadOnly]
      def deleteLag(request: DeleteLagRequest): IO[AwsError, DeleteLagResponse.ReadOnly]
      def describeVirtualInterfaces(request: DescribeVirtualInterfacesRequest): IO[AwsError, DescribeVirtualInterfacesResponse.ReadOnly]
      def describeInterconnects(request: DescribeInterconnectsRequest): IO[AwsError, DescribeInterconnectsResponse.ReadOnly]
      def deleteDirectConnectGateway(request: DeleteDirectConnectGatewayRequest): IO[AwsError, DeleteDirectConnectGatewayResponse.ReadOnly]
      def createPrivateVirtualInterface(request: CreatePrivateVirtualInterfaceRequest): IO[AwsError, CreatePrivateVirtualInterfaceResponse.ReadOnly]
      def describeLags(request: DescribeLagsRequest): IO[AwsError, DescribeLagsResponse.ReadOnly]
      def describeLocations(): IO[AwsError, DescribeLocationsResponse.ReadOnly]
      def createBGPPeer(request: CreateBgpPeerRequest): IO[AwsError, CreateBgpPeerResponse.ReadOnly]
      def allocateTransitVirtualInterface(request: AllocateTransitVirtualInterfaceRequest): IO[AwsError, AllocateTransitVirtualInterfaceResponse.ReadOnly]
      def associateVirtualInterface(request: AssociateVirtualInterfaceRequest): IO[AwsError, AssociateVirtualInterfaceResponse.ReadOnly]
      def confirmPrivateVirtualInterface(request: ConfirmPrivateVirtualInterfaceRequest): IO[AwsError, ConfirmPrivateVirtualInterfaceResponse.ReadOnly]
      def updateDirectConnectGatewayAssociation(request: UpdateDirectConnectGatewayAssociationRequest): IO[AwsError, UpdateDirectConnectGatewayAssociationResponse.ReadOnly]
      def deleteConnection(request: DeleteConnectionRequest): IO[AwsError, DeleteConnectionResponse.ReadOnly]
      def tagResource(request: TagResourceRequest): IO[AwsError, TagResourceResponse.ReadOnly]
      def deleteDirectConnectGatewayAssociationProposal(request: DeleteDirectConnectGatewayAssociationProposalRequest): IO[AwsError, DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly]
      def updateVirtualInterfaceAttributes(request: UpdateVirtualInterfaceAttributesRequest): IO[AwsError, UpdateVirtualInterfaceAttributesResponse.ReadOnly]
      def confirmTransitVirtualInterface(request: ConfirmTransitVirtualInterfaceRequest): IO[AwsError, ConfirmTransitVirtualInterfaceResponse.ReadOnly]
      def describeVirtualGateways(): IO[AwsError, DescribeVirtualGatewaysResponse.ReadOnly]
      def describeDirectConnectGatewayAssociationProposals(request: DescribeDirectConnectGatewayAssociationProposalsRequest): IO[AwsError, DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly]
      def describeConnections(request: DescribeConnectionsRequest): IO[AwsError, DescribeConnectionsResponse.ReadOnly]
      def createDirectConnectGatewayAssociation(request: CreateDirectConnectGatewayAssociationRequest): IO[AwsError, CreateDirectConnectGatewayAssociationResponse.ReadOnly]
      def createInterconnect(request: CreateInterconnectRequest): IO[AwsError, CreateInterconnectResponse.ReadOnly]
      def createDirectConnectGatewayAssociationProposal(request: CreateDirectConnectGatewayAssociationProposalRequest): IO[AwsError, CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly]
      def createLag(request: CreateLagRequest): IO[AwsError, CreateLagResponse.ReadOnly]
      def associateConnectionWithLag(request: AssociateConnectionWithLagRequest): IO[AwsError, AssociateConnectionWithLagResponse.ReadOnly]
      def describeLoa(request: DescribeLoaRequest): IO[AwsError, DescribeLoaResponse.ReadOnly]
    }
  }
  val live: ZLayer[AwsConfig, Throwable, DirectConnect] = customized(identity)
  def customized(customization: DirectConnectAsyncClientBuilder => DirectConnectAsyncClientBuilder): ZLayer[AwsConfig, Throwable, DirectConnect] = managed(customization).toLayer
  def managed(customization: DirectConnectAsyncClientBuilder => DirectConnectAsyncClientBuilder): ZManaged[AwsConfig, Throwable, DirectConnect.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; b0 <- awsConfig.configure[DirectConnectAsyncClient, DirectConnectAsyncClientBuilder](DirectConnectAsyncClient.builder()).toManaged_; b1 <- awsConfig.configureHttpClient[DirectConnectAsyncClient, DirectConnectAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new DirectConnectImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class DirectConnectImpl[R](override val api: DirectConnectAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends DirectConnect.Service with AwsServiceBase[R, DirectConnectImpl] {
    override val serviceName: String = "DirectConnect"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): DirectConnectImpl[R1] = new DirectConnectImpl(api, newAspect, r)
    def allocatePrivateVirtualInterface(request: AllocatePrivateVirtualInterfaceRequest): IO[AwsError, AllocatePrivateVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse]("allocatePrivateVirtualInterface", api.allocatePrivateVirtualInterface)(request.buildAwsValue()).map(AllocatePrivateVirtualInterfaceResponse.wrap).provide(r)
    def createTransitVirtualInterface(request: CreateTransitVirtualInterfaceRequest): IO[AwsError, CreateTransitVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse]("createTransitVirtualInterface", api.createTransitVirtualInterface)(request.buildAwsValue()).map(CreateTransitVirtualInterfaceResponse.wrap).provide(r)
    def describeTags(request: DescribeTagsRequest): IO[AwsError, DescribeTagsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest, software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse]("describeTags", api.describeTags)(request.buildAwsValue()).map(DescribeTagsResponse.wrap).provide(r)
    def stopBgpFailoverTest(request: StopBgpFailoverTestRequest): IO[AwsError, StopBgpFailoverTestResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest, software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse]("stopBgpFailoverTest", api.stopBgpFailoverTest)(request.buildAwsValue()).map(StopBgpFailoverTestResponse.wrap).provide(r)
    def createDirectConnectGateway(request: CreateDirectConnectGatewayRequest): IO[AwsError, CreateDirectConnectGatewayResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest, software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse]("createDirectConnectGateway", api.createDirectConnectGateway)(request.buildAwsValue()).map(CreateDirectConnectGatewayResponse.wrap).provide(r)
    def associateHostedConnection(request: AssociateHostedConnectionRequest): IO[AwsError, AssociateHostedConnectionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest, software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse]("associateHostedConnection", api.associateHostedConnection)(request.buildAwsValue()).map(AssociateHostedConnectionResponse.wrap).provide(r)
    def describeDirectConnectGatewayAttachments(request: DescribeDirectConnectGatewayAttachmentsRequest): IO[AwsError, DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest, software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse]("describeDirectConnectGatewayAttachments", api.describeDirectConnectGatewayAttachments)(request.buildAwsValue()).map(DescribeDirectConnectGatewayAttachmentsResponse.wrap).provide(r)
    def describeDirectConnectGateways(request: DescribeDirectConnectGatewaysRequest): IO[AwsError, DescribeDirectConnectGatewaysResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest, software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse]("describeDirectConnectGateways", api.describeDirectConnectGateways)(request.buildAwsValue()).map(DescribeDirectConnectGatewaysResponse.wrap).provide(r)
    def listVirtualInterfaceTestHistory(request: ListVirtualInterfaceTestHistoryRequest): IO[AwsError, ListVirtualInterfaceTestHistoryResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest, software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse]("listVirtualInterfaceTestHistory", api.listVirtualInterfaceTestHistory)(request.buildAwsValue()).map(ListVirtualInterfaceTestHistoryResponse.wrap).provide(r)
    def disassociateConnectionFromLag(request: DisassociateConnectionFromLagRequest): IO[AwsError, DisassociateConnectionFromLagResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest, software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse]("disassociateConnectionFromLag", api.disassociateConnectionFromLag)(request.buildAwsValue()).map(DisassociateConnectionFromLagResponse.wrap).provide(r)
    def allocateHostedConnection(request: AllocateHostedConnectionRequest): IO[AwsError, AllocateHostedConnectionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest, software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse]("allocateHostedConnection", api.allocateHostedConnection)(request.buildAwsValue()).map(AllocateHostedConnectionResponse.wrap).provide(r)
    def describeHostedConnections(request: DescribeHostedConnectionsRequest): IO[AwsError, DescribeHostedConnectionsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest, software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse]("describeHostedConnections", api.describeHostedConnections)(request.buildAwsValue()).map(DescribeHostedConnectionsResponse.wrap).provide(r)
    def createConnection(request: CreateConnectionRequest): IO[AwsError, CreateConnectionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest, software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse]("createConnection", api.createConnection)(request.buildAwsValue()).map(CreateConnectionResponse.wrap).provide(r)
    def confirmPublicVirtualInterface(request: ConfirmPublicVirtualInterfaceRequest): IO[AwsError, ConfirmPublicVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse]("confirmPublicVirtualInterface", api.confirmPublicVirtualInterface)(request.buildAwsValue()).map(ConfirmPublicVirtualInterfaceResponse.wrap).provide(r)
    def startBgpFailoverTest(request: StartBgpFailoverTestRequest): IO[AwsError, StartBgpFailoverTestResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest, software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse]("startBgpFailoverTest", api.startBgpFailoverTest)(request.buildAwsValue()).map(StartBgpFailoverTestResponse.wrap).provide(r)
    def deleteDirectConnectGatewayAssociation(request: DeleteDirectConnectGatewayAssociationRequest): IO[AwsError, DeleteDirectConnectGatewayAssociationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest, software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse]("deleteDirectConnectGatewayAssociation", api.deleteDirectConnectGatewayAssociation)(request.buildAwsValue()).map(DeleteDirectConnectGatewayAssociationResponse.wrap).provide(r)
    def updateLag(request: UpdateLagRequest): IO[AwsError, UpdateLagResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.UpdateLagRequest, software.amazon.awssdk.services.directconnect.model.UpdateLagResponse]("updateLag", api.updateLag)(request.buildAwsValue()).map(UpdateLagResponse.wrap).provide(r)
    def deleteBGPPeer(request: DeleteBgpPeerRequest): IO[AwsError, DeleteBgpPeerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest, software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse]("deleteBGPPeer", api.deleteBGPPeer)(request.buildAwsValue()).map(DeleteBgpPeerResponse.wrap).provide(r)
    def confirmConnection(request: ConfirmConnectionRequest): IO[AwsError, ConfirmConnectionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest, software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse]("confirmConnection", api.confirmConnection)(request.buildAwsValue()).map(ConfirmConnectionResponse.wrap).provide(r)
    def describeDirectConnectGatewayAssociations(request: DescribeDirectConnectGatewayAssociationsRequest): IO[AwsError, DescribeDirectConnectGatewayAssociationsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest, software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse]("describeDirectConnectGatewayAssociations", api.describeDirectConnectGatewayAssociations)(request.buildAwsValue()).map(DescribeDirectConnectGatewayAssociationsResponse.wrap).provide(r)
    def acceptDirectConnectGatewayAssociationProposal(request: AcceptDirectConnectGatewayAssociationProposalRequest): IO[AwsError, AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest, software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse]("acceptDirectConnectGatewayAssociationProposal", api.acceptDirectConnectGatewayAssociationProposal)(request.buildAwsValue()).map(AcceptDirectConnectGatewayAssociationProposalResponse.wrap).provide(r)
    def allocatePublicVirtualInterface(request: AllocatePublicVirtualInterfaceRequest): IO[AwsError, AllocatePublicVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse]("allocatePublicVirtualInterface", api.allocatePublicVirtualInterface)(request.buildAwsValue()).map(AllocatePublicVirtualInterfaceResponse.wrap).provide(r)
    def deleteVirtualInterface(request: DeleteVirtualInterfaceRequest): IO[AwsError, DeleteVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse]("deleteVirtualInterface", api.deleteVirtualInterface)(request.buildAwsValue()).map(DeleteVirtualInterfaceResponse.wrap).provide(r)
    def createPublicVirtualInterface(request: CreatePublicVirtualInterfaceRequest): IO[AwsError, CreatePublicVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse]("createPublicVirtualInterface", api.createPublicVirtualInterface)(request.buildAwsValue()).map(CreatePublicVirtualInterfaceResponse.wrap).provide(r)
    def deleteInterconnect(request: DeleteInterconnectRequest): IO[AwsError, DeleteInterconnectResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest, software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse]("deleteInterconnect", api.deleteInterconnect)(request.buildAwsValue()).map(DeleteInterconnectResponse.wrap).provide(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, UntagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.UntagResourceRequest, software.amazon.awssdk.services.directconnect.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).map(UntagResourceResponse.wrap).provide(r)
    def deleteLag(request: DeleteLagRequest): IO[AwsError, DeleteLagResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteLagRequest, software.amazon.awssdk.services.directconnect.model.DeleteLagResponse]("deleteLag", api.deleteLag)(request.buildAwsValue()).map(DeleteLagResponse.wrap).provide(r)
    def describeVirtualInterfaces(request: DescribeVirtualInterfacesRequest): IO[AwsError, DescribeVirtualInterfacesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest, software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse]("describeVirtualInterfaces", api.describeVirtualInterfaces)(request.buildAwsValue()).map(DescribeVirtualInterfacesResponse.wrap).provide(r)
    def describeInterconnects(request: DescribeInterconnectsRequest): IO[AwsError, DescribeInterconnectsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest, software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse]("describeInterconnects", api.describeInterconnects)(request.buildAwsValue()).map(DescribeInterconnectsResponse.wrap).provide(r)
    def deleteDirectConnectGateway(request: DeleteDirectConnectGatewayRequest): IO[AwsError, DeleteDirectConnectGatewayResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest, software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse]("deleteDirectConnectGateway", api.deleteDirectConnectGateway)(request.buildAwsValue()).map(DeleteDirectConnectGatewayResponse.wrap).provide(r)
    def createPrivateVirtualInterface(request: CreatePrivateVirtualInterfaceRequest): IO[AwsError, CreatePrivateVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse]("createPrivateVirtualInterface", api.createPrivateVirtualInterface)(request.buildAwsValue()).map(CreatePrivateVirtualInterfaceResponse.wrap).provide(r)
    def describeLags(request: DescribeLagsRequest): IO[AwsError, DescribeLagsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest, software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse]("describeLags", api.describeLags)(request.buildAwsValue()).map(DescribeLagsResponse.wrap).provide(r)
    def describeLocations(): IO[AwsError, DescribeLocationsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest, software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse]("describeLocations", api.describeLocations)(software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest.builder().build()).map(DescribeLocationsResponse.wrap).provide(r)
    def createBGPPeer(request: CreateBgpPeerRequest): IO[AwsError, CreateBgpPeerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest, software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse]("createBGPPeer", api.createBGPPeer)(request.buildAwsValue()).map(CreateBgpPeerResponse.wrap).provide(r)
    def allocateTransitVirtualInterface(request: AllocateTransitVirtualInterfaceRequest): IO[AwsError, AllocateTransitVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse]("allocateTransitVirtualInterface", api.allocateTransitVirtualInterface)(request.buildAwsValue()).map(AllocateTransitVirtualInterfaceResponse.wrap).provide(r)
    def associateVirtualInterface(request: AssociateVirtualInterfaceRequest): IO[AwsError, AssociateVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse]("associateVirtualInterface", api.associateVirtualInterface)(request.buildAwsValue()).map(AssociateVirtualInterfaceResponse.wrap).provide(r)
    def confirmPrivateVirtualInterface(request: ConfirmPrivateVirtualInterfaceRequest): IO[AwsError, ConfirmPrivateVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse]("confirmPrivateVirtualInterface", api.confirmPrivateVirtualInterface)(request.buildAwsValue()).map(ConfirmPrivateVirtualInterfaceResponse.wrap).provide(r)
    def updateDirectConnectGatewayAssociation(request: UpdateDirectConnectGatewayAssociationRequest): IO[AwsError, UpdateDirectConnectGatewayAssociationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest, software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse]("updateDirectConnectGatewayAssociation", api.updateDirectConnectGatewayAssociation)(request.buildAwsValue()).map(UpdateDirectConnectGatewayAssociationResponse.wrap).provide(r)
    def deleteConnection(request: DeleteConnectionRequest): IO[AwsError, DeleteConnectionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest, software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse]("deleteConnection", api.deleteConnection)(request.buildAwsValue()).map(DeleteConnectionResponse.wrap).provide(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, TagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.TagResourceRequest, software.amazon.awssdk.services.directconnect.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).map(TagResourceResponse.wrap).provide(r)
    def deleteDirectConnectGatewayAssociationProposal(request: DeleteDirectConnectGatewayAssociationProposalRequest): IO[AwsError, DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest, software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse]("deleteDirectConnectGatewayAssociationProposal", api.deleteDirectConnectGatewayAssociationProposal)(request.buildAwsValue()).map(DeleteDirectConnectGatewayAssociationProposalResponse.wrap).provide(r)
    def updateVirtualInterfaceAttributes(request: UpdateVirtualInterfaceAttributesRequest): IO[AwsError, UpdateVirtualInterfaceAttributesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest, software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse]("updateVirtualInterfaceAttributes", api.updateVirtualInterfaceAttributes)(request.buildAwsValue()).map(UpdateVirtualInterfaceAttributesResponse.wrap).provide(r)
    def confirmTransitVirtualInterface(request: ConfirmTransitVirtualInterfaceRequest): IO[AwsError, ConfirmTransitVirtualInterfaceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest, software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse]("confirmTransitVirtualInterface", api.confirmTransitVirtualInterface)(request.buildAwsValue()).map(ConfirmTransitVirtualInterfaceResponse.wrap).provide(r)
    def describeVirtualGateways(): IO[AwsError, DescribeVirtualGatewaysResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest, software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse]("describeVirtualGateways", api.describeVirtualGateways)(software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest.builder().build()).map(DescribeVirtualGatewaysResponse.wrap).provide(r)
    def describeDirectConnectGatewayAssociationProposals(request: DescribeDirectConnectGatewayAssociationProposalsRequest): IO[AwsError, DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest, software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse]("describeDirectConnectGatewayAssociationProposals", api.describeDirectConnectGatewayAssociationProposals)(request.buildAwsValue()).map(DescribeDirectConnectGatewayAssociationProposalsResponse.wrap).provide(r)
    def describeConnections(request: DescribeConnectionsRequest): IO[AwsError, DescribeConnectionsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest, software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse]("describeConnections", api.describeConnections)(request.buildAwsValue()).map(DescribeConnectionsResponse.wrap).provide(r)
    def createDirectConnectGatewayAssociation(request: CreateDirectConnectGatewayAssociationRequest): IO[AwsError, CreateDirectConnectGatewayAssociationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest, software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse]("createDirectConnectGatewayAssociation", api.createDirectConnectGatewayAssociation)(request.buildAwsValue()).map(CreateDirectConnectGatewayAssociationResponse.wrap).provide(r)
    def createInterconnect(request: CreateInterconnectRequest): IO[AwsError, CreateInterconnectResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest, software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse]("createInterconnect", api.createInterconnect)(request.buildAwsValue()).map(CreateInterconnectResponse.wrap).provide(r)
    def createDirectConnectGatewayAssociationProposal(request: CreateDirectConnectGatewayAssociationProposalRequest): IO[AwsError, CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest, software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse]("createDirectConnectGatewayAssociationProposal", api.createDirectConnectGatewayAssociationProposal)(request.buildAwsValue()).map(CreateDirectConnectGatewayAssociationProposalResponse.wrap).provide(r)
    def createLag(request: CreateLagRequest): IO[AwsError, CreateLagResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.CreateLagRequest, software.amazon.awssdk.services.directconnect.model.CreateLagResponse]("createLag", api.createLag)(request.buildAwsValue()).map(CreateLagResponse.wrap).provide(r)
    def associateConnectionWithLag(request: AssociateConnectionWithLagRequest): IO[AwsError, AssociateConnectionWithLagResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest, software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse]("associateConnectionWithLag", api.associateConnectionWithLag)(request.buildAwsValue()).map(AssociateConnectionWithLagResponse.wrap).provide(r)
    def describeLoa(request: DescribeLoaRequest): IO[AwsError, DescribeLoaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest, software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse]("describeLoa", api.describeLoa)(request.buildAwsValue()).map(DescribeLoaResponse.wrap).provide(r)
  }
  def allocatePrivateVirtualInterface(request: AllocatePrivateVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, AllocatePrivateVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.allocatePrivateVirtualInterface(request))
  def createTransitVirtualInterface(request: CreateTransitVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, CreateTransitVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.createTransitVirtualInterface(request))
  def describeTags(request: DescribeTagsRequest): ZIO[DirectConnect, AwsError, DescribeTagsResponse.ReadOnly] = ZIO.accessM(_.get.describeTags(request))
  def stopBgpFailoverTest(request: StopBgpFailoverTestRequest): ZIO[DirectConnect, AwsError, StopBgpFailoverTestResponse.ReadOnly] = ZIO.accessM(_.get.stopBgpFailoverTest(request))
  def createDirectConnectGateway(request: CreateDirectConnectGatewayRequest): ZIO[DirectConnect, AwsError, CreateDirectConnectGatewayResponse.ReadOnly] = ZIO.accessM(_.get.createDirectConnectGateway(request))
  def associateHostedConnection(request: AssociateHostedConnectionRequest): ZIO[DirectConnect, AwsError, AssociateHostedConnectionResponse.ReadOnly] = ZIO.accessM(_.get.associateHostedConnection(request))
  def describeDirectConnectGatewayAttachments(request: DescribeDirectConnectGatewayAttachmentsRequest): ZIO[DirectConnect, AwsError, DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly] = ZIO.accessM(_.get.describeDirectConnectGatewayAttachments(request))
  def describeDirectConnectGateways(request: DescribeDirectConnectGatewaysRequest): ZIO[DirectConnect, AwsError, DescribeDirectConnectGatewaysResponse.ReadOnly] = ZIO.accessM(_.get.describeDirectConnectGateways(request))
  def listVirtualInterfaceTestHistory(request: ListVirtualInterfaceTestHistoryRequest): ZIO[DirectConnect, AwsError, ListVirtualInterfaceTestHistoryResponse.ReadOnly] = ZIO.accessM(_.get.listVirtualInterfaceTestHistory(request))
  def disassociateConnectionFromLag(request: DisassociateConnectionFromLagRequest): ZIO[DirectConnect, AwsError, DisassociateConnectionFromLagResponse.ReadOnly] = ZIO.accessM(_.get.disassociateConnectionFromLag(request))
  def allocateHostedConnection(request: AllocateHostedConnectionRequest): ZIO[DirectConnect, AwsError, AllocateHostedConnectionResponse.ReadOnly] = ZIO.accessM(_.get.allocateHostedConnection(request))
  def describeHostedConnections(request: DescribeHostedConnectionsRequest): ZIO[DirectConnect, AwsError, DescribeHostedConnectionsResponse.ReadOnly] = ZIO.accessM(_.get.describeHostedConnections(request))
  def createConnection(request: CreateConnectionRequest): ZIO[DirectConnect, AwsError, CreateConnectionResponse.ReadOnly] = ZIO.accessM(_.get.createConnection(request))
  def confirmPublicVirtualInterface(request: ConfirmPublicVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, ConfirmPublicVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.confirmPublicVirtualInterface(request))
  def startBgpFailoverTest(request: StartBgpFailoverTestRequest): ZIO[DirectConnect, AwsError, StartBgpFailoverTestResponse.ReadOnly] = ZIO.accessM(_.get.startBgpFailoverTest(request))
  def deleteDirectConnectGatewayAssociation(request: DeleteDirectConnectGatewayAssociationRequest): ZIO[DirectConnect, AwsError, DeleteDirectConnectGatewayAssociationResponse.ReadOnly] = ZIO.accessM(_.get.deleteDirectConnectGatewayAssociation(request))
  def updateLag(request: UpdateLagRequest): ZIO[DirectConnect, AwsError, UpdateLagResponse.ReadOnly] = ZIO.accessM(_.get.updateLag(request))
  def deleteBGPPeer(request: DeleteBgpPeerRequest): ZIO[DirectConnect, AwsError, DeleteBgpPeerResponse.ReadOnly] = ZIO.accessM(_.get.deleteBGPPeer(request))
  def confirmConnection(request: ConfirmConnectionRequest): ZIO[DirectConnect, AwsError, ConfirmConnectionResponse.ReadOnly] = ZIO.accessM(_.get.confirmConnection(request))
  def describeDirectConnectGatewayAssociations(request: DescribeDirectConnectGatewayAssociationsRequest): ZIO[DirectConnect, AwsError, DescribeDirectConnectGatewayAssociationsResponse.ReadOnly] = ZIO.accessM(_.get.describeDirectConnectGatewayAssociations(request))
  def acceptDirectConnectGatewayAssociationProposal(request: AcceptDirectConnectGatewayAssociationProposalRequest): ZIO[DirectConnect, AwsError, AcceptDirectConnectGatewayAssociationProposalResponse.ReadOnly] = ZIO.accessM(_.get.acceptDirectConnectGatewayAssociationProposal(request))
  def allocatePublicVirtualInterface(request: AllocatePublicVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, AllocatePublicVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.allocatePublicVirtualInterface(request))
  def deleteVirtualInterface(request: DeleteVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, DeleteVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.deleteVirtualInterface(request))
  def createPublicVirtualInterface(request: CreatePublicVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, CreatePublicVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.createPublicVirtualInterface(request))
  def deleteInterconnect(request: DeleteInterconnectRequest): ZIO[DirectConnect, AwsError, DeleteInterconnectResponse.ReadOnly] = ZIO.accessM(_.get.deleteInterconnect(request))
  def untagResource(request: UntagResourceRequest): ZIO[DirectConnect, AwsError, UntagResourceResponse.ReadOnly] = ZIO.accessM(_.get.untagResource(request))
  def deleteLag(request: DeleteLagRequest): ZIO[DirectConnect, AwsError, DeleteLagResponse.ReadOnly] = ZIO.accessM(_.get.deleteLag(request))
  def describeVirtualInterfaces(request: DescribeVirtualInterfacesRequest): ZIO[DirectConnect, AwsError, DescribeVirtualInterfacesResponse.ReadOnly] = ZIO.accessM(_.get.describeVirtualInterfaces(request))
  def describeInterconnects(request: DescribeInterconnectsRequest): ZIO[DirectConnect, AwsError, DescribeInterconnectsResponse.ReadOnly] = ZIO.accessM(_.get.describeInterconnects(request))
  def deleteDirectConnectGateway(request: DeleteDirectConnectGatewayRequest): ZIO[DirectConnect, AwsError, DeleteDirectConnectGatewayResponse.ReadOnly] = ZIO.accessM(_.get.deleteDirectConnectGateway(request))
  def createPrivateVirtualInterface(request: CreatePrivateVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, CreatePrivateVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.createPrivateVirtualInterface(request))
  def describeLags(request: DescribeLagsRequest): ZIO[DirectConnect, AwsError, DescribeLagsResponse.ReadOnly] = ZIO.accessM(_.get.describeLags(request))
  def describeLocations(): ZIO[DirectConnect, AwsError, DescribeLocationsResponse.ReadOnly] = ZIO.accessM(_.get.describeLocations())
  def createBGPPeer(request: CreateBgpPeerRequest): ZIO[DirectConnect, AwsError, CreateBgpPeerResponse.ReadOnly] = ZIO.accessM(_.get.createBGPPeer(request))
  def allocateTransitVirtualInterface(request: AllocateTransitVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, AllocateTransitVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.allocateTransitVirtualInterface(request))
  def associateVirtualInterface(request: AssociateVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, AssociateVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.associateVirtualInterface(request))
  def confirmPrivateVirtualInterface(request: ConfirmPrivateVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, ConfirmPrivateVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.confirmPrivateVirtualInterface(request))
  def updateDirectConnectGatewayAssociation(request: UpdateDirectConnectGatewayAssociationRequest): ZIO[DirectConnect, AwsError, UpdateDirectConnectGatewayAssociationResponse.ReadOnly] = ZIO.accessM(_.get.updateDirectConnectGatewayAssociation(request))
  def deleteConnection(request: DeleteConnectionRequest): ZIO[DirectConnect, AwsError, DeleteConnectionResponse.ReadOnly] = ZIO.accessM(_.get.deleteConnection(request))
  def tagResource(request: TagResourceRequest): ZIO[DirectConnect, AwsError, TagResourceResponse.ReadOnly] = ZIO.accessM(_.get.tagResource(request))
  def deleteDirectConnectGatewayAssociationProposal(request: DeleteDirectConnectGatewayAssociationProposalRequest): ZIO[DirectConnect, AwsError, DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly] = ZIO.accessM(_.get.deleteDirectConnectGatewayAssociationProposal(request))
  def updateVirtualInterfaceAttributes(request: UpdateVirtualInterfaceAttributesRequest): ZIO[DirectConnect, AwsError, UpdateVirtualInterfaceAttributesResponse.ReadOnly] = ZIO.accessM(_.get.updateVirtualInterfaceAttributes(request))
  def confirmTransitVirtualInterface(request: ConfirmTransitVirtualInterfaceRequest): ZIO[DirectConnect, AwsError, ConfirmTransitVirtualInterfaceResponse.ReadOnly] = ZIO.accessM(_.get.confirmTransitVirtualInterface(request))
  def describeVirtualGateways(): ZIO[DirectConnect, AwsError, DescribeVirtualGatewaysResponse.ReadOnly] = ZIO.accessM(_.get.describeVirtualGateways())
  def describeDirectConnectGatewayAssociationProposals(request: DescribeDirectConnectGatewayAssociationProposalsRequest): ZIO[DirectConnect, AwsError, DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly] = ZIO.accessM(_.get.describeDirectConnectGatewayAssociationProposals(request))
  def describeConnections(request: DescribeConnectionsRequest): ZIO[DirectConnect, AwsError, DescribeConnectionsResponse.ReadOnly] = ZIO.accessM(_.get.describeConnections(request))
  def createDirectConnectGatewayAssociation(request: CreateDirectConnectGatewayAssociationRequest): ZIO[DirectConnect, AwsError, CreateDirectConnectGatewayAssociationResponse.ReadOnly] = ZIO.accessM(_.get.createDirectConnectGatewayAssociation(request))
  def createInterconnect(request: CreateInterconnectRequest): ZIO[DirectConnect, AwsError, CreateInterconnectResponse.ReadOnly] = ZIO.accessM(_.get.createInterconnect(request))
  def createDirectConnectGatewayAssociationProposal(request: CreateDirectConnectGatewayAssociationProposalRequest): ZIO[DirectConnect, AwsError, CreateDirectConnectGatewayAssociationProposalResponse.ReadOnly] = ZIO.accessM(_.get.createDirectConnectGatewayAssociationProposal(request))
  def createLag(request: CreateLagRequest): ZIO[DirectConnect, AwsError, CreateLagResponse.ReadOnly] = ZIO.accessM(_.get.createLag(request))
  def associateConnectionWithLag(request: AssociateConnectionWithLagRequest): ZIO[DirectConnect, AwsError, AssociateConnectionWithLagResponse.ReadOnly] = ZIO.accessM(_.get.associateConnectionWithLag(request))
  def describeLoa(request: DescribeLoaRequest): ZIO[DirectConnect, AwsError, DescribeLoaResponse.ReadOnly] = ZIO.accessM(_.get.describeLoa(request))
}