package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddSourceIdentifierToSubscriptionRequest(subscriptionName: String, sourceIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest = {
    import AddSourceIdentifierToSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).sourceIdentifier(sourceIdentifier: java.lang.String).build()
  }
  def asReadOnly: AddSourceIdentifierToSubscriptionRequest.ReadOnly = AddSourceIdentifierToSubscriptionRequest.wrap(buildAwsValue())
}
object AddSourceIdentifierToSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddSourceIdentifierToSubscriptionRequest = AddSourceIdentifierToSubscriptionRequest(subscriptionNameValue, sourceIdentifierValue)
    def subscriptionNameValue: String
    def sourceIdentifierValue: String
    def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
    def sourceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest) extends AddSourceIdentifierToSubscriptionRequest.ReadOnly {
    override def subscriptionNameValue: String = impl.subscriptionName(): String
    override def sourceIdentifierValue: String = impl.sourceIdentifier(): String
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest): ReadOnly = new Wrapper(impl)
}