package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddTagsToResourceRequest(resourceName: String, tags: Iterable[Tag]) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest.builder().resourceName(resourceName: java.lang.String).tags(tags.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: AddTagsToResourceRequest.ReadOnly = AddTagsToResourceRequest.wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddTagsToResourceRequest = AddTagsToResourceRequest(resourceNameValue, tagsValue.map { item => 
      item.editable
    })
    def resourceNameValue: String
    def tagsValue: List[Tag.ReadOnly]
    def resourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceNameValue)
    def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest) extends AddTagsToResourceRequest.ReadOnly {
    override def resourceNameValue: String = impl.resourceName(): String
    override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
      Tag.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest): ReadOnly = new Wrapper(impl)
}