package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ApplyMethod { def unwrap: software.amazon.awssdk.services.docdb.model.ApplyMethod }
object ApplyMethod {
  def wrap(value: software.amazon.awssdk.services.docdb.model.ApplyMethod): ApplyMethod = value match {
    case software.amazon.awssdk.services.docdb.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.docdb.model.ApplyMethod.IMMEDIATE =>
      val r = immediate
      r
    case software.amazon.awssdk.services.docdb.model.ApplyMethod.PENDING_REBOOT =>
      val r = `pending-reboot`
      r
  }
  case object unknownToSdkVersion extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.docdb.model.ApplyMethod = software.amazon.awssdk.services.docdb.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION }
  case object immediate extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.docdb.model.ApplyMethod = software.amazon.awssdk.services.docdb.model.ApplyMethod.IMMEDIATE }
  case object `pending-reboot` extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.docdb.model.ApplyMethod = software.amazon.awssdk.services.docdb.model.ApplyMethod.PENDING_REBOOT }
}