package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ApplyPendingMaintenanceActionRequest(resourceIdentifier: String, applyAction: String, optInType: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest = {
    import ApplyPendingMaintenanceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest.builder().resourceIdentifier(resourceIdentifier: java.lang.String).applyAction(applyAction: java.lang.String).optInType(optInType: java.lang.String).build()
  }
  def asReadOnly: ApplyPendingMaintenanceActionRequest.ReadOnly = ApplyPendingMaintenanceActionRequest.wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ApplyPendingMaintenanceActionRequest = ApplyPendingMaintenanceActionRequest(resourceIdentifierValue, applyActionValue, optInTypeValue)
    def resourceIdentifierValue: String
    def applyActionValue: String
    def optInTypeValue: String
    def resourceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(resourceIdentifierValue)
    def applyAction: ZIO[Any, Nothing, String] = ZIO.succeed(applyActionValue)
    def optInType: ZIO[Any, Nothing, String] = ZIO.succeed(optInTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest) extends ApplyPendingMaintenanceActionRequest.ReadOnly {
    override def resourceIdentifierValue: String = impl.resourceIdentifier(): String
    override def applyActionValue: String = impl.applyAction(): String
    override def optInTypeValue: String = impl.optInType(): String
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest): ReadOnly = new Wrapper(impl)
}