package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Certificate(certificateIdentifier: scala.Option[String] = None, certificateType: scala.Option[String] = None, thumbprint: scala.Option[String] = None, validFrom: scala.Option[primitives.TStamp] = None, validTill: scala.Option[primitives.TStamp] = None, certificateArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Certificate.builder().optionallyWith(certificateIdentifier.map(value => value: java.lang.String))(_.certificateIdentifier).optionallyWith(certificateType.map(value => value: java.lang.String))(_.certificateType).optionallyWith(thumbprint.map(value => value: java.lang.String))(_.thumbprint).optionallyWith(validFrom.map(value => value: java.time.Instant))(_.validFrom).optionallyWith(validTill.map(value => value: java.time.Instant))(_.validTill).optionallyWith(certificateArn.map(value => value: java.lang.String))(_.certificateArn).build()
  }
  def asReadOnly: Certificate.ReadOnly = Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.Certificate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Certificate = Certificate(certificateIdentifierValue.map(value => value), certificateTypeValue.map(value => value), thumbprintValue.map(value => value), validFromValue.map(value => value), validTillValue.map(value => value), certificateArnValue.map(value => value))
    def certificateIdentifierValue: scala.Option[String]
    def certificateTypeValue: scala.Option[String]
    def thumbprintValue: scala.Option[String]
    def validFromValue: scala.Option[primitives.TStamp]
    def validTillValue: scala.Option[primitives.TStamp]
    def certificateArnValue: scala.Option[String]
    def certificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifierValue)
    def certificateType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateType", certificateTypeValue)
    def thumbprint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("thumbprint", thumbprintValue)
    def validFrom: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validFrom", validFromValue)
    def validTill: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validTill", validTillValue)
    def certificateArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateArn", certificateArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.Certificate) extends Certificate.ReadOnly {
    override def certificateIdentifierValue: scala.Option[String] = scala.Option(impl.certificateIdentifier()).map(value => value: String)
    override def certificateTypeValue: scala.Option[String] = scala.Option(impl.certificateType()).map(value => value: String)
    override def thumbprintValue: scala.Option[String] = scala.Option(impl.thumbprint()).map(value => value: String)
    override def validFromValue: scala.Option[primitives.TStamp] = scala.Option(impl.validFrom()).map(value => value: primitives.TStamp)
    override def validTillValue: scala.Option[primitives.TStamp] = scala.Option(impl.validTill()).map(value => value: primitives.TStamp)
    override def certificateArnValue: scala.Option[String] = scala.Option(impl.certificateArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.Certificate): ReadOnly = new Wrapper(impl)
}