package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloudwatchLogsExportConfiguration(enableLogTypes: scala.Option[Iterable[String]] = None, disableLogTypes: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration = {
    import CloudwatchLogsExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration.builder().optionallyWith(enableLogTypes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.enableLogTypes).optionallyWith(disableLogTypes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.disableLogTypes).build()
  }
  def asReadOnly: CloudwatchLogsExportConfiguration.ReadOnly = CloudwatchLogsExportConfiguration.wrap(buildAwsValue())
}
object CloudwatchLogsExportConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration(enableLogTypesValue.map(value => value), disableLogTypesValue.map(value => value))
    def enableLogTypesValue: scala.Option[List[String]]
    def disableLogTypesValue: scala.Option[List[String]]
    def enableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableLogTypes", enableLogTypesValue)
    def disableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disableLogTypes", disableLogTypesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration) extends CloudwatchLogsExportConfiguration.ReadOnly {
    override def enableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.enableLogTypes()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def disableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.disableLogTypes()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CloudwatchLogsExportConfiguration): ReadOnly = new Wrapper(impl)
}