package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CopyDbClusterParameterGroupRequest(sourceDBClusterParameterGroupIdentifier: String, targetDBClusterParameterGroupIdentifier: String, targetDBClusterParameterGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest = {
    import CopyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest.builder().sourceDBClusterParameterGroupIdentifier(sourceDBClusterParameterGroupIdentifier: java.lang.String).targetDBClusterParameterGroupIdentifier(targetDBClusterParameterGroupIdentifier: java.lang.String).targetDBClusterParameterGroupDescription(targetDBClusterParameterGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CopyDbClusterParameterGroupRequest.ReadOnly = CopyDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object CopyDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CopyDbClusterParameterGroupRequest = CopyDbClusterParameterGroupRequest(sourceDBClusterParameterGroupIdentifierValue, targetDBClusterParameterGroupIdentifierValue, targetDBClusterParameterGroupDescriptionValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def sourceDBClusterParameterGroupIdentifierValue: String
    def targetDBClusterParameterGroupIdentifierValue: String
    def targetDBClusterParameterGroupDescriptionValue: String
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def sourceDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBClusterParameterGroupIdentifierValue)
    def targetDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterParameterGroupIdentifierValue)
    def targetDBClusterParameterGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterParameterGroupDescriptionValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest) extends CopyDbClusterParameterGroupRequest.ReadOnly {
    override def sourceDBClusterParameterGroupIdentifierValue: String = impl.sourceDBClusterParameterGroupIdentifier(): String
    override def targetDBClusterParameterGroupIdentifierValue: String = impl.targetDBClusterParameterGroupIdentifier(): String
    override def targetDBClusterParameterGroupDescriptionValue: String = impl.targetDBClusterParameterGroupDescription(): String
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
}